/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.protocols.icmp;

import java.util.Date;
import org.opennms.protocols.icmp.ICMPHeader;
import org.opennms.protocols.ip.OC16ChecksumProducer;

public final class TimestampRequest
extends ICMPHeader {
    private int m_origStamp;

    public TimestampRequest() {
        super((byte)13, (byte)0);
        this.m_origStamp = (int)(new Date().getTime() & 0xFFFFFFFFFFFFFFFFL);
    }

    public TimestampRequest(byte[] byArray, int n) {
        this.loadFromBuffer(byArray, n);
    }

    public final void computeChecksum() {
        OC16ChecksumProducer oC16ChecksumProducer = new OC16ChecksumProducer();
        super.computeChecksum(oC16ChecksumProducer);
        oC16ChecksumProducer.add(this.m_origStamp);
        oC16ChecksumProducer.add(0);
        oC16ChecksumProducer.add(0);
        this.setChecksum(oC16ChecksumProducer.getChecksum());
    }

    public final int storeToBuffer(byte[] byArray, int n) {
        if (byArray.length < n + 20) {
            throw new IndexOutOfBoundsException("Array index overflow in buffer build");
        }
        this.computeChecksum();
        n = super.storeToBuffer(byArray, n);
        byArray[n++] = (byte)(this.m_origStamp >> 24 & 0xFF);
        byArray[n++] = (byte)(this.m_origStamp >> 16 & 0xFF);
        byArray[n++] = (byte)(this.m_origStamp >> 8 & 0xFF);
        byArray[n++] = (byte)(this.m_origStamp & 0xFF);
        for (int i = 0; i < 8; ++i) {
            byArray[n++] = 0;
        }
        return n;
    }

    public final int loadFromBuffer(byte[] byArray, int n) {
        if (byArray.length < n + 20) {
            throw new IndexOutOfBoundsException("Insufficient data to load ICMP header");
        }
        n = super.loadFromBuffer(byArray, n);
        if (this.getType() != 13) {
            throw new IllegalArgumentException("The buffer did not contain an Timestamp Request");
        }
        this.m_origStamp = TimestampRequest.byteToInt(byArray[n++]) << 24 | TimestampRequest.byteToInt(byArray[n++]) << 16 | TimestampRequest.byteToInt(byArray[n++]) << 8 | TimestampRequest.byteToInt(byArray[n++]);
        return n += 8;
    }

    public final void setOriginateTS() {
        this.m_origStamp = (int)(new Date().getTime() & 0xFFFFFFFFFFFFFFFFL);
    }

    public final void setOriginateTS(int n) {
        this.m_origStamp = n;
    }

    public final int getOriginateTS() {
        return this.m_origStamp;
    }

    public final byte[] toBytes() {
        byte[] byArray = new byte[20];
        this.storeToBuffer(byArray, 0);
        return byArray;
    }
}

