/*
 * Decompiled with CFR 0.152.
 */
package mx4j.remote.rmi;

import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Map;
import javax.management.remote.NotificationResult;
import javax.management.remote.rmi.RMIConnection;
import mx4j.remote.AbstractRemoteNotificationClientHandler;
import mx4j.remote.ConnectionNotificationEmitter;
import mx4j.remote.HeartBeat;

public class RMIRemoteNotificationClientHandler
extends AbstractRemoteNotificationClientHandler {
    private final RMIConnection connection;
    private final ClassLoader defaultLoader;

    public RMIRemoteNotificationClientHandler(RMIConnection connection, ClassLoader defaultLoader, ConnectionNotificationEmitter emitter, HeartBeat heartbeat, Map environment) {
        super(emitter, heartbeat, environment);
        this.connection = connection;
        this.defaultLoader = defaultLoader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected NotificationResult fetchNotifications(long sequence, int maxNumber, long timeout) throws IOException {
        ClassLoader currentLoader = Thread.currentThread().getContextClassLoader();
        if (this.defaultLoader == null || this.defaultLoader.equals(currentLoader)) {
            return this.invokeFetchNotifications(sequence, maxNumber, timeout);
        }
        try {
            this.setContextClassLoader(this.defaultLoader);
            NotificationResult notificationResult = this.invokeFetchNotifications(sequence, maxNumber, timeout);
            return notificationResult;
        }
        finally {
            this.setContextClassLoader(currentLoader);
        }
    }

    private NotificationResult invokeFetchNotifications(long sequence, int maxNumber, long timeout) throws IOException {
        return this.connection.fetchNotifications(sequence, maxNumber, timeout);
    }

    private void setContextClassLoader(final ClassLoader loader) {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                Thread.currentThread().setContextClassLoader(loader);
                return null;
            }
        });
    }
}

