/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.dao.castor;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Marshaller;
import org.exolab.castor.xml.Unmarshaller;
import org.exolab.castor.xml.ValidationException;
import org.opennms.netmgt.dao.castor.CastorExceptionTranslator;
import org.springframework.dao.DataAccessException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CastorUtils {
    private static final CastorExceptionTranslator CASTOR_EXCEPTION_TRANSLATOR = new CastorExceptionTranslator();

    private CastorUtils() {
    }

    public static void marshalWithTranslatedExceptions(Object obj, Writer writer) throws DataAccessException {
        try {
            Marshaller.marshal((Object)obj, (Writer)writer);
        }
        catch (MarshalException e) {
            throw CASTOR_EXCEPTION_TRANSLATOR.translate("Marshalling XML file", e);
        }
        catch (ValidationException e) {
            throw CASTOR_EXCEPTION_TRANSLATOR.translate("Marshalling XML file", e);
        }
    }

    public static <T> T unmarshal(Class<T> clazz, Reader reader) throws MarshalException, ValidationException {
        return (T)Unmarshaller.unmarshal(clazz, (Reader)reader);
    }

    public static <T> T unmarshalWithTranslatedExceptions(Class<T> clazz, Reader reader) throws DataAccessException {
        try {
            return (T)Unmarshaller.unmarshal(clazz, (Reader)reader);
        }
        catch (MarshalException e) {
            throw CASTOR_EXCEPTION_TRANSLATOR.translate("Unmarshalling XML file", e);
        }
        catch (ValidationException e) {
            throw CASTOR_EXCEPTION_TRANSLATOR.translate("Unmarshalling XML file", e);
        }
    }

    public static void marshalViaString(Object config, File cfgFile) throws MarshalException, ValidationException, IOException {
        StringWriter stringWriter = new StringWriter();
        Marshaller.marshal((Object)config, (Writer)stringWriter);
        FileWriter fileWriter = new FileWriter(cfgFile);
        fileWriter.write(stringWriter.toString());
        fileWriter.flush();
        fileWriter.close();
    }
}

