/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config;

import java.beans.PropertyVetoException;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.ValidationException;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.ConfigFileConstants;
import org.opennms.netmgt.config.C3P0ConnectionFactory;
import org.springframework.jdbc.datasource.LazyConnectionDataSourceProxy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DataSourceFactory
implements DataSource {
    private static DataSource m_singleton = null;
    private static Map<String, DataSource> m_dataSources = new HashMap<String, DataSource>();
    private static List<Runnable> m_closers = new LinkedList<Runnable>();

    public static synchronized void init() throws IOException, MarshalException, ValidationException, ClassNotFoundException, PropertyVetoException, SQLException {
        if (!DataSourceFactory.isLoaded("opennms")) {
            DataSourceFactory.init("opennms");
        }
    }

    public static synchronized void init(final String dsName) throws IOException, MarshalException, ValidationException, ClassNotFoundException, PropertyVetoException, SQLException {
        if (DataSourceFactory.isLoaded(dsName)) {
            return;
        }
        File cfgFile = ConfigFileConstants.getFile((int)ConfigFileConstants.OPENNMS_DATASOURCE_CONFIG_FILE_NAME);
        final C3P0ConnectionFactory dataSource = new C3P0ConnectionFactory(cfgFile.getPath(), dsName);
        m_closers.add(new Runnable(){

            public void run() {
                try {
                    dataSource.close();
                }
                catch (Exception e) {
                    ThreadCategory.getInstance(DataSourceFactory.class).info((Object)("Unabled to close datasource " + dsName));
                }
            }
        });
        LazyConnectionDataSourceProxy lazyProxy = new LazyConnectionDataSourceProxy((DataSource)dataSource);
        DataSourceFactory.setInstance(dsName, (DataSource)lazyProxy);
    }

    private static boolean isLoaded(String dsName) {
        return m_dataSources.containsKey(dsName);
    }

    public static synchronized DataSource getInstance() {
        return DataSourceFactory.getInstance("opennms");
    }

    public static synchronized DataSource getInstance(String name) {
        DataSource dataSource = m_dataSources.get(name);
        if (dataSource == null) {
            throw new IllegalArgumentException("Unable to locate data source named " + name + ".  Does this need to be init'd?");
        }
        return m_dataSources.get(name);
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.getConnection("opennms");
    }

    public Connection getConnection(String dsName) throws SQLException {
        return m_dataSources.get(dsName).getConnection();
    }

    public static void setInstance(DataSource singleton) {
        m_singleton = singleton;
        DataSourceFactory.setInstance("opennms", singleton);
    }

    public static void setInstance(String dsName, DataSource singleton) {
        m_dataSources.put(dsName, singleton);
    }

    public static DataSource getDataSource() {
        return DataSourceFactory.getDataSource("opennms");
    }

    public static DataSource getDataSource(String dsName) {
        return m_dataSources.get(dsName);
    }

    @Override
    public Connection getConnection(String username, String password) throws SQLException {
        return this.getConnection();
    }

    @Override
    public PrintWriter getLogWriter() throws SQLException {
        return m_singleton.getLogWriter();
    }

    public PrintWriter getLogWriter(String dsName) throws SQLException {
        return m_dataSources.get(dsName).getLogWriter();
    }

    @Override
    public void setLogWriter(PrintWriter out) throws SQLException {
        this.setLogWriter("opennms", out);
    }

    public void setLogWriter(String dsName, PrintWriter out) throws SQLException {
        m_dataSources.get(dsName).setLogWriter(out);
    }

    @Override
    public void setLoginTimeout(int seconds) throws SQLException {
        this.setLoginTimeout("opennms", seconds);
    }

    public void setLoginTimeout(String dsName, int seconds) throws SQLException {
        m_dataSources.get(dsName).setLoginTimeout(seconds);
    }

    @Override
    public int getLoginTimeout() throws SQLException {
        return this.getLoginTimeout("opennms");
    }

    public int getLoginTimeout(String dsName) throws SQLException {
        return m_dataSources.get(dsName).getLoginTimeout();
    }

    public void initialize() throws MarshalException, ValidationException, IOException, ClassNotFoundException {
    }

    public static synchronized void close() throws SQLException {
        for (Runnable closer : m_closers) {
            closer.run();
        }
        m_closers.clear();
        m_dataSources.clear();
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return null;
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return false;
    }
}

