/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config;

import com.mchange.v2.c3p0.ComboPooledDataSource;
import java.beans.PropertyVetoException;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import java.util.Properties;
import javax.sql.DataSource;
import org.apache.log4j.Category;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.ValidationException;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.config.ClosableDataSource;
import org.opennms.netmgt.config.opennmsDataSources.DataSourceConfiguration;
import org.opennms.netmgt.config.opennmsDataSources.JdbcDataSource;
import org.opennms.netmgt.config.opennmsDataSources.Param;
import org.opennms.netmgt.dao.castor.CastorUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class C3P0ConnectionFactory
implements ClosableDataSource {
    private ComboPooledDataSource m_pool;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected C3P0ConnectionFactory(Reader rdr, String dsName) throws MarshalException, ValidationException, PropertyVetoException, SQLException {
        this.log().info((Object)"C3P0ConnectionFactory: setting up data sources from reader argument.");
        JdbcDataSource ds = this.marshalDataSourceFromConfig(rdr, dsName);
        this.initializePool(ds);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected C3P0ConnectionFactory(String configFile, String dsName) throws IOException, MarshalException, ValidationException, PropertyVetoException, SQLException {
        FileInputStream fileInputStream = new FileInputStream(configFile);
        InputStreamReader rdr = new InputStreamReader(fileInputStream);
        this.log().info((Object)("C3P0ConnectionFactory: setting up data sources from:" + configFile));
        try {
            JdbcDataSource ds = this.marshalDataSourceFromConfig(rdr, dsName);
            this.initializePool(ds);
        }
        finally {
            ((Reader)rdr).close();
            fileInputStream.close();
        }
    }

    protected JdbcDataSource marshalDataSourceFromConfig(Reader rdr, String dsName) throws MarshalException, ValidationException, PropertyVetoException, SQLException {
        DataSourceConfiguration dsc = CastorUtils.unmarshal(DataSourceConfiguration.class, rdr);
        JdbcDataSource ds = null;
        for (JdbcDataSource jdbcDs : this.getJdbcDataSources(dsc)) {
            this.log().debug((Object)("marshalDataSource: comparing collection entry:" + jdbcDs.getName() + " with requested ds:" + dsName));
            if (!jdbcDs.getName().equals(dsName)) continue;
            ds = jdbcDs;
            break;
        }
        if (ds == null) {
            throw new IllegalArgumentException("C3P0ConnectionFactory: DataSource: " + dsName + " is not defined.");
        }
        return ds;
    }

    private List<JdbcDataSource> getJdbcDataSources(DataSourceConfiguration dsc) {
        return dsc.getJdbcDataSourceCollection();
    }

    private Category log() {
        return ThreadCategory.getInstance(this.getClass());
    }

    private void initializePool(JdbcDataSource ds) throws PropertyVetoException, SQLException {
        this.m_pool = new ComboPooledDataSource();
        this.m_pool.setPassword(ds.getPassword());
        this.m_pool.setUser(ds.getUserName());
        this.m_pool.setJdbcUrl(ds.getUrl());
        this.m_pool.setDriverClass(ds.getClassName());
        Properties props = new Properties();
        for (Param p : this.getParamsForJdbcDataSource(ds)) {
            props.put(p.getName(), p.getValue());
        }
        if (!props.isEmpty()) {
            this.m_pool.setProperties(props);
        }
    }

    private List<Param> getParamsForJdbcDataSource(JdbcDataSource ds) {
        return ds.getParamCollection();
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.m_pool.getConnection();
    }

    public ComboPooledDataSource getPool() {
        return this.m_pool;
    }

    public void setPool(ComboPooledDataSource pool) {
        this.m_pool = pool;
    }

    public String getUrl() {
        return this.m_pool.getJdbcUrl();
    }

    public void setUrl(String url) {
        this.m_pool.setJdbcUrl(url);
    }

    public String getUser() {
        return this.m_pool.getUser();
    }

    public void setUser(String user) {
        this.m_pool.setUser(user);
    }

    public DataSource getDataSource() {
        return this.m_pool;
    }

    @Override
    public Connection getConnection(String username, String password) throws SQLException {
        return this.m_pool.getConnection(username, password);
    }

    @Override
    public PrintWriter getLogWriter() throws SQLException {
        return this.m_pool.getLogWriter();
    }

    @Override
    public void setLogWriter(PrintWriter out) throws SQLException {
        this.m_pool.setLogWriter(out);
    }

    @Override
    public void setLoginTimeout(int seconds) throws SQLException {
        this.m_pool.setLoginTimeout(seconds);
    }

    @Override
    public int getLoginTimeout() throws SQLException {
        return this.m_pool.getLoginTimeout();
    }

    @Override
    public void close() throws SQLException {
        this.log().info((Object)"Closing c3p0 pool");
        this.m_pool.close(true);
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return null;
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return false;
    }
}

