/*
 * Decompiled with CFR 0.152.
 */
package mx4j.monitor;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.NotCompliantMBeanException;
import javax.management.Notification;
import javax.management.NotificationBroadcasterSupport;
import javax.management.NotificationEmitter;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.StandardMBean;
import mx4j.log.Log;
import mx4j.log.Logger;
import mx4j.monitor.MX4JMonitorMBean;
import mx4j.monitor.MX4JMonitorNotification;
import mx4j.timer.TimeQueue;
import mx4j.timer.TimeTask;

public abstract class MX4JMonitor
extends StandardMBean
implements MX4JMonitorMBean,
MBeanRegistration,
NotificationEmitter {
    private static final TimeQueue queue = new TimeQueue();
    private static int references = 0;
    private static int sequenceNumber;
    private NotificationBroadcasterSupport emitter;
    private MBeanServer server;
    private boolean active;
    private List observeds = new ArrayList();
    private volatile String attribute;
    private volatile long granularity = 10000L;
    private boolean errorNotified;
    private final TimeTask task = new MonitorTask();
    private final Map infos = new HashMap();
    static /* synthetic */ Class class$mx4j$monitor$MX4JMonitor;

    protected MX4JMonitor(Class management) throws NotCompliantMBeanException {
        super(management);
    }

    public ObjectName preRegister(MBeanServer server, ObjectName name) {
        this.server = server;
        return name;
    }

    public void postRegister(Boolean registrationDone) {
    }

    public void preDeregister() {
        this.stop();
    }

    public void postDeregister() {
        this.server = null;
    }

    protected NotificationBroadcasterSupport createNotificationEmitter() {
        return new NotificationBroadcasterSupport();
    }

    public void addNotificationListener(NotificationListener listener, NotificationFilter filter, Object handback) throws IllegalArgumentException {
        this.emitter.addNotificationListener(listener, filter, handback);
    }

    public void removeNotificationListener(NotificationListener listener) throws ListenerNotFoundException {
        this.emitter.removeNotificationListener(listener);
    }

    public void removeNotificationListener(NotificationListener listener, NotificationFilter filter, Object handback) throws ListenerNotFoundException {
        this.emitter.removeNotificationListener(listener, filter, handback);
    }

    public void sendNotification(Notification notification) {
        this.emitter.sendNotification(notification);
    }

    public synchronized void start() {
        if (this.isActive()) {
            return;
        }
        this.active = true;
        Iterator i = this.infos.values().iterator();
        while (i.hasNext()) {
            MonitorInfo info = (MonitorInfo)i.next();
            info.clearNotificationStatus();
        }
        this.startMonitor();
    }

    public synchronized void stop() {
        if (!this.isActive()) {
            return;
        }
        this.active = false;
        this.stopMonitor();
    }

    public synchronized boolean isActive() {
        return this.active;
    }

    public synchronized void addObservedObject(ObjectName name) throws IllegalArgumentException {
        if (name == null) {
            throw new IllegalArgumentException("Observed ObjectName cannot be null");
        }
        if (!this.containsObservedObject(name)) {
            this.observeds.add(name);
            this.putMonitorInfo(name, this.createMonitorInfo());
        }
    }

    public synchronized void removeObservedObject(ObjectName name) {
        this.observeds.remove(name);
        this.removeMonitorInfo(name);
    }

    public synchronized boolean containsObservedObject(ObjectName name) {
        return this.observeds.contains(name);
    }

    public synchronized ObjectName[] getObservedObjects() {
        return this.observeds.toArray(new ObjectName[this.observeds.size()]);
    }

    public synchronized void clearObservedObjects() {
        this.observeds.clear();
    }

    public synchronized String getObservedAttribute() {
        return this.attribute;
    }

    public synchronized void setObservedAttribute(String attribute) {
        this.attribute = attribute;
    }

    public synchronized long getGranularityPeriod() {
        return this.granularity;
    }

    public synchronized void setGranularityPeriod(long granularity) throws IllegalArgumentException {
        if (granularity <= 0L) {
            throw new IllegalArgumentException("Granularity must be greater than zero");
        }
        this.granularity = granularity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void startMonitor() {
        TimeQueue timeQueue = queue;
        synchronized (timeQueue) {
            if (references == 0) {
                queue.start();
            }
            ++references;
        }
        if (this.emitter == null) {
            this.emitter = this.createNotificationEmitter();
        }
        queue.schedule(this.task);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void stopMonitor() {
        queue.unschedule(this.task);
        TimeQueue timeQueue = queue;
        synchronized (timeQueue) {
            if (--references == 0) {
                queue.stop();
            }
        }
    }

    protected Logger getLogger() {
        return Log.getLogger(this.getClass().getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sendNotification(String type, String message, ObjectName name, String attribute, Object gauge, Object trigger) {
        int sequence = 0;
        Class clazz = class$mx4j$monitor$MX4JMonitor == null ? (class$mx4j$monitor$MX4JMonitor = MX4JMonitor.class$("mx4j.monitor.MX4JMonitor")) : class$mx4j$monitor$MX4JMonitor;
        synchronized (clazz) {
            sequence = ++sequenceNumber;
        }
        Notification notification = this.createMonitorNotification(type, sequence, message, name, attribute, gauge, trigger);
        this.sendNotification(notification);
    }

    protected Notification createMonitorNotification(String type, long sequence, String message, ObjectName observed, String attribute, Object gauge, Object trigger) {
        return new MX4JMonitorNotification(type, this, sequence, System.currentTimeMillis(), message, observed, attribute, gauge, trigger);
    }

    protected abstract void monitor(ObjectName var1, String var2, Object var3, MonitorInfo var4);

    protected abstract MonitorInfo createMonitorInfo();

    protected synchronized MonitorInfo getMonitorInfo(ObjectName name) {
        return (MonitorInfo)this.infos.get(name);
    }

    protected synchronized void putMonitorInfo(ObjectName name, MonitorInfo info) {
        this.infos.put(name, info);
    }

    protected synchronized void removeMonitorInfo(ObjectName name) {
        this.infos.remove(name);
    }

    protected void sendErrorNotification(MonitorInfo info, String type, String message, ObjectName observed, String attribute) {
        if (!info.isErrorNotified()) {
            info.setErrorNotified(true);
            this.sendNotification(type, message, observed, attribute, null, null);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    protected class MonitorInfo {
        private boolean errorNotified;

        protected MonitorInfo() {
        }

        public boolean isErrorNotified() {
            return this.errorNotified;
        }

        public void setErrorNotified(boolean errorNotified) {
            this.errorNotified = errorNotified;
        }

        public String toString() {
            return "errorNotified=" + this.isErrorNotified();
        }

        public void clearNotificationStatus() {
            this.errorNotified = false;
        }
    }

    private class MonitorTask
    extends TimeTask {
        private MonitorTask() {
        }

        protected boolean isPeriodic() {
            return true;
        }

        protected long getPeriod() {
            return MX4JMonitor.this.getGranularityPeriod();
        }

        public boolean getFixedRate() {
            return true;
        }

        public void run() {
            if (!MX4JMonitor.this.isActive()) {
                return;
            }
            long start = System.currentTimeMillis();
            String attribute = MX4JMonitor.this.getObservedAttribute();
            if (MX4JMonitor.this.server == null) {
                if (!MX4JMonitor.this.errorNotified) {
                    MX4JMonitor.this.errorNotified = true;
                    MX4JMonitor.this.sendNotification("jmx.monitor.error.runtime", "Monitors must be registered in the MBeanServer", null, attribute, null, null);
                }
            } else {
                MX4JMonitor.this.errorNotified = false;
                if (attribute != null) {
                    ObjectName[] names = MX4JMonitor.this.getObservedObjects();
                    for (int i = 0; i < names.length; ++i) {
                        ObjectName name = names[i];
                        MonitorInfo info = MX4JMonitor.this.getMonitorInfo(name);
                        if (info == null) continue;
                        try {
                            Object value = MX4JMonitor.this.server.getAttribute(name, attribute);
                            if (value == null) continue;
                            MX4JMonitor.this.monitor(name, attribute, value, info);
                            continue;
                        }
                        catch (InstanceNotFoundException x) {
                            MX4JMonitor.this.sendErrorNotification(info, "jmx.monitor.error.mbean", "Could not find observed MBean", name, attribute);
                            continue;
                        }
                        catch (AttributeNotFoundException x) {
                            MX4JMonitor.this.sendErrorNotification(info, "jmx.monitor.error.attribute", "Could not find observed attribute " + attribute, name, attribute);
                            continue;
                        }
                        catch (MBeanException x) {
                            MX4JMonitor.this.sendErrorNotification(info, "jmx.monitor.error.runtime", x.toString(), name, attribute);
                            continue;
                        }
                        catch (ReflectionException x) {
                            MX4JMonitor.this.sendErrorNotification(info, "jmx.monitor.error.runtime", x.toString(), name, attribute);
                        }
                    }
                }
            }
            long end = System.currentTimeMillis();
            long elapsed = end - start;
            Logger logger = MX4JMonitor.this.getLogger();
            if (logger.isEnabledFor(10)) {
                logger.debug("Monitored attribute " + attribute + " in " + elapsed + " ms");
            }
        }
    }
}

