/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.core.utils;

import java.net.InetAddress;
import java.net.UnknownHostException;

public abstract class InetAddressUtils {
    public static InetAddress getInetAddress(byte[] ipAddrOctets) {
        try {
            return InetAddress.getByAddress(ipAddrOctets);
        }
        catch (UnknownHostException e) {
            throw new IllegalArgumentException("Invalid IPAddress " + ipAddrOctets + " with length " + ipAddrOctets.length);
        }
    }

    public static InetAddress getInetAddress(String dottedNotation) {
        try {
            return InetAddress.getByName(dottedNotation);
        }
        catch (UnknownHostException e) {
            throw new IllegalArgumentException("Invalid IPAddress " + dottedNotation);
        }
    }

    public static InetAddress getInetAddress(long ipAddrAs32bitNumber) {
        return InetAddressUtils.getInetAddress(InetAddressUtils.toIpAddrBytes(ipAddrAs32bitNumber));
    }

    public static byte[] toIpAddrBytes(long address) {
        byte[] octets = new byte[]{(byte)(address >>> 24 & 0xFFL), (byte)(address >>> 16 & 0xFFL), (byte)(address >>> 8 & 0xFFL), (byte)(address & 0xFFL)};
        return octets;
    }

    public static byte[] toIpAddrBytes(String dottedNotation) {
        return InetAddressUtils.getInetAddress(dottedNotation).getAddress();
    }

    public static byte[] toIpAddrBytes(InetAddress addr) {
        return addr.getAddress();
    }

    public static long toIpAddrLong(byte[] address) {
        if (address.length != 4) {
            throw new IllegalArgumentException("address " + address + " has the wrong length " + address.length);
        }
        long[] octets = new long[address.length];
        octets[0] = InetAddressUtils.unsignedByteToLong(address[0]);
        octets[1] = InetAddressUtils.unsignedByteToLong(address[1]);
        octets[2] = InetAddressUtils.unsignedByteToLong(address[2]);
        octets[3] = InetAddressUtils.unsignedByteToLong(address[3]);
        long result = octets[0] << 24 | octets[1] << 16 | octets[2] << 8 | octets[3];
        return result;
    }

    public static long toIpAddrLong(String dottedNotation) {
        return InetAddressUtils.toIpAddrLong(InetAddressUtils.toIpAddrBytes(dottedNotation));
    }

    public static long toIpAddrLong(InetAddress addr) {
        return InetAddressUtils.toIpAddrLong(addr.getAddress());
    }

    private static long unsignedByteToLong(byte b) {
        return b < 0 ? (long)b + 256L : (long)b;
    }

    public static String toIpAddrString(long ipAddr) {
        return InetAddressUtils.getInetAddress(ipAddr).getHostAddress();
    }

    public static String toIpAddrString(byte[] addr) {
        return InetAddressUtils.getInetAddress(addr).getHostAddress();
    }
}

