/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.core.concurrent;

import org.opennms.core.concurrent.Signaler;

public final class BarrierSignaler
implements Signaler {
    private int m_barrier;
    private int m_counter;

    public BarrierSignaler(int barrier) {
        this.m_barrier = barrier;
        this.m_counter = 0;
    }

    public synchronized void signal() {
        if (++this.m_counter >= this.m_barrier) {
            this.notify();
        }
    }

    public synchronized void signalAll() {
        if (++this.m_counter >= this.m_barrier) {
            this.notifyAll();
        }
    }

    public synchronized void waitFor() throws InterruptedException {
        while (this.m_counter < this.m_barrier) {
            this.wait();
        }
    }

    public synchronized void waitFor(long timeout) throws InterruptedException {
        long now;
        long last = System.currentTimeMillis();
        for (long waitTime = timeout; this.m_counter < this.m_barrier && waitTime > 0L; waitTime -= now - last) {
            this.wait(waitTime);
            now = System.currentTimeMillis();
        }
    }
}

