/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.packet;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.jivesoftware.smack.PacketCollector;
import org.jivesoftware.smack.SmackConfiguration;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.filter.PacketFilter;
import org.jivesoftware.smack.filter.PacketIDFilter;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smack.packet.XMPPError;
import org.jivesoftware.smack.util.StringUtils;

public class VCard
extends IQ {
    private Map homePhones = new HashMap();
    private Map workPhones = new HashMap();
    private Map homeAddr = new HashMap();
    private Map workAddr = new HashMap();
    private String firstName;
    private String lastName;
    private String middleName;
    private String emailHome;
    private String emailWork;
    private String organization;
    private String organizationUnit;
    private String avatar;
    private Map otherSimpleFields = new HashMap();
    private Map otherUnescapableFields = new HashMap();
    static /* synthetic */ Class class$org$jivesoftware$smackx$packet$VCard;

    public String getField(String field) {
        return (String)this.otherSimpleFields.get(field);
    }

    public void setField(String field, String value) {
        this.setField(field, value, false);
    }

    public void setField(String field, String value, boolean isUnescapable) {
        if (!isUnescapable) {
            this.otherSimpleFields.put(field, value);
        } else {
            this.otherUnescapableFields.put(field, value);
        }
    }

    public String getFirstName() {
        return this.firstName;
    }

    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    public String getLastName() {
        return this.lastName;
    }

    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    public String getMiddleName() {
        return this.middleName;
    }

    public void setMiddleName(String middleName) {
        this.middleName = middleName;
    }

    public String getNickName() {
        return (String)this.otherSimpleFields.get("NICKNAME");
    }

    public void setNickName(String nickName) {
        this.otherSimpleFields.put("NICKNAME", nickName);
    }

    public String getEmailHome() {
        return this.emailHome;
    }

    public void setEmailHome(String email) {
        this.emailHome = email;
    }

    public String getEmailWork() {
        return this.emailWork;
    }

    public void setEmailWork(String emailWork) {
        this.emailWork = emailWork;
    }

    public String getJabberId() {
        return (String)this.otherSimpleFields.get("JABBERID");
    }

    public void setJabberId(String jabberId) {
        this.otherSimpleFields.put("JABBERID", jabberId);
    }

    public String getOrganization() {
        return this.organization;
    }

    public void setOrganization(String organization) {
        this.organization = organization;
    }

    public String getOrganizationUnit() {
        return this.organizationUnit;
    }

    public void setOrganizationUnit(String organizationUnit) {
        this.organizationUnit = organizationUnit;
    }

    public String getAddressFieldHome(String addrField) {
        return (String)this.homeAddr.get(addrField);
    }

    public void setAddressFieldHome(String addrField, String value) {
        this.homeAddr.put(addrField, value);
    }

    public String getAddressFieldWork(String addrField) {
        return (String)this.workAddr.get(addrField);
    }

    public void setAddressFieldWork(String addrField, String value) {
        this.workAddr.put(addrField, value);
    }

    public void setPhoneHome(String phoneType, String phoneNum) {
        this.homePhones.put(phoneType, phoneNum);
    }

    public String getPhoneHome(String phoneType) {
        return (String)this.homePhones.get(phoneType);
    }

    public void setPhoneWork(String phoneType, String phoneNum) {
        this.workPhones.put(phoneType, phoneNum);
    }

    public String getPhoneWork(String phoneType) {
        return (String)this.workPhones.get(phoneType);
    }

    public void setAvatar(URL avatarURL) {
        String encodedImage;
        byte[] bytes = new byte[]{};
        try {
            bytes = VCard.getBytes(avatarURL);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.avatar = encodedImage = StringUtils.encodeBase64((byte[])bytes);
        this.setField("PHOTO", "<TYPE>image/jpeg</TYPE><BINVAL>" + encodedImage + "</BINVAL>", true);
    }

    public void setAvatar(byte[] bytes) {
        String encodedImage;
        this.avatar = encodedImage = StringUtils.encodeBase64((byte[])bytes);
        this.setField("PHOTO", "<TYPE>image/jpeg</TYPE><BINVAL>" + encodedImage + "</BINVAL>", true);
    }

    public void setEncodedImage(String encodedAvatar) {
        this.avatar = encodedAvatar;
    }

    public byte[] getAvatar() {
        if (this.avatar == null) {
            return null;
        }
        return StringUtils.decodeBase64((String)this.avatar);
    }

    public static byte[] getBytes(URL url) throws IOException {
        String path = url.getPath();
        File file = new File(path);
        if (file.exists()) {
            return VCard.getFileBytes(file);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] getFileBytes(File file) throws IOException {
        BufferedInputStream bis = null;
        try {
            bis = new BufferedInputStream(new FileInputStream(file));
            int bytes = (int)file.length();
            byte[] buffer = new byte[bytes];
            int readBytes = bis.read(buffer);
            if (readBytes != buffer.length) {
                throw new IOException("Entire file not read");
            }
            byte[] byArray = buffer;
            return byArray;
        }
        finally {
            if (bis != null) {
                bis.close();
            }
        }
    }

    public String getAvatarHash() {
        MessageDigest digest;
        byte[] bytes = this.getAvatar();
        if (bytes == null) {
            return null;
        }
        try {
            digest = MessageDigest.getInstance("SHA-1");
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            return null;
        }
        digest.update(bytes);
        return StringUtils.encodeHex((byte[])digest.digest());
    }

    public void save(XMPPConnection connection) throws XMPPException {
        this.checkAuthenticated(connection);
        this.setType(IQ.Type.SET);
        this.setFrom(connection.getUser());
        PacketCollector collector = connection.createPacketCollector((PacketFilter)new PacketIDFilter(this.getPacketID()));
        connection.sendPacket((Packet)this);
        Packet response = collector.nextResult((long)SmackConfiguration.getPacketReplyTimeout());
        collector.cancel();
        if (response == null) {
            throw new XMPPException("No response from server on status set.");
        }
        if (response.getError() != null) {
            throw new XMPPException(response.getError());
        }
    }

    public void load(XMPPConnection connection) throws XMPPException {
        this.checkAuthenticated(connection);
        this.setFrom(connection.getUser());
        this.doLoad(connection, connection.getUser());
    }

    public void load(XMPPConnection connection, String user) throws XMPPException {
        this.checkAuthenticated(connection);
        this.setTo(user);
        this.doLoad(connection, user);
    }

    private void doLoad(XMPPConnection connection, String user) throws XMPPException {
        this.setType(IQ.Type.GET);
        PacketCollector collector = connection.createPacketCollector((PacketFilter)new PacketIDFilter(this.getPacketID()));
        connection.sendPacket((Packet)this);
        VCard result = null;
        try {
            result = (VCard)collector.nextResult((long)SmackConfiguration.getPacketReplyTimeout());
            if (result == null) {
                throw new XMPPException(new XMPPError(408, "Timeout getting VCard information"));
            }
            if (result.getError() != null) {
                throw new XMPPException(result.getError());
            }
        }
        catch (ClassCastException e) {
            System.out.println("No VCard for " + user);
        }
        this.copyFieldsFrom(result);
    }

    public String getChildElementXML() {
        StringBuffer sb = new StringBuffer();
        new VCardWriter(sb).write();
        return sb.toString();
    }

    private void copyFieldsFrom(VCard result) {
        if (result == null) {
            result = new VCard();
        }
        Field[] fields = (class$org$jivesoftware$smackx$packet$VCard == null ? (class$org$jivesoftware$smackx$packet$VCard = VCard.class$("org.jivesoftware.smackx.packet.VCard")) : class$org$jivesoftware$smackx$packet$VCard).getDeclaredFields();
        for (int i = 0; i < fields.length; ++i) {
            Field field = fields[i];
            if (field.getDeclaringClass() != (class$org$jivesoftware$smackx$packet$VCard == null ? VCard.class$("org.jivesoftware.smackx.packet.VCard") : class$org$jivesoftware$smackx$packet$VCard) || Modifier.isFinal(field.getModifiers())) continue;
            try {
                field.setAccessible(true);
                field.set((Object)this, field.get((Object)result));
                continue;
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException("This cannot happen:" + field, e);
            }
        }
    }

    private void checkAuthenticated(XMPPConnection connection) {
        if (connection == null) {
            throw new IllegalArgumentException("No connection was provided");
        }
        if (!connection.isAuthenticated()) {
            throw new IllegalArgumentException("Connection is not authenticated");
        }
        if (connection.isAnonymous()) {
            throw new IllegalArgumentException("Connection cannot be anonymous");
        }
    }

    private boolean hasContent() {
        return this.hasNameField() || this.hasOrganizationFields() || this.emailHome != null || this.emailWork != null || this.otherSimpleFields.size() > 0 || this.otherUnescapableFields.size() > 0 || this.homeAddr.size() > 0 || this.homePhones.size() > 0 || this.workAddr.size() > 0 || this.workPhones.size() > 0;
    }

    private boolean hasNameField() {
        return this.firstName != null || this.lastName != null || this.middleName != null;
    }

    private boolean hasOrganizationFields() {
        return this.organization != null || this.organizationUnit != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        VCard vCard = (VCard)((Object)o);
        if (this.emailHome != null ? !this.emailHome.equals(vCard.emailHome) : vCard.emailHome != null) {
            return false;
        }
        if (this.emailWork != null ? !this.emailWork.equals(vCard.emailWork) : vCard.emailWork != null) {
            return false;
        }
        if (this.firstName != null ? !this.firstName.equals(vCard.firstName) : vCard.firstName != null) {
            return false;
        }
        if (!((Object)this.homeAddr).equals(vCard.homeAddr)) {
            return false;
        }
        if (!((Object)this.homePhones).equals(vCard.homePhones)) {
            return false;
        }
        if (this.lastName != null ? !this.lastName.equals(vCard.lastName) : vCard.lastName != null) {
            return false;
        }
        if (this.middleName != null ? !this.middleName.equals(vCard.middleName) : vCard.middleName != null) {
            return false;
        }
        if (this.organization != null ? !this.organization.equals(vCard.organization) : vCard.organization != null) {
            return false;
        }
        if (this.organizationUnit != null ? !this.organizationUnit.equals(vCard.organizationUnit) : vCard.organizationUnit != null) {
            return false;
        }
        if (!((Object)this.otherSimpleFields).equals(vCard.otherSimpleFields)) {
            return false;
        }
        if (!((Object)this.workAddr).equals(vCard.workAddr)) {
            return false;
        }
        return ((Object)this.workPhones).equals(vCard.workPhones);
    }

    public int hashCode() {
        int result = ((Object)this.homePhones).hashCode();
        result = 29 * result + ((Object)this.workPhones).hashCode();
        result = 29 * result + ((Object)this.homeAddr).hashCode();
        result = 29 * result + ((Object)this.workAddr).hashCode();
        result = 29 * result + (this.firstName != null ? this.firstName.hashCode() : 0);
        result = 29 * result + (this.lastName != null ? this.lastName.hashCode() : 0);
        result = 29 * result + (this.middleName != null ? this.middleName.hashCode() : 0);
        result = 29 * result + (this.emailHome != null ? this.emailHome.hashCode() : 0);
        result = 29 * result + (this.emailWork != null ? this.emailWork.hashCode() : 0);
        result = 29 * result + (this.organization != null ? this.organization.hashCode() : 0);
        result = 29 * result + (this.organizationUnit != null ? this.organizationUnit.hashCode() : 0);
        result = 29 * result + ((Object)this.otherSimpleFields).hashCode();
        return result;
    }

    public String toString() {
        return this.getChildElementXML();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static /* synthetic */ String access$1500(VCard x0) {
        return x0.organization;
    }

    static /* synthetic */ String access$1600(VCard x0) {
        return x0.organizationUnit;
    }

    static /* synthetic */ String access$1700(VCard x0) {
        return x0.firstName;
    }

    static /* synthetic */ String access$1900(VCard x0) {
        return x0.middleName;
    }

    static /* synthetic */ String access$2000(VCard x0) {
        return x0.lastName;
    }

    private static interface ContentBuilder {
        public void addTagContent();
    }

    private class VCardWriter {
        private final StringBuffer sb;

        VCardWriter(StringBuffer sb) {
            this.sb = sb;
        }

        public void write() {
            this.appendTag("vCard", "xmlns", "vcard-temp", VCard.this.hasContent(), new ContentBuilder(this){
                private final /* synthetic */ VCardWriter this$1;
                {
                    this.this$1 = this$1;
                }

                public void addTagContent() {
                    VCardWriter.access$100(this.this$1);
                }
            });
        }

        private void buildActualContent() {
            if (VCard.this.hasNameField()) {
                this.appendFN();
                this.appendN();
            }
            this.appendOrganization();
            this.appendGenericFields();
            this.appendEmail(VCard.this.emailWork, "WORK");
            this.appendEmail(VCard.this.emailHome, "HOME");
            this.appendPhones(VCard.this.workPhones, "WORK");
            this.appendPhones(VCard.this.homePhones, "HOME");
            this.appendAddress(VCard.this.workAddr, "WORK");
            this.appendAddress(VCard.this.homeAddr, "HOME");
        }

        private void appendEmail(String email, String type) {
            if (email != null) {
                this.appendTag("EMAIL", true, new ContentBuilder(this, type, email){
                    private final /* synthetic */ String val$type;
                    private final /* synthetic */ String val$email;
                    private final /* synthetic */ VCardWriter this$1;
                    {
                        this.this$1 = this$1;
                        this.val$type = val$type;
                        this.val$email = val$email;
                    }

                    public void addTagContent() {
                        VCardWriter.access$900(this.this$1, this.val$type);
                        VCardWriter.access$900(this.this$1, "INTERNET");
                        VCardWriter.access$900(this.this$1, "PREF");
                        VCardWriter.access$1000(this.this$1, "USERID", StringUtils.escapeForXML((String)this.val$email));
                    }
                });
            }
        }

        private void appendPhones(Map phones, String code) {
            Iterator it = phones.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                this.appendTag("TEL", true, new ContentBuilder(this, entry, code){
                    private final /* synthetic */ Map.Entry val$entry;
                    private final /* synthetic */ String val$code;
                    private final /* synthetic */ VCardWriter this$1;
                    {
                        this.this$1 = this$1;
                        this.val$entry = val$entry;
                        this.val$code = val$code;
                    }

                    public void addTagContent() {
                        VCardWriter.access$900(this.this$1, this.val$entry.getKey());
                        VCardWriter.access$900(this.this$1, this.val$code);
                        VCardWriter.access$1000(this.this$1, "NUMBER", StringUtils.escapeForXML((String)((String)this.val$entry.getValue())));
                    }
                });
            }
        }

        private void appendAddress(Map addr, String code) {
            if (addr.size() > 0) {
                this.appendTag("ADR", true, new ContentBuilder(this, code, addr){
                    private final /* synthetic */ String val$code;
                    private final /* synthetic */ Map val$addr;
                    private final /* synthetic */ VCardWriter this$1;
                    {
                        this.this$1 = this$1;
                        this.val$code = val$code;
                        this.val$addr = val$addr;
                    }

                    public void addTagContent() {
                        VCardWriter.access$900(this.this$1, this.val$code);
                        Iterator<Map.Entry<K, V>> it = this.val$addr.entrySet().iterator();
                        while (it.hasNext()) {
                            Map.Entry<K, V> entry = it.next();
                            VCardWriter.access$1000(this.this$1, (String)entry.getKey(), StringUtils.escapeForXML((String)((String)entry.getValue())));
                        }
                    }
                });
            }
        }

        private void appendEmptyTag(Object tag) {
            this.sb.append('<').append(tag).append("/>");
        }

        private void appendGenericFields() {
            Map.Entry entry;
            Iterator it = VCard.this.otherSimpleFields.entrySet().iterator();
            while (it.hasNext()) {
                entry = it.next();
                this.appendTag(entry.getKey().toString(), StringUtils.escapeForXML((String)((String)entry.getValue())));
            }
            it = VCard.this.otherUnescapableFields.entrySet().iterator();
            while (it.hasNext()) {
                entry = it.next();
                this.appendTag(entry.getKey().toString(), (String)entry.getValue());
            }
        }

        private void appendOrganization() {
            if (VCard.this.hasOrganizationFields()) {
                this.appendTag("ORG", true, new ContentBuilder(this){
                    private final /* synthetic */ VCardWriter this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public void addTagContent() {
                        VCardWriter.access$1000(this.this$1, "ORGNAME", StringUtils.escapeForXML((String)VCard.access$1500(VCardWriter.access$1400(this.this$1))));
                        VCardWriter.access$1000(this.this$1, "ORGUNIT", StringUtils.escapeForXML((String)VCard.access$1600(VCardWriter.access$1400(this.this$1))));
                    }
                });
            }
        }

        private void appendFN() {
            ContentBuilder contentBuilder = new ContentBuilder(this){
                private final /* synthetic */ VCardWriter this$1;
                {
                    this.this$1 = this$1;
                }

                public void addTagContent() {
                    if (VCard.access$1700(VCardWriter.access$1400(this.this$1)) != null) {
                        VCardWriter.access$1800(this.this$1).append(StringUtils.escapeForXML((String)VCard.access$1700(VCardWriter.access$1400(this.this$1)))).append(' ');
                    }
                    if (VCard.access$1900(VCardWriter.access$1400(this.this$1)) != null) {
                        VCardWriter.access$1800(this.this$1).append(StringUtils.escapeForXML((String)VCard.access$1900(VCardWriter.access$1400(this.this$1)))).append(' ');
                    }
                    if (VCard.access$2000(VCardWriter.access$1400(this.this$1)) != null) {
                        VCardWriter.access$1800(this.this$1).append(StringUtils.escapeForXML((String)VCard.access$2000(VCardWriter.access$1400(this.this$1))));
                    }
                }
            };
            this.appendTag("FN", true, contentBuilder);
        }

        private void appendN() {
            this.appendTag("N", true, new ContentBuilder(this){
                private final /* synthetic */ VCardWriter this$1;
                {
                    this.this$1 = this$1;
                }

                public void addTagContent() {
                    VCardWriter.access$1000(this.this$1, "FAMILY", StringUtils.escapeForXML((String)VCard.access$2000(VCardWriter.access$1400(this.this$1))));
                    VCardWriter.access$1000(this.this$1, "GIVEN", StringUtils.escapeForXML((String)VCard.access$1700(VCardWriter.access$1400(this.this$1))));
                    VCardWriter.access$1000(this.this$1, "MIDDLE", StringUtils.escapeForXML((String)VCard.access$1900(VCardWriter.access$1400(this.this$1))));
                }
            });
        }

        private void appendTag(String tag, String attr, String attrValue, boolean hasContent, ContentBuilder builder) {
            this.sb.append('<').append(tag);
            if (attr != null) {
                this.sb.append(' ').append(attr).append('=').append('\'').append(attrValue).append('\'');
            }
            if (hasContent) {
                this.sb.append('>');
                builder.addTagContent();
                this.sb.append("</").append(tag).append(">\n");
            } else {
                this.sb.append("/>\n");
            }
        }

        private void appendTag(String tag, boolean hasContent, ContentBuilder builder) {
            this.appendTag(tag, null, null, hasContent, builder);
        }

        private void appendTag(String tag, String tagText) {
            if (tagText == null) {
                return;
            }
            ContentBuilder contentBuilder = new ContentBuilder(this, tagText){
                private final /* synthetic */ String val$tagText;
                private final /* synthetic */ VCardWriter this$1;
                {
                    this.this$1 = this$1;
                    this.val$tagText = val$tagText;
                }

                public void addTagContent() {
                    VCardWriter.access$1800(this.this$1).append(this.val$tagText.trim());
                }
            };
            this.appendTag(tag, true, contentBuilder);
        }

        static /* synthetic */ void access$100(VCardWriter x0) {
            x0.buildActualContent();
        }

        static /* synthetic */ void access$900(VCardWriter x0, Object x1) {
            x0.appendEmptyTag(x1);
        }

        static /* synthetic */ void access$1000(VCardWriter x0, String x1, String x2) {
            x0.appendTag(x1, x2);
        }

        static /* synthetic */ VCard access$1400(VCardWriter x0) {
            return x0.VCard.this;
        }

        static /* synthetic */ StringBuffer access$1800(VCardWriter x0) {
            return x0.sb;
        }
    }
}

