/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.ping;

import java.net.DatagramPacket;
import java.net.InetAddress;
import org.opennms.protocols.icmp.ICMPEchoPacket;

public final class Reply {
    private final InetAddress m_address;
    private final ICMPEchoPacket m_packet;

    public Reply(InetAddress addr, ICMPEchoPacket pkt) {
        this.m_packet = pkt;
        this.m_address = addr;
    }

    public boolean isEchoReply() {
        return this.m_packet.isEchoReply();
    }

    public final short getIdentity() {
        return this.m_packet.getIdentity();
    }

    public final InetAddress getAddress() {
        return this.m_address;
    }

    public final ICMPEchoPacket getPacket() {
        return this.m_packet;
    }

    public static Reply create(DatagramPacket packet) {
        if (packet.getData().length != ICMPEchoPacket.getNetworkSize()) {
            throw new IllegalArgumentException("The packet is not the correct network size");
        }
        ICMPEchoPacket pkt = new ICMPEchoPacket(packet.getData());
        if (pkt.getReceivedTime() == 0L) {
            pkt.setReceivedTime();
        }
        return new Reply(packet.getAddress(), pkt);
    }
}

