/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.svclayer.inventory;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.opennms.core.resource.Vault;
import org.opennms.netmgt.config.RWSConfig;
import org.opennms.netmgt.dao.api.NodeDao;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.rancid.ConnectionProperties;
import org.opennms.rancid.InventoryElement2;
import org.opennms.rancid.InventoryNode;
import org.opennms.rancid.RWSBucket;
import org.opennms.rancid.RWSClientApi;
import org.opennms.rancid.RWSResourceList;
import org.opennms.rancid.RancidApiException;
import org.opennms.rancid.RancidNode;
import org.opennms.rancid.RancidNodeAuthentication;
import org.opennms.web.element.ElementUtil;
import org.opennms.web.inventory.InventoryWrapper;
import org.opennms.web.inventory.RancidNodeWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;

public class InventoryService
implements InitializingBean {
    private static final Logger LOG = LoggerFactory.getLogger(InventoryService.class);
    RWSConfig m_rwsConfig;
    NodeDao m_nodeDao;
    ConnectionProperties m_cp;

    public void afterPropertiesSet() throws Exception {
        RWSClientApi.init();
        this.m_cp = this.m_rwsConfig.getBase();
    }

    public RWSConfig getRwsConfig() {
        return this.m_rwsConfig;
    }

    public void setRwsConfig(RWSConfig rwsConfig) {
        this.m_rwsConfig = rwsConfig;
    }

    public NodeDao getNodeDao() {
        return this.m_nodeDao;
    }

    public void setNodeDao(NodeDao nodeDao) {
        this.m_nodeDao = nodeDao;
    }

    public boolean checkRWSAlive() {
        try {
            RWSResourceList rl = RWSClientApi.getRWSResourceServicesList((ConnectionProperties)this.m_cp);
            return rl != null;
        }
        catch (Throwable e) {
            return false;
        }
    }

    public boolean checkRancidNode(String deviceName) {
        LOG.debug("checkRancidNode start {}", (Object)deviceName);
        try {
            RWSResourceList groups = RWSClientApi.getRWSResourceGroupsList((ConnectionProperties)this.m_cp);
            List grouplist = groups.getResource();
            Iterator iter1 = grouplist.iterator();
            if (iter1.hasNext()) {
                String groupname = (String)iter1.next();
                LOG.debug("checkRancidNode {} group {}", (Object)deviceName, (Object)groupname);
                try {
                    RancidNode rn = RWSClientApi.getRWSRancidNodeTLO((ConnectionProperties)this.m_cp, (String)groupname, (String)deviceName);
                    return rn != null;
                }
                catch (RancidApiException e) {
                    LOG.debug("No inventory information associated to {}", (Object)deviceName);
                    return false;
                }
            }
        }
        catch (Throwable e) {
            return false;
        }
        return true;
    }

    public Map<String, Object> getRancidNodeBase(int nodeid) {
        LOG.debug("getRancidNodeBase start for nodeid: {}", (Object)nodeid);
        TreeMap<String, Object> nodeModel = new TreeMap<String, Object>();
        nodeModel.put("RWSStatus", "OK");
        OnmsNode node = (OnmsNode)this.m_nodeDao.get((Serializable)Integer.valueOf(nodeid));
        String rancidName = node.getLabel();
        LOG.debug("getRancidNodeBase rancid node name: {}", (Object)rancidName);
        nodeModel.put("id", rancidName);
        nodeModel.put("db_id", nodeid);
        nodeModel.put("status_general", ElementUtil.getNodeStatusString(node.getType()));
        nodeModel.put("url", this.m_cp.getUrl() + this.m_cp.getDirectory());
        String rancidIntegrationUseOnlyRancidAdapterProperty = Vault.getProperty((String)"opennms.rancidIntegrationUseOnlyRancidAdapter");
        LOG.debug("getRancidNodeBase opennms.rancidIntegrationUseOnlyRancidAdapter: {}", (Object)rancidIntegrationUseOnlyRancidAdapterProperty);
        if (rancidIntegrationUseOnlyRancidAdapterProperty != null && "true".equalsIgnoreCase(rancidIntegrationUseOnlyRancidAdapterProperty.trim())) {
            LOG.debug("getRancidNodeBase permitModifyClogin: false");
            nodeModel.put("permitModifyClogin", false);
        } else {
            LOG.debug("getRancidNodeBase permitModifyClogin: true");
            nodeModel.put("permitModifyClogin", true);
        }
        String foreignSource = node.getForeignSource();
        if (foreignSource != null) {
            nodeModel.put("foreignSource", foreignSource);
        } else {
            nodeModel.put("foreignSource", "");
        }
        return nodeModel;
    }

    public Map<String, Object> getRancidNode(int nodeid) {
        RWSResourceList groups;
        LOG.debug("getRancidNode start");
        Map<String, Object> nodeModel = this.getRancidNodeBase(nodeid);
        String rancidName = (String)nodeModel.get("id");
        ArrayList<RancidNodeWrapper> ranlist = new ArrayList<RancidNodeWrapper>();
        ArrayList bucketlist = new ArrayList();
        try {
            groups = RWSClientApi.getRWSResourceGroupsList((ConnectionProperties)this.m_cp);
        }
        catch (RancidApiException e) {
            LOG.error(e.getLocalizedMessage());
            nodeModel.put("RWSStatus", e.getLocalizedMessage());
            return nodeModel;
        }
        List grouplist = groups.getResource();
        Iterator iter1 = grouplist.iterator();
        boolean first = true;
        while (iter1.hasNext()) {
            String groupname = (String)iter1.next();
            LOG.debug("getRancidNode: {} for group {}", (Object)nodeid, (Object)groupname);
            try {
                RancidNode rn;
                if (first) {
                    rn = RWSClientApi.getRWSRancidNodeTLO((ConnectionProperties)this.m_cp, (String)groupname, (String)rancidName);
                    nodeModel.put("devicename", rn.getDeviceName());
                    nodeModel.put("status", rn.getState());
                    nodeModel.put("devicetype", rn.getDeviceType());
                    nodeModel.put("comment", rn.getComment());
                    nodeModel.put("groupname", groupname);
                    first = false;
                }
                try {
                    rn = RWSClientApi.getRWSRancidNodeInventory((ConnectionProperties)this.m_cp, (String)groupname, (String)rancidName);
                    String vs = rn.getHeadRevision();
                    InventoryNode in = (InventoryNode)rn.getNodeVersions().get(vs);
                    RancidNodeWrapper rnw = new RancidNodeWrapper(rn.getDeviceName(), groupname, rn.getDeviceType(), rn.getComment(), rn.getHeadRevision(), rn.getTotalRevisions(), in.getCreationDate(), rn.getRootConfigurationUrl());
                    ranlist.add(rnw);
                }
                catch (RancidApiException e) {
                    LOG.debug("No configuration found for nodeid:{} on Group: {} .Cause: {}", new Object[]{nodeid, groupname, e.getLocalizedMessage()});
                }
            }
            catch (RancidApiException e) {
                if (e.getRancidCode() == 2) {
                    LOG.debug("No device found in router.db for nodeid:{} on Group: {} .Cause: {}", new Object[]{nodeid, groupname, e.getLocalizedMessage()});
                    continue;
                }
                nodeModel.put("RWSStatus", e.getLocalizedMessage());
                LOG.error(e.getLocalizedMessage());
            }
        }
        nodeModel.put("grouptable", ranlist);
        try {
            RWSBucket bucket = RWSClientApi.getBucket((ConnectionProperties)this.m_cp, (String)rancidName);
            bucketlist.addAll(bucket.getBucketItem());
        }
        catch (RancidApiException e) {
            if (e.getRancidCode() == 2) {
                LOG.debug("No entry in storage for nodeid:{} nodeLabel: {}", (Object)nodeid, (Object)rancidName);
            }
            nodeModel.put("RWSStatus", e.getLocalizedMessage());
            LOG.error(e.getLocalizedMessage());
        }
        nodeModel.put("bucketitems", bucketlist);
        return nodeModel;
    }

    public Map<String, Object> getBuckets(int nodeid) {
        LOG.debug("getBuckets start: nodeid: {}", (Object)nodeid);
        Map<String, Object> nodeModel = this.getRancidNodeBase(nodeid);
        String rancidName = (String)nodeModel.get("id");
        ArrayList bucketlist = new ArrayList();
        try {
            RWSBucket bucket = RWSClientApi.getBucket((ConnectionProperties)this.m_cp, (String)rancidName);
            nodeModel.put("bucketexist", true);
            bucketlist.addAll(bucket.getBucketItem());
        }
        catch (RancidApiException e) {
            if (e.getRancidCode() == 2) {
                nodeModel.put("bucketexist", false);
                LOG.debug("No entry in storage for nodeid:{} nodeLabel: {}", (Object)nodeid, (Object)rancidName);
            }
            nodeModel.put("RWSStatus", e.getLocalizedMessage());
            LOG.error(e.getLocalizedMessage());
        }
        nodeModel.put("bucketlistsize", bucketlist.size());
        nodeModel.put("bucketitems", bucketlist);
        return nodeModel;
    }

    public Map<String, Object> getRancidNodeList(int nodeid) {
        RWSResourceList groups;
        LOG.debug("getRancidNodelist start: nodeid: {}", (Object)nodeid);
        Map<String, Object> nodeModel = this.getRancidNodeBase(nodeid);
        String rancidName = (String)nodeModel.get("id");
        try {
            groups = RWSClientApi.getRWSResourceGroupsList((ConnectionProperties)this.m_cp);
        }
        catch (RancidApiException e) {
            nodeModel.put("RWSStatus", e.getLocalizedMessage());
            LOG.error(e.getLocalizedMessage());
            return nodeModel;
        }
        ArrayList<InventoryWrapper> ranlist = new ArrayList<InventoryWrapper>();
        List grouplist = groups.getResource();
        Iterator iter2 = grouplist.iterator();
        boolean first = true;
        while (iter2.hasNext()) {
            String groupname = (String)iter2.next();
            try {
                RancidNode rn = RWSClientApi.getRWSRancidNodeInventory((ConnectionProperties)this.m_cp, (String)groupname, (String)rancidName);
                if (first) {
                    nodeModel.put("devicename", rn.getDeviceName());
                    first = false;
                }
                RWSResourceList versionList = RWSClientApi.getRWSResourceConfigList((ConnectionProperties)this.m_cp, (String)groupname, (String)rancidName);
                List versionListStr = versionList.getResource();
                for (String vs : versionListStr) {
                    InventoryNode in = (InventoryNode)rn.getNodeVersions().get(vs);
                    InventoryWrapper inwr = new InventoryWrapper(in.getVersionId(), in.getCreationDate(), groupname, in.getConfigurationUrl());
                    ranlist.add(inwr);
                }
            }
            catch (RancidApiException e) {
                if (e.getRancidCode() == 2) {
                    LOG.debug("No Inventory found in CVS repository for nodeid:{} nodeLabel: {}", (Object)nodeid, (Object)rancidName);
                    continue;
                }
                nodeModel.put("RWSStatus", e.getLocalizedMessage());
                LOG.error(e.getLocalizedMessage());
            }
        }
        nodeModel.put("grouptable", ranlist);
        return nodeModel;
    }

    public Map<String, Object> getRancidNodeList(int nodeid, String group) {
        RWSResourceList versionList;
        RancidNode rn;
        LOG.debug("getRancidlist start: nodeid: {} group: {}", (Object)nodeid, (Object)group);
        Map<String, Object> nodeModel = this.getRancidNodeBase(nodeid);
        String rancidName = (String)nodeModel.get("id");
        ArrayList<InventoryWrapper> ranlist = new ArrayList<InventoryWrapper>();
        try {
            rn = RWSClientApi.getRWSRancidNodeInventory((ConnectionProperties)this.m_cp, (String)group, (String)rancidName);
            nodeModel.put("devicename", rn.getDeviceName());
        }
        catch (RancidApiException e) {
            if (e.getRancidCode() == 2) {
                LOG.debug("No Inventory found in CVS repository for nodeid:{} nodeLabel: {}", (Object)nodeid, (Object)rancidName);
            } else {
                nodeModel.put("RWSStatus", e.getLocalizedMessage());
                LOG.error(e.getLocalizedMessage());
            }
            return nodeModel;
        }
        try {
            versionList = RWSClientApi.getRWSResourceConfigList((ConnectionProperties)this.m_cp, (String)group, (String)rancidName);
        }
        catch (RancidApiException e) {
            nodeModel.put("RWSStatus", e.getLocalizedMessage());
            LOG.error(e.getLocalizedMessage());
            return nodeModel;
        }
        List versionListStr = versionList.getResource();
        for (String vs : versionListStr) {
            InventoryNode in = (InventoryNode)rn.getNodeVersions().get(vs);
            InventoryWrapper inwr = new InventoryWrapper(in.getVersionId(), in.getCreationDate(), group, in.getConfigurationUrl());
            ranlist.add(inwr);
        }
        nodeModel.put("grouptable", ranlist);
        return nodeModel;
    }

    public Map<String, Object> getInventory(int nodeid, String group, String version) {
        LOG.debug("getInventoryNode start: nodeid: {} group: {} version: {}", new Object[]{nodeid, group, version});
        Map<String, Object> nodeModel = this.getRancidNodeBase(nodeid);
        String rancidName = (String)nodeModel.get("id");
        try {
            RancidNode rn = RWSClientApi.getRWSRancidNodeInventory((ConnectionProperties)this.m_cp, (String)group, (String)rancidName);
            InventoryNode in = (InventoryNode)rn.getNodeVersions().get(version);
            nodeModel.put("devicename", rancidName);
            nodeModel.put("groupname", group);
            nodeModel.put("version", version);
            nodeModel.put("status", in.getParent().getState());
            nodeModel.put("creationdate", in.getCreationDate());
            nodeModel.put("swconfigurationurl", in.getSoftwareImageUrl());
            nodeModel.put("configurationurl", in.getConfigurationUrl());
            LOG.debug("getInventoryNode date: {}", (Object)in.getCreationDate());
            List ie = RWSClientApi.getRWSRancidNodeInventoryElement2((ConnectionProperties)this.m_cp, (RancidNode)rn, (String)version);
            for (InventoryElement2 ietmp : ie) {
                LOG.debug("Adding inventory: {}", (Object)ietmp.expand());
            }
            nodeModel.put("inventory", ie);
        }
        catch (RancidApiException e) {
            if (e.getRancidCode() == 2) {
                LOG.debug("No Inventory found in CVS repository for nodeid:{} nodeLabel: {}", (Object)nodeid, (Object)rancidName);
            }
            nodeModel.put("RWSStatus", e.getLocalizedMessage());
            LOG.error(e.getLocalizedMessage());
        }
        return nodeModel;
    }

    public Map<String, Object> getRancidNodeWithCLoginForGroup(int nodeid, String group, boolean adminRole) {
        RWSResourceList devicetypes;
        RWSResourceList groups;
        LOG.debug("getRancidNodeWithCloginFroGroup start: group: {}", (Object)group);
        Map<String, Object> nodeModel = this.getRancidNodeBase(nodeid);
        String rancidName = (String)nodeModel.get("id");
        try {
            groups = RWSClientApi.getRWSResourceGroupsList((ConnectionProperties)this.m_cp);
        }
        catch (RancidApiException e) {
            nodeModel.put("RWSStatus", e.getLocalizedMessage());
            LOG.error(e.getLocalizedMessage());
            return nodeModel;
        }
        List grouplist = groups.getResource();
        nodeModel.put("grouplist", grouplist);
        try {
            devicetypes = RWSClientApi.getRWSResourceDeviceTypesPatternList((ConnectionProperties)this.m_cp);
        }
        catch (RancidApiException e) {
            nodeModel.put("RWSStatus", e.getLocalizedMessage());
            LOG.error(e.getLocalizedMessage());
            return nodeModel;
        }
        List devicetypelist = devicetypes.getResource();
        nodeModel.put("devicetypelist", devicetypelist);
        nodeModel.put("groupname", group);
        try {
            RancidNode rn = RWSClientApi.getRWSRancidNodeTLO((ConnectionProperties)this.m_cp, (String)group, (String)rancidName);
            nodeModel.put("devicename", rn.getDeviceName());
            nodeModel.put("status", rn.getState());
            nodeModel.put("devicetype", rn.getDeviceType());
            nodeModel.put("comment", rn.getComment());
            nodeModel.put("deviceexist", true);
        }
        catch (RancidApiException e) {
            if (e.getRancidCode() == 2) {
                nodeModel.put("deviceexist", false);
                LOG.debug("No device found in router.db for:{}on Group: {}", (Object)rancidName, (Object)group);
            }
            nodeModel.put("RWSStatus", e.getLocalizedMessage());
            LOG.error(e.getLocalizedMessage());
            return nodeModel;
        }
        if (adminRole) {
            LOG.debug("getRancidNode: getting clogin info for: {}", (Object)rancidName);
            try {
                RancidNodeAuthentication rn5 = RWSClientApi.getRWSAuthNode((ConnectionProperties)this.m_cp, (String)rancidName);
                nodeModel.put("isadmin", "true");
                nodeModel.put("cloginuser", rn5.getUser());
                nodeModel.put("cloginpassword", rn5.getPassword());
                nodeModel.put("cloginconnmethod", rn5.getConnectionMethodString());
                nodeModel.put("cloginenablepass", rn5.getEnablePass());
                String autoen = "0";
                if (rn5.isAutoEnable()) {
                    autoen = "1";
                }
                nodeModel.put("cloginautoenable", autoen);
            }
            catch (RancidApiException e) {
                nodeModel.put("RWSStatus", e.getLocalizedMessage());
                LOG.error("getRancidNode: clogin get failed with reason: {}", (Object)e.getLocalizedMessage());
            }
        }
        return nodeModel;
    }

    public Map<String, Object> getRancidNodeWithCLogin(int nodeid, boolean adminRole) {
        RWSResourceList devicetypes;
        RWSResourceList groups;
        LOG.debug("getRancidNodeWithClogin start");
        Map<String, Object> nodeModel = this.getRancidNodeBase(nodeid);
        String rancidName = (String)nodeModel.get("id");
        try {
            groups = RWSClientApi.getRWSResourceGroupsList((ConnectionProperties)this.m_cp);
        }
        catch (RancidApiException e) {
            nodeModel.put("RWSStatus", e.getLocalizedMessage());
            LOG.error(e.getLocalizedMessage());
            return nodeModel;
        }
        List grouplist = groups.getResource();
        nodeModel.put("grouplist", grouplist);
        for (String groupname : grouplist) {
            nodeModel.put("groupname", groupname);
            LOG.debug("getRancidNodeWithClogin {} group {}", (Object)rancidName, (Object)groupname);
            try {
                RancidNode rn = RWSClientApi.getRWSRancidNodeTLO((ConnectionProperties)this.m_cp, (String)groupname, (String)rancidName);
                nodeModel.put("devicename", rn.getDeviceName());
                nodeModel.put("status", rn.getState());
                nodeModel.put("devicetype", rn.getDeviceType());
                nodeModel.put("comment", rn.getComment());
                nodeModel.put("deviceexist", true);
                break;
            }
            catch (RancidApiException e) {
                if (e.getRancidCode() == 2) {
                    nodeModel.put("deviceexist", false);
                    LOG.debug("No device found in router.db for:{}on Group: {}", (Object)rancidName, (Object)groupname);
                    continue;
                }
                nodeModel.put("RWSStatus", e.getLocalizedMessage());
                LOG.error(e.getLocalizedMessage());
                return nodeModel;
            }
        }
        try {
            devicetypes = RWSClientApi.getRWSResourceDeviceTypesPatternList((ConnectionProperties)this.m_cp);
        }
        catch (RancidApiException e) {
            nodeModel.put("RWSStatus", e.getLocalizedMessage());
            LOG.error(e.getLocalizedMessage());
            return nodeModel;
        }
        List devicetypelist = devicetypes.getResource();
        nodeModel.put("devicetypelist", devicetypelist);
        if (adminRole) {
            LOG.debug("getRancidNode: getting clogin info for: {}", (Object)rancidName);
            try {
                RancidNodeAuthentication rn5 = RWSClientApi.getRWSAuthNode((ConnectionProperties)this.m_cp, (String)rancidName);
                nodeModel.put("isadmin", "true");
                nodeModel.put("cloginuser", rn5.getUser());
                nodeModel.put("cloginpassword", rn5.getPassword());
                nodeModel.put("cloginconnmethod", rn5.getConnectionMethodString());
                nodeModel.put("cloginenablepass", rn5.getEnablePass());
                String autoen = "0";
                if (rn5.isAutoEnable()) {
                    autoen = "1";
                }
                nodeModel.put("cloginautoenable", autoen);
            }
            catch (RancidApiException e) {
                nodeModel.put("RWSStatus", e.getLocalizedMessage());
                LOG.error("getRancidNode: clogin get failed with reason: {}", (Object)e.getLocalizedMessage());
            }
        }
        return nodeModel;
    }

    public boolean switchStatus(String groupName, String deviceName) {
        LOG.debug("InventoryService switchStatus {}/{}", (Object)groupName, (Object)deviceName);
        try {
            RancidNode rn = RWSClientApi.getRWSRancidNodeTLO((ConnectionProperties)this.m_cp, (String)groupName, (String)deviceName);
            if (rn.isStateUp()) {
                LOG.debug("InventoryService switchStatus :down");
                rn.setStateUp(false);
            } else {
                LOG.debug("InventoryService switchStatus :up");
                rn.setStateUp(true);
            }
            RWSClientApi.updateRWSRancidNode((ConnectionProperties)this.m_cp, (RancidNode)rn);
        }
        catch (Throwable e) {
            LOG.debug("switchStatus has given exception on node {}/{} {}", new Object[]{groupName, deviceName, e.getMessage()});
            return false;
        }
        return true;
    }

    public boolean deleteNodeOnRouterDb(String groupName, String deviceName) {
        LOG.debug("InventoryService deleteNodeOnRouterDb: {}/{}", (Object)groupName, (Object)deviceName);
        try {
            RancidNode rn = RWSClientApi.getRWSRancidNodeTLO((ConnectionProperties)this.m_cp, (String)groupName, (String)deviceName);
            RWSClientApi.deleteRWSRancidNode((ConnectionProperties)this.m_cp, (RancidNode)rn);
        }
        catch (Throwable e) {
            LOG.debug("deleteNodeOnRouterDb has given exception on node {}/{} {}", new Object[]{groupName, deviceName, e.getMessage()});
            return false;
        }
        return true;
    }

    public boolean updateNodeOnRouterDb(String groupName, String deviceName, String deviceType, String status, String comment) {
        LOG.debug("InventoryService updateNodeOnRouterDb: {}->{}:{}:{}:{}", new Object[]{groupName, deviceName, deviceType, status, comment});
        try {
            RancidNode rn = RWSClientApi.getRWSRancidNodeTLO((ConnectionProperties)this.m_cp, (String)groupName, (String)deviceName);
            rn.setDeviceType(deviceType);
            if (comment != null) {
                rn.setComment(comment);
            }
            if ("up".equalsIgnoreCase(status)) {
                rn.setStateUp(true);
            } else if ("down".equalsIgnoreCase(status)) {
                rn.setStateUp(false);
            }
            RWSClientApi.updateRWSRancidNode((ConnectionProperties)this.m_cp, (RancidNode)rn);
        }
        catch (Throwable e) {
            LOG.debug("updateNodeOnRouterDb has given exception on node {}/{} {}", new Object[]{groupName, deviceName, e.getMessage()});
            return false;
        }
        return true;
    }

    public boolean createNodeOnRouterDb(String groupName, String deviceName, String deviceType, String status, String comment) {
        LOG.debug("InventoryService createNodeOnRouterDb: {}->{}:{}:{}:{}", new Object[]{groupName, deviceName, deviceType, status, comment});
        try {
            RancidNode rn = new RancidNode(groupName, deviceName);
            rn.setDeviceType(deviceType);
            if (comment != null) {
                rn.setComment(comment);
            }
            if ("up".equalsIgnoreCase(status)) {
                rn.setStateUp(true);
            } else if ("down".equalsIgnoreCase(status)) {
                rn.setStateUp(false);
            }
            RWSClientApi.createRWSRancidNode((ConnectionProperties)this.m_cp, (RancidNode)rn);
        }
        catch (Throwable e) {
            LOG.debug("createNodeOnRouterDb has given exception on node {}/{} {}", new Object[]{groupName, deviceName, e.getMessage()});
            return false;
        }
        return true;
    }

    public boolean updateClogin(String deviceName, String groupName, String userID, String pass, String enPass, String loginM, String autoE) {
        LOG.debug("InventoryService updateClogin for following changes userID [{}] pass [{}] enpass [{}] loginM [{}] autoE [{}] groupName (ignored) [{}] deviceName [{}]", new Object[]{userID, pass, enPass, loginM, autoE, groupName, deviceName});
        try {
            RancidNodeAuthentication rna = RWSClientApi.getRWSAuthNode((ConnectionProperties)this.m_cp, (String)deviceName);
            rna.setUser(userID);
            rna.setPassword(pass);
            rna.setConnectionMethod(loginM);
            rna.setEnablePass(enPass);
            boolean autoeb = false;
            if (autoE.compareTo("1") == 0) {
                autoeb = true;
            }
            rna.setAutoEnable(autoeb);
            RWSClientApi.createOrUpdateRWSAuthNode((ConnectionProperties)this.m_cp, (RancidNodeAuthentication)rna);
            LOG.debug("InventoryService ModelAndView updateClogin changes submitted");
        }
        catch (Throwable e) {
            LOG.debug("updateClogin has given exception on node {} {}", (Object)deviceName, (Object)e.getMessage());
            return false;
        }
        return true;
    }

    public boolean deleteClogin(String deviceName) {
        LOG.debug("InventoryService deleteClogin deviceName [{}] ", (Object)deviceName);
        try {
            RancidNodeAuthentication rna = RWSClientApi.getRWSAuthNode((ConnectionProperties)this.m_cp, (String)deviceName);
            RWSClientApi.deleteRWSAuthNode((ConnectionProperties)this.m_cp, (RancidNodeAuthentication)rna);
            LOG.debug("InventoryService ModelAndView updateClogin changes submitted");
        }
        catch (Throwable e) {
            LOG.debug("updateClogin has given exception on node {} {}", (Object)deviceName, (Object)e.getMessage());
            return false;
        }
        return true;
    }

    public boolean deleteBucketItem(String bucket, String filename) {
        LOG.debug("InventoryService deleteBucketItem for bucket/filename [{}]/[{}]", (Object)bucket, (Object)filename);
        try {
            RWSClientApi.deleteBucketItem((ConnectionProperties)this.m_cp, (String)bucket, (String)filename);
            LOG.debug("InventoryService ModelAndView deleteBucketItem changes submitted");
        }
        catch (Throwable e) {
            LOG.debug("deleteBucketItem has given exception on node {} {}", (Object)bucket, (Object)e.getMessage());
            return false;
        }
        return true;
    }

    public boolean deleteBucket(String bucket) {
        LOG.debug("InventoryService deleteBucket for bucket [{}]/ ", (Object)bucket);
        try {
            RWSClientApi.deleteBucket((ConnectionProperties)this.m_cp, (String)bucket);
            LOG.debug("InventoryService ModelAndView deleteBucket changes submitted");
        }
        catch (Throwable e) {
            LOG.debug("deleteBucket has given exception on node {} {}", (Object)bucket, (Object)e.getMessage());
            return false;
        }
        return true;
    }

    public boolean createBucket(String bucket) {
        LOG.debug("InventoryService createBucket for bucket [{}]/ ", (Object)bucket);
        try {
            RWSClientApi.createBucket((ConnectionProperties)this.m_cp, (String)bucket);
            LOG.debug("InventoryService ModelAndView createBucket changes submitted");
        }
        catch (Throwable e) {
            LOG.debug("createBucket has given exception on node {} {}", (Object)bucket, (Object)e.getMessage());
            return false;
        }
        return true;
    }
}

