/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.controller.notification;

import java.util.ArrayList;
import java.util.Date;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.opennms.core.utils.WebSecurityUtils;
import org.opennms.web.controller.RedirectRestricter;
import org.opennms.web.filter.Filter;
import org.opennms.web.notification.Notification;
import org.opennms.web.notification.WebNotificationRepository;
import org.opennms.web.notification.filter.NotificationCriteria;
import org.opennms.web.notification.filter.NotificationIdListFilter;
import org.opennms.web.servlet.MissingParameterException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.mvc.AbstractController;
import org.springframework.web.servlet.view.RedirectView;

public class AcknowledgeNotificationController
extends AbstractController
implements InitializingBean {
    private WebNotificationRepository m_webNotificationRepository;
    private String m_redirectView;
    private RedirectRestricter redirectRestricter = RedirectRestricter.builder().allowRedirect("notification/detail.jsp").build();

    public void setRedirectView(String redirectView) {
        this.m_redirectView = redirectView;
    }

    public void setWebNotificationRepository(WebNotificationRepository webNotificationRepository) {
        this.m_webNotificationRepository = webNotificationRepository;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.m_redirectView, (String)"redirectView must be set");
        Assert.notNull((Object)this.m_webNotificationRepository, (String)"webNotificationRepository must be set");
    }

    protected ModelAndView handleRequestInternal(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String[] required = new String[]{"notices"};
        String[] noticeIdStrings = request.getParameterValues("notices");
        if (noticeIdStrings == null) {
            throw new MissingParameterException("notices", required);
        }
        String currentUser = request.getParameter("curUser");
        if (currentUser == null) {
            currentUser = request.getRemoteUser();
        }
        ArrayList<Integer> noticeIds = new ArrayList<Integer>();
        for (String noticeIdString : noticeIdStrings) {
            noticeIds.add(WebSecurityUtils.safeParseInt((String)noticeIdString));
        }
        ArrayList<NotificationIdListFilter> filters = new ArrayList<NotificationIdListFilter>();
        filters.add(new NotificationIdListFilter(noticeIds.toArray(new Integer[0])));
        NotificationCriteria criteria = new NotificationCriteria(filters.toArray(new Filter[0]));
        this.m_webNotificationRepository.acknowledgeMatchingNotification(currentUser, new Date(), criteria);
        Notification[] notices = this.m_webNotificationRepository.getMatchingNotifications(criteria);
        request.setAttribute("notices", (Object)notices);
        String redirectParms = request.getParameter("redirectParms");
        String redirect = this.redirectRestricter.getRedirectOrNull(request.getParameter("redirect"));
        String viewName = redirect != null ? redirect : (redirectParms == null || "".equals(redirectParms) || "null".equals(redirectParms) ? this.m_redirectView : this.m_redirectView + "?" + redirectParms);
        RedirectView view = new RedirectView(viewName, true);
        return new ModelAndView((View)view);
    }
}

