/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.controller.alarm;

import java.util.ArrayList;
import java.util.Date;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.opennms.netmgt.dao.api.AlarmRepository;
import org.opennms.netmgt.model.OnmsCriteria;
import org.opennms.web.alarm.AcknowledgeType;
import org.opennms.web.alarm.AlarmUtil;
import org.opennms.web.alarm.filter.AlarmCriteria;
import org.opennms.web.controller.RedirectRestricter;
import org.opennms.web.filter.Filter;
import org.opennms.web.servlet.MissingParameterException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.mvc.AbstractController;
import org.springframework.web.servlet.view.RedirectView;

public class AcknowledgeAlarmByFilterController
extends AbstractController
implements InitializingBean {
    private AlarmRepository m_webAlarmRepository;
    private String m_redirectView;
    private RedirectRestricter redirectRestricter = RedirectRestricter.builder().build();

    public void setRedirectView(String redirectView) {
        this.m_redirectView = redirectView;
    }

    public void setAlarmRepository(AlarmRepository webAlarmRepository) {
        this.m_webAlarmRepository = webAlarmRepository;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.m_redirectView, (String)"redirectView must be set");
        Assert.notNull((Object)this.m_webAlarmRepository, (String)"webAlarmRepository must be set");
    }

    public ModelAndView handleRequestInternal(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String[] filterStrings = request.getParameterValues("filter");
        String action = request.getParameter("actionCode");
        if (filterStrings == null) {
            filterStrings = new String[]{};
        }
        if (action == null) {
            throw new MissingParameterException("actionCode", new String[]{"filter", "actionCode"});
        }
        ArrayList<Filter> filterArray = new ArrayList<Filter>();
        for (String filterString : filterStrings) {
            Filter filter = AlarmUtil.getFilter(filterString, this.getServletContext());
            if (filter == null) continue;
            filterArray.add(filter);
        }
        Filter[] filters = filterArray.toArray(new Filter[filterArray.size()]);
        OnmsCriteria criteria = AlarmUtil.getOnmsCriteria(new AlarmCriteria(filters));
        if (action.equals(AcknowledgeType.ACKNOWLEDGED.getShortName())) {
            this.m_webAlarmRepository.acknowledgeMatchingAlarms(request.getRemoteUser(), new Date(), criteria);
        } else if (action.equals(AcknowledgeType.UNACKNOWLEDGED.getShortName())) {
            this.m_webAlarmRepository.unacknowledgeMatchingAlarms(criteria, request.getRemoteUser());
        } else {
            throw new ServletException("Unknown acknowledge action: " + action);
        }
        String redirectParms = request.getParameter("redirectParms");
        String redirect = this.redirectRestricter.getRedirectOrNull(request.getParameter("redirect"));
        String viewName = redirect != null ? redirect : (redirectParms == null || "".equals(redirectParms) || "null".equals(redirectParms) ? this.m_redirectView : this.m_redirectView + "?" + redirectParms);
        RedirectView view = new RedirectView(viewName, true);
        return new ModelAndView((View)view);
    }
}

