/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.admin.discovery;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.opennms.core.utils.LocationUtils;
import org.opennms.core.utils.WebSecurityUtils;
import org.opennms.core.xml.JaxbUtils;
import org.opennms.netmgt.config.DiscoveryConfigFactory;
import org.opennms.netmgt.config.discovery.DiscoveryConfiguration;
import org.opennms.netmgt.config.discovery.ExcludeRange;
import org.opennms.netmgt.config.discovery.IncludeRange;
import org.opennms.netmgt.config.discovery.IncludeUrl;
import org.opennms.netmgt.config.discovery.Specific;
import org.opennms.netmgt.events.api.EventProxy;
import org.opennms.netmgt.model.events.EventBuilder;
import org.opennms.web.admin.discovery.GeneralSettingsLoader;
import org.opennms.web.api.Util;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActionDiscoveryServlet
extends HttpServlet {
    private static final Logger LOG = LoggerFactory.getLogger(ActionDiscoveryServlet.class);
    private static final long serialVersionUID = 2L;
    public static final String ATTRIBUTE_DISCOVERY_CONFIGURATION = ActionDiscoveryServlet.class.getSimpleName() + "-discoveryConfiguration";

    public static DiscoveryConfiguration getDiscoveryConfig() throws ServletException {
        DiscoveryConfiguration config = null;
        try {
            DiscoveryConfigFactory factory = DiscoveryConfigFactory.getInstance();
            factory.reload();
            config = factory.getConfiguration();
        }
        catch (Exception e) {
            throw new ServletException("Could not load configuration: " + e.getMessage(), (Throwable)e);
        }
        return config;
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String specificIndex;
        String foreignSource;
        LOG.info("Loading Discovery configuration.");
        HttpSession sess = request.getSession(true);
        DiscoveryConfiguration config = (DiscoveryConfiguration)sess.getAttribute(ATTRIBUTE_DISCOVERY_CONFIGURATION);
        if (config == null) {
            config = ActionDiscoveryServlet.getDiscoveryConfig();
            sess.setAttribute(ATTRIBUTE_DISCOVERY_CONFIGURATION, (Object)config);
        }
        config = GeneralSettingsLoader.load(request, config);
        String action = request.getParameter("action");
        LOG.debug("action: {}", (Object)action);
        if (action.equals("AddSpecific")) {
            LOG.debug("Adding Specific");
            String ipAddr = request.getParameter("specificipaddress");
            String timeout = request.getParameter("specifictimeout");
            String retries = request.getParameter("specificretries");
            foreignSource = request.getParameter("specificforeignsource");
            String location = request.getParameter("specificlocation");
            Specific newSpecific = new Specific();
            newSpecific.setAddress(ipAddr);
            if (timeout != null && !"".equals(timeout.trim()) && !timeout.equals(String.valueOf(config.getTimeout().orElse(null)))) {
                newSpecific.setTimeout(Long.valueOf(WebSecurityUtils.safeParseLong((String)timeout)));
            }
            if (retries != null && !"".equals(retries.trim()) && !retries.equals(String.valueOf(config.getRetries().orElse(null)))) {
                newSpecific.setRetries(Integer.valueOf(WebSecurityUtils.safeParseInt((String)retries)));
            }
            if (foreignSource != null && !"".equals(foreignSource.trim()) && !foreignSource.equals(config.getForeignSource().orElse(null))) {
                newSpecific.setForeignSource(foreignSource);
            }
            if (!LocationUtils.doesLocationsMatch((String)location, (String)config.getLocation().orElse("Default"))) {
                newSpecific.setLocation(location);
            }
            config.addSpecific(newSpecific);
        }
        if (action.equals("RemoveSpecific")) {
            int index;
            LOG.debug("Removing Specific");
            specificIndex = request.getParameter("index");
            int index1 = index = WebSecurityUtils.safeParseInt((String)specificIndex);
            Specific spec = (Specific)config.getSpecifics().get(index1);
            boolean result = config.removeSpecific(spec);
            LOG.debug("Removing Specific result = {}", (Object)result);
        }
        if (action.equals("AddIncludeRange")) {
            LOG.debug("Adding Include Range");
            String ipAddrBase = request.getParameter("irbase");
            String ipAddrEnd = request.getParameter("irend");
            String timeout = request.getParameter("irtimeout");
            String retries = request.getParameter("irretries");
            String foreignSource2 = request.getParameter("irforeignsource");
            String location = request.getParameter("irlocation");
            IncludeRange newIR = new IncludeRange();
            newIR.setBegin(ipAddrBase);
            newIR.setEnd(ipAddrEnd);
            if (timeout != null && !"".equals(timeout.trim()) && !timeout.equals(String.valueOf(config.getTimeout().orElse(null)))) {
                newIR.setTimeout(Long.valueOf(WebSecurityUtils.safeParseLong((String)timeout)));
            }
            if (retries != null && !"".equals(retries.trim()) && !retries.equals(String.valueOf(config.getRetries().orElse(null)))) {
                newIR.setRetries(Integer.valueOf(WebSecurityUtils.safeParseInt((String)retries)));
            }
            if (foreignSource2 != null && !"".equals(foreignSource2.trim()) && !foreignSource2.equals(config.getForeignSource().orElse(null))) {
                newIR.setForeignSource(foreignSource2);
            }
            if (!LocationUtils.doesLocationsMatch((String)location, (String)config.getLocation().orElse("Default"))) {
                newIR.setLocation(location);
            }
            config.addIncludeRange(newIR);
        }
        if (action.equals("RemoveIncludeRange")) {
            int index;
            LOG.debug("Removing Include Range");
            specificIndex = request.getParameter("index");
            int index1 = index = WebSecurityUtils.safeParseInt((String)specificIndex);
            IncludeRange ir = (IncludeRange)config.getIncludeRanges().get(index1);
            boolean result = config.removeIncludeRange(ir);
            LOG.debug("Removing Include Range result = {}", (Object)result);
        }
        if (action.equals("AddIncludeUrl")) {
            LOG.debug("Adding Include URL");
            String url = request.getParameter("iuurl");
            String timeout = request.getParameter("iutimeout");
            String retries = request.getParameter("iuretries");
            foreignSource = request.getParameter("iuforeignsource");
            String location = request.getParameter("iulocation");
            IncludeUrl iu = new IncludeUrl();
            iu.setUrl(url);
            if (timeout != null && !"".equals(timeout.trim()) && !timeout.equals(String.valueOf(config.getTimeout().orElse(null)))) {
                iu.setTimeout(Long.valueOf(WebSecurityUtils.safeParseLong((String)timeout)));
            }
            if (retries != null && !"".equals(retries.trim()) && !retries.equals(String.valueOf(config.getRetries().orElse(null)))) {
                iu.setRetries(Integer.valueOf(WebSecurityUtils.safeParseInt((String)retries)));
            }
            if (foreignSource != null && !"".equals(foreignSource.trim()) && !foreignSource.equals(config.getForeignSource().orElse(null))) {
                iu.setForeignSource(foreignSource);
            }
            if (!LocationUtils.doesLocationsMatch((String)location, (String)config.getLocation().orElse("Default"))) {
                iu.setLocation(location);
            }
            config.addIncludeUrl(iu);
        }
        if (action.equals("RemoveIncludeUrl")) {
            int index;
            LOG.debug("Removing Include URL");
            specificIndex = request.getParameter("index");
            int index1 = index = WebSecurityUtils.safeParseInt((String)specificIndex);
            IncludeUrl iu = (IncludeUrl)config.getIncludeUrls().get(index1);
            boolean result = config.removeIncludeUrl(iu);
            LOG.debug("Removing Include URL result = {}", (Object)result);
        }
        if (action.equals("AddExcludeRange")) {
            LOG.debug("Adding Exclude Range");
            String ipAddrBegin = request.getParameter("erbegin");
            String ipAddrEnd = request.getParameter("erend");
            String location = request.getParameter("erlocation");
            ExcludeRange newER = new ExcludeRange();
            newER.setBegin(ipAddrBegin);
            newER.setEnd(ipAddrEnd);
            if (!LocationUtils.doesLocationsMatch((String)location, (String)config.getLocation().orElse("Default"))) {
                newER.setLocation(location);
            }
            config.addExcludeRange(newER);
        }
        if (action.equals("RemoveExcludeRange")) {
            int index;
            LOG.debug("Removing Exclude Range");
            specificIndex = request.getParameter("index");
            int index1 = index = WebSecurityUtils.safeParseInt((String)specificIndex);
            ExcludeRange er = (ExcludeRange)config.getExcludeRanges().get(index1);
            boolean result = config.removeExcludeRange(er);
            LOG.debug("Removing Exclude Range result = {}", (Object)result);
        }
        if (action.equals("SaveAndRestart")) {
            DiscoveryConfigFactory dcf = null;
            try {
                StringWriter configString = new StringWriter();
                JaxbUtils.marshal((Object)config, (Writer)configString);
                LOG.debug(configString.toString().trim());
                dcf = DiscoveryConfigFactory.getInstance();
                dcf.saveConfiguration(config);
            }
            catch (Throwable ex) {
                LOG.error("Error while saving configuration. {}", ex);
                throw new ServletException(ex);
            }
            EventProxy proxy = null;
            try {
                proxy = Util.createEventProxy();
            }
            catch (Throwable me) {
                LOG.error(me.getMessage());
            }
            EventBuilder bldr = new EventBuilder("uei.opennms.org/internal/discoveryConfigChange", "ActionDiscoveryServlet");
            bldr.setHost("host");
            try {
                proxy.send(bldr.getEvent());
            }
            catch (Throwable me) {
                LOG.error(me.getMessage());
            }
            LOG.info("Restart Discovery requested!");
            sess.removeAttribute(ATTRIBUTE_DISCOVERY_CONFIGURATION);
            response.sendRedirect(Util.calculateUrlBase((HttpServletRequest)request, (String)"admin/discovery/config-done.jsp"));
            return;
        }
        sess.setAttribute(ATTRIBUTE_DISCOVERY_CONFIGURATION, (Object)config);
        RequestDispatcher dispatcher = this.getServletContext().getRequestDispatcher("/admin/discovery/edit-config.jsp");
        dispatcher.forward((ServletRequest)request, (ServletResponse)response);
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doPost(request, response);
    }
}

