//
// This file is part of the OpenNMS(R) Application.
//
// OpenNMS(R) is Copyright (C) 2002-2009 The OpenNMS Group, Inc.  All rights reserved.
// OpenNMS(R) is a derivative work, containing both original code, included code and modified
// code that was published under the GNU General Public License. Copyrights for modified 
// and included code are below.
//
// OpenNMS(R) is a registered trademark of The OpenNMS Group, Inc.
//
// Copyright (C) 1999-2001 Oculan Corp.  All rights reserved.
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
// For more information contact:
//      OpenNMS Licensing       <license@opennms.org>
//      http://www.opennms.org/
//      http://www.opennms.com/
//

package org.opennms.web.vulnerability;

import java.util.Date;

import org.opennms.netmgt.model.OnmsSeverity;

/**
 * A JavaBean implementation to hold information about a security vulnerability
 * as defined by OpenNMS.
 *
 * @author <A HREF="mailto:larry@opennms.org">Lawrence Karnowski </A>
 * @author <A HREF="http://www.opennms.org/">OpenNMS </A>
 * @author <A HREF="mailto:larry@opennms.org">Lawrence Karnowski </A>
 * @author <A HREF="http://www.opennms.org/">OpenNMS </A>
 * @version $Id: $
 * @since 1.8.1
 */
public class Vulnerability extends Object {
    /** Unique identifier for the event, cannot be null */
    protected int id;

    /** Unique integer identifier for node, can be null */
    protected Integer nodeId;

    /** IP Address of node's interface */
    protected String ipAddr;

    /** Unique integer identifier of service/poller package, can be null */
    protected Integer serviceId;

    /** Human-readable name of the service */
    protected String serviceName;

    /** Creation time of event in database, cannot be null */
    protected Date createTime;

    /** Last time the vulnerability scan was attempted, cannot be null */
    protected Date lastAttemptTime;

    /** Last time the vulnerability was scanned, cannot be null */
    protected Date lastScanTime;

    /** Time the vulnerability was resolved, can be null */
    protected Date resolvedTime;

    /** Free-form textual description of the event */
    protected String description;

    /**
     * Formatted display text to control how the event will appear in the
     * browser. This field may contain variables that are populated by field
     * values of the message.
     */
    protected String logMessage;

    /**
     * The Severity of event.
     * 
     * <pre>
     * 
     *   1  = Indeterminate
     *   2 = Cleared (unimplemented at this time)
     *   3 = Warning
     *   4 = Minor
     *   5 = Major
     *   6 = Critical
     *  
     * </pre>
     */
    protected OnmsSeverity severity;

    /** The human-readable name of the node of this event. Can be null. */
    protected String nodeLabel;

    /**
     * Unique integer identifier of the plugin that generated this
     * vulnerability.
     */
    protected int pluginId;

    /** Specific vulnerability type generated by the plugin. */
    protected int pluginSubId;

    /** Port that the vulnerability affects. */
    protected Integer port;

    /** Network protocol of the attack (TCP, UDP, ICMP) */
    protected String protocol;

    protected String cveEntry;

    /**
     * Only the <code>VulnerabilityFactory</code> should instantiate this
     * object.
     */
    protected Vulnerability() {
    }

    /**
     * <p>Getter for the field <code>id</code>.</p>
     *
     * @return a int.
     */
    public int getId() {
        return (id);
    }

    /**
     * <p>Getter for the field <code>createTime</code>.</p>
     *
     * @return a {@link java.util.Date} object.
     */
    public Date getCreateTime() {
        return (createTime);
    }

    /**
     * <p>Getter for the field <code>lastAttemptTime</code>.</p>
     *
     * @return a {@link java.util.Date} object.
     */
    public Date getLastAttemptTime() {
        return (lastAttemptTime);
    }

    /**
     * <p>Getter for the field <code>lastScanTime</code>.</p>
     *
     * @return a {@link java.util.Date} object.
     */
    public Date getLastScanTime() {
        return (lastScanTime);
    }

    /**
     * can be null
     *
     * @return a {@link java.util.Date} object.
     */
    public Date getResolvedTime() {
        return (resolvedTime);
    }

    /**
     * <p>isResolved</p>
     *
     * @return a boolean.
     */
    public boolean isResolved() {
        return (resolvedTime != null);
    }

    /**
     * <p>Getter for the field <code>severity</code>.</p>
     *
     * @return a {@link org.opennms.netmgt.model.OnmsSeverity} object.
     */
    public OnmsSeverity getSeverity() {
        return severity;
    }

    /**
     * can be null
     *
     * @return a {@link java.lang.Integer} object.
     */
    public Integer getNodeId() {
        return (nodeId);
    }

    /**
     * can be null
     *
     * @return a {@link java.lang.String} object.
     */
    public String getNodeLabel() {
        return (nodeLabel);
    }

    /**
     * can be null
     *
     * @return a {@link java.lang.String} object.
     */
    public String getIpAddress() {
        return (ipAddr);
    }

    /**
     * Can be null
     *
     * @return a {@link java.lang.Integer} object.
     */
    public Integer getServiceId() {
        return (serviceId);
    }

    /**
     * <p>Getter for the field <code>serviceName</code>.</p>
     *
     * @return a {@link java.lang.String} object.
     */
    public String getServiceName() {
        return (serviceName);
    }

    /**
     * <p>Getter for the field <code>description</code>.</p>
     *
     * @return a {@link java.lang.String} object.
     */
    public String getDescription() {
        return (description);
    }

    /**
     * <p>Getter for the field <code>logMessage</code>.</p>
     *
     * @return a {@link java.lang.String} object.
     */
    public String getLogMessage() {
        return (logMessage);
    }

    /**
     * <p>Getter for the field <code>pluginId</code>.</p>
     *
     * @return a int.
     */
    public int getPluginId() {
        return (pluginId);
    }

    /**
     * <p>Getter for the field <code>pluginSubId</code>.</p>
     *
     * @return a int.
     */
    public int getPluginSubId() {
        return (pluginSubId);
    }

    /**
     * can be null
     *
     * @return a {@link java.lang.Integer} object.
     */
    public Integer getPort() {
        return (port);
    }

    /**
     * can be null
     *
     * @return a {@link java.lang.String} object.
     */
    public String getProtocol() {
        return (protocol);
    }

    /**
     * can be null
     *
     * @return a {@link java.lang.String} object.
     */
    public String getCveEntry() {
        return (cveEntry);
    }

}
