//
// This file is part of the OpenNMS(R) Application.
//
// OpenNMS(R) is Copyright (C) 2006 The OpenNMS Group, Inc.  All rights reserved.
// OpenNMS(R) is a derivative work, containing both original code, included code and modified
// code that was published under the GNU General Public License. Copyrights for modified
// and included code are below.
//
// OpenNMS(R) is a registered trademark of The OpenNMS Group, Inc.
//
// Original code base Copyright (C) 1999-2001 Oculan Corp.  All rights reserved.
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
// For more information contact:
//      OpenNMS Licensing       <license@opennms.org>
//      http://www.opennms.org/
//      http://www.opennms.com/
//
/**
 * <p>KscResultSet class.</p>
 *
 * @author ranger
 * @version $Id: $
 * @since 1.8.1
 */
package org.opennms.web.graph;

import java.util.Date;

import org.opennms.netmgt.model.PrefabGraph;
import org.opennms.netmgt.model.OnmsResource;
public class KscResultSet {
    private final String m_title;
    private final Date m_start;
    private final Date m_end;
    private final OnmsResource m_resource;
    private final PrefabGraph m_prefabGraph;
    
    /**
     * <p>Constructor for KscResultSet.</p>
     *
     * @param title a {@link java.lang.String} object.
     * @param start a java$util$Date object.
     * @param end a java$util$Date object.
     * @param resource a {@link org.opennms.netmgt.model.OnmsResource} object.
     * @param prefabGraph a {@link org.opennms.netmgt.model.PrefabGraph} object.
     */
    public KscResultSet(String title, Date start, Date end, OnmsResource resource, PrefabGraph prefabGraph) {
        m_title = title;
        m_start = start;
        m_end = end;
        m_resource = resource;
        m_prefabGraph = prefabGraph;
    }
    
    /**
     * <p>getTitle</p>
     *
     * @return a {@link java.lang.String} object.
     */
    public String getTitle() {
        return m_title;
    }
    
    /**
     * <p>getStart</p>
     *
     * @return a java$util$Date object.
     */
    public Date getStart() {
        return m_start;
    }
    
    /**
     * <p>getEnd</p>
     *
     * @return a java$util$Date object.
     */
    public Date getEnd() {
        return m_end;
    }
    
    /**
     * <p>getResource</p>
     *
     * @return a {@link org.opennms.netmgt.model.OnmsResource} object.
     */
    public OnmsResource getResource() {
        return m_resource;
    }
    
    /**
     * <p>getPrefabGraph</p>
     *
     * @return a {@link org.opennms.netmgt.model.PrefabGraph} object.
     */
    public PrefabGraph getPrefabGraph() {
        return m_prefabGraph;
    }
}
