//
// This file is part of the OpenNMS(R) Application.
//
// OpenNMS(R) is Copyright (C) 2002-2003 The OpenNMS Group, Inc.  All rights reserved.
// OpenNMS(R) is a derivative work, containing both original code, included code and modified
// code that was published under the GNU General Public License. Copyrights for modified 
// and included code are below.
//
// OpenNMS(R) is a registered trademark of The OpenNMS Group, Inc.
//
// Copyright (C) 1999-2001 Oculan Corp.  All rights reserved.
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
// For more information contact:
//      OpenNMS Licensing       <license@opennms.org>
//      http://www.opennms.org/
//      http://www.opennms.com/
//

package org.opennms.web.vulnerability;

import java.util.Date;

/**
 * A JavaBean implementation to hold information about a security vulnerability
 * as defined by OpenNMS.
 * 
 * @author <A HREF="mailto:larry@opennms.org">Lawrence Karnowski </A>
 * @author <A HREF="http://www.opennms.org/">OpenNMS </A>
 */
public class Vulnerability extends Object {
    public static final int INDETERMINATE_SEVERITY = 1;

    public static final int CLEARED_SEVERITY = 2;

    public static final int NORMAL_SEVERITY = 3;

    public static final int WARNING_SEVERITY = 4;

    public static final int MINOR_SEVERITY = 5;

    public static final int MAJOR_SEVERITY = 6;

    public static final int CRITICAL_SEVERITY = 7;

    /** Unique identifier for the event, cannot be null */
    protected int id;

    /** Unique integer identifier for node, can be null */
    protected Integer nodeId;

    /** IP Address of node's interface */
    protected String ipAddr;

    /** Unique integer identifier of service/poller package, can be null */
    protected Integer serviceId;

    /** Human-readable name of the service */
    protected String serviceName;

    /** Creation time of event in database, cannot be null */
    protected Date createTime;

    /** Last time the vulnerability scan was attempted, cannot be null */
    protected Date lastAttemptTime;

    /** Last time the vulnerability was scanned, cannot be null */
    protected Date lastScanTime;

    /** Time the vulnerability was resolved, can be null */
    protected Date resolvedTime;

    /** Free-form textual description of the event */
    protected String description;

    /**
     * Formatted display text to control how the event will appear in the
     * browser. This field may contain variables that are populated by field
     * values of the message.
     */
    protected String logMessage;

    /**
     * The Severity of event.
     * 
     * <pre>
     * 
     *   1  = Indeterminate
     *   2 = Cleared (unimplemented at this time)
     *   3 = Warning
     *   4 = Minor
     *   5 = Major
     *   6 = Critical
     *  
     * </pre>
     */
    protected int severity;

    /** The human-readable name of the node of this event. Can be null. */
    protected String nodeLabel;

    /**
     * Unique integer identifier of the plugin that generated this
     * vulnerability.
     */
    protected int pluginId;

    /** Specific vulnerability type generated by the plugin. */
    protected int pluginSubId;

    /** Port that the vulnerability affects. */
    protected Integer port;

    /** Network protocol of the attack (TCP, UDP, ICMP) */
    protected String protocol;

    protected String cveEntry;

    /**
     * Only the <code>VulnerabilityFactory</code> should instantiate this
     * object.
     */
    protected Vulnerability() {
    }

    public int getId() {
        return (this.id);
    }

    public Date getCreateTime() {
        return (this.createTime);
    }

    public Date getLastAttemptTime() {
        return (this.lastAttemptTime);
    }

    public Date getLastScanTime() {
        return (this.lastScanTime);
    }

    /** can be null */
    public Date getResolvedTime() {
        return (this.resolvedTime);
    }

    public boolean isResolved() {
        return (this.resolvedTime != null);
    }

    public int getSeverity() {
        return (this.severity);
    }

    /** can be null */
    public Integer getNodeId() {
        return (this.nodeId);
    }

    /** can be null */
    public String getNodeLabel() {
        return (this.nodeLabel);
    }

    /** can be null */
    public String getIpAddress() {
        return (this.ipAddr);
    }

    /** Can be null */
    public Integer getServiceId() {
        return (this.serviceId);
    }

    public String getServiceName() {
        return (this.serviceName);
    }

    public String getDescription() {
        return (this.description);
    }

    public String getLogMessage() {
        return (this.logMessage);
    }

    public int getPluginId() {
        return (this.pluginId);
    }

    public int getPluginSubId() {
        return (this.pluginSubId);
    }

    /** can be null */
    public Integer getPort() {
        return (this.port);
    }

    /** can be null */
    public String getProtocol() {
        return (this.protocol);
    }

    /** can be null */
    public String getCveEntry() {
        return (this.cveEntry);
    }

}
