//
// This file is part of the OpenNMS(R) Application.
//
// OpenNMS(R) is Copyright (C) 2002-2003 The OpenNMS Group, Inc.  All rights reserved.
// OpenNMS(R) is a derivative work, containing both original code, included code and modified
// code that was published under the GNU General Public License. Copyrights for modified 
// and included code are below.
//
// OpenNMS(R) is a registered trademark of The OpenNMS Group, Inc.
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
// For more information contact:
//      OpenNMS Licensing       <license@opennms.org>
//      http://www.opennms.org/
//      http://www.opennms.com/
//

package org.opennms.web.event.filter;

import java.sql.PreparedStatement;
import java.sql.SQLException;

/** Encapsulates all node filtering functionality. */
public class AlarmIDFilter extends Object implements Filter {
    public static final String TYPE = "alarm";

    protected int alarmId;

    public AlarmIDFilter(int alarmId) {
        this.alarmId = alarmId;
    }

    public String getSql() {
        return (" ALARMID=" + this.alarmId);
    }
    
    public String getParamSql() {
        return (" ALARMID=?");
    }
    
    public int bindParam(PreparedStatement ps, int parameterIndex) throws SQLException {
    	ps.setInt(parameterIndex, this.alarmId);
    	return 1;
    }

    public String getDescription() {
        return (TYPE + "=" + this.alarmId);
    }

    public String getTextDescription() {
        return ("event reduced by alarmID: " + this.alarmId);
    }

    public String toString() {
        return ("<EventFactory.AlarmIDFilter: " + this.getDescription() + ">");
    }

    public int getAlarmId() {
        return (this.alarmId);
    }

    public boolean equals(Object obj) {
        return (this.toString().equals(obj.toString()));
    }
}
