//
// This file is part of the OpenNMS(R) Application.
//
// OpenNMS(R) is Copyright (C) 2006 The OpenNMS Group, Inc.  All rights reserved.
// OpenNMS(R) is a derivative work, containing both original code, included code and modified
// code that was published under the GNU General Public License. Copyrights for modified
// and included code are below.
//
// OpenNMS(R) is a registered trademark of The OpenNMS Group, Inc.
//
// Original code base Copyright (C) 1999-2001 Oculan Corp.  All rights reserved.
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
// For more information contact:
//      OpenNMS Licensing       <license@opennms.org>
//      http://www.opennms.org/
//      http://www.opennms.com/
//
package org.opennms.web.map;

/**
 * 
 * @author maumig
 * This class contains some constants for Maps application
 *
 */
public final class MapsConstants {
	
	public static final String LOG4J_CATEGORY = "OpenNMS.Map";
	
	public static final int MAP_NOT_OPENED = -1;
	
	public static final int NEW_MAP = -2;
	
	public static final String DEFAULT_BACKGROUND_COLOR = "ffffff";

	public static final String INIT_ACTION = "Init";
	
	public static final String LOADMAPS_ACTION = "LoadMaps";
	
	public static final String LOADNODES_ACTION = "LoadNodes";
	
	public static final String NEWMAP_ACTION = "NewMap";

	public static final String OPENMAP_ACTION = "OpenMap";
	
	public static final String CLOSEMAP_ACTION = "CloseMap";
	
	public static final String SAVEMAP_ACTION = "SaveMap";
	
	public static final String LOAD_NODES_INFO_ACTION = "LoadNodesInfo";	
	
	public static final String ADDNODES_ACTION = "AddNodes";
	
	public static final String ADDNODES_BY_CATEGORY_ACTION = "AddNodesByCategory";
	
	public static final String ADDNODES_BY_LABEL_ACTION = "AddNodesByLabel";
	
	public static final String ADDRANGE_ACTION = "AddRange";
	
	public static final String ADDMAPS_ACTION = "AddMaps";

	public static final String REFRESH_ACTION = "Refresh";
	
	public static final String RELOAD_ACTION = "Reload";

	public static final String ADDNODES_WITH_NEIG_ACTION = "AddNodesWithNeig";

	public static final String ADDMAPS_WITH_NEIG_ACTION = "AddMapsWithNeig";

	public static final String ADDNODES_NEIG_ACTION = "AddNodesNeig";

	public static final String ADDMAPS_NEIG_ACTION = "AddMapsNeig";

	public static final String DELETENODES_ACTION = "DeleteNodes";

	public static final String DELETEMAPS_ACTION = "DeleteMaps";
	
	public static final String DELETEMAP_ACTION = "DeleteMap";	

	public static final String CLEAR_ACTION = "Clear";

	
}
