/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.svclayer.support;

import java.io.Serializable;
import java.util.SortedSet;
import org.easymock.EasyMock;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.opennms.netmgt.dao.api.ResourceDao;
import org.opennms.netmgt.dao.api.StatisticsReportDao;
import org.opennms.netmgt.model.ResourceReference;
import org.opennms.netmgt.model.StatisticsReport;
import org.opennms.netmgt.model.StatisticsReportData;
import org.opennms.test.ThrowableAnticipator;
import org.opennms.test.mock.EasyMockUtils;
import org.opennms.web.command.StatisticsReportCommand;
import org.opennms.web.svclayer.support.DefaultStatisticsReportService;
import org.opennms.web.svclayer.support.StatisticsReportModel;
import org.springframework.validation.BindException;

public class DefaultStatisticsReportServiceTest {
    private EasyMockUtils m_mocks = new EasyMockUtils();
    private DefaultStatisticsReportService m_service = new DefaultStatisticsReportService();
    private ResourceDao m_resourceDao = (ResourceDao)this.m_mocks.createMock(ResourceDao.class);
    private StatisticsReportDao m_statisticsReportDao = (StatisticsReportDao)this.m_mocks.createMock(StatisticsReportDao.class);

    @Before
    public void setUp() throws Exception {
        this.m_service.setResourceDao(this.m_resourceDao);
        this.m_service.setStatisticsReportDao(this.m_statisticsReportDao);
        this.m_service.afterPropertiesSet();
    }

    @After
    public void verify() throws Throwable {
        this.m_mocks.verifyAll();
    }

    @Test
    public void testNullCommandObjectId() {
        StatisticsReportCommand command = new StatisticsReportCommand();
        BindException errors = new BindException((Object)command, "");
        ThrowableAnticipator ta = new ThrowableAnticipator();
        ta.anticipate((Throwable)new IllegalArgumentException("id property on command object cannot be null"));
        this.m_mocks.replayAll();
        try {
            this.m_service.getReport(command, errors);
        }
        catch (Throwable t) {
            ta.throwableReceived(t);
        }
        ta.verifyAnticipated();
    }

    @Test
    public void testDatumWithNonExistentResource() {
        StatisticsReport report = new StatisticsReport();
        report.setId(Integer.valueOf(1));
        StatisticsReportData datum = new StatisticsReportData();
        ResourceReference resourceRef = new ResourceReference();
        resourceRef.setId(Integer.valueOf(1));
        resourceRef.setResourceId("node[1].interfaceSnmp[en0]");
        datum.setId(Integer.valueOf(1));
        datum.setResource(resourceRef);
        datum.setReport(report);
        datum.setValue(Double.valueOf(0.1));
        report.addData(datum);
        StatisticsReportCommand command = new StatisticsReportCommand();
        command.setId(report.getId());
        BindException errors = new BindException((Object)command, "");
        EasyMock.expect((Object)this.m_statisticsReportDao.load((Serializable)report.getId())).andReturn((Object)report);
        this.m_statisticsReportDao.initialize((Object)report);
        this.m_statisticsReportDao.initialize((Object)report.getData());
        EasyMock.expect((Object)this.m_resourceDao.getResourceById(resourceRef.getResourceId())).andReturn(null);
        this.m_mocks.replayAll();
        StatisticsReportModel model = this.m_service.getReport(command, errors);
        Assert.assertNotNull((String)"model should not be null", (Object)model);
        Assert.assertNotNull((String)"model.getData() should not be null", (Object)model.getData());
        SortedSet data = model.getData();
        Assert.assertEquals((String)"data size", (long)1L, (long)data.size());
        StatisticsReportModel.Datum d = (StatisticsReportModel.Datum)data.first();
        Assert.assertNotNull((String)"first datum should not be null", (Object)d);
        Assert.assertNull((String)"first datum resource should be null", (Object)d.getResource());
    }
}

