/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.svclayer.support;

import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.opennms.api.reporting.ReportMode;
import org.opennms.api.reporting.parameter.ReportParameters;
import org.opennms.core.test.MockLogAppender;
import org.opennms.core.test.OpenNMSJUnit4ClassRunner;
import org.opennms.core.utils.BeanUtils;
import org.opennms.reporting.core.DeliveryOptions;
import org.opennms.reporting.core.svclayer.ReportWrapperService;
import org.opennms.web.svclayer.support.DefaultSchedulerService;
import org.opennms.web.svclayer.support.TriggerDescription;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.quartz.SchedulerFactoryBean;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.webflow.execution.RequestContext;
import org.springframework.webflow.test.MockRequestContext;

@RunWith(value=OpenNMSJUnit4ClassRunner.class)
@ContextConfiguration(locations={"classpath:org/opennms/web/svclayer/schedulerServiceTest.xml"})
public class DefaultSchedulerServiceTest
implements InitializingBean {
    @Autowired
    private DefaultSchedulerService m_schedulerService;
    @Autowired
    private SchedulerFactoryBean m_schedulerFactory;
    @Autowired
    private ReportWrapperService m_reportWrapperService;
    Scheduler m_scheduler;
    private static ReportParameters m_criteria;
    private static String REPORT_ID;
    private static String CRON_EXPRESSION;
    private static final String TRIGGER_GROUP = "reporting";

    @BeforeClass
    public static void setUp() {
        MockLogAppender.setupLogging();
        m_criteria = new ReportParameters();
        m_criteria.setReportId(REPORT_ID);
    }

    @Before
    public void resetReportService() {
        EasyMock.reset((Object[])new Object[]{this.m_reportWrapperService});
        this.m_scheduler = this.m_schedulerFactory.getScheduler();
    }

    public void afterPropertiesSet() throws Exception {
        BeanUtils.assertAutowiring((Object)this);
    }

    @Test
    public void testExecuteSuccess() throws InterruptedException {
        EasyMock.expect((Object)this.m_reportWrapperService.validate(m_criteria, REPORT_ID)).andReturn((Object)true);
        DeliveryOptions deliveryOptions = new DeliveryOptions();
        deliveryOptions.setInstanceId("testExecuteSuccessTrigger");
        this.m_reportWrapperService.run(m_criteria, ReportMode.IMMEDIATE, deliveryOptions, REPORT_ID);
        EasyMock.replay((Object[])new Object[]{this.m_reportWrapperService});
        MockRequestContext context = new MockRequestContext();
        Assert.assertEquals((Object)"success", (Object)this.m_schedulerService.execute(REPORT_ID, m_criteria, deliveryOptions, (RequestContext)context));
        Thread.sleep(1000L);
        EasyMock.verify((Object[])new Object[]{this.m_reportWrapperService});
    }

    @Test
    public void testExecuteFailure() throws InterruptedException {
        EasyMock.expect((Object)this.m_reportWrapperService.validate(m_criteria, REPORT_ID)).andReturn((Object)false);
        EasyMock.replay((Object[])new Object[]{this.m_reportWrapperService});
        MockRequestContext context = new MockRequestContext();
        DeliveryOptions deliveryOptions = new DeliveryOptions();
        deliveryOptions.setInstanceId("testExecuteFailureTrigger");
        Assert.assertEquals((Object)"error", (Object)this.m_schedulerService.execute(REPORT_ID, m_criteria, deliveryOptions, (RequestContext)context));
        Thread.sleep(1000L);
        EasyMock.verify((Object[])new Object[]{this.m_reportWrapperService});
    }

    @Test
    public void testScheduleBadCronExpression() {
        EasyMock.expect((Object)this.m_reportWrapperService.validate(m_criteria, REPORT_ID)).andReturn((Object)true);
        EasyMock.replay((Object[])new Object[]{this.m_reportWrapperService});
        MockRequestContext context = new MockRequestContext();
        DeliveryOptions deliveryOptions = new DeliveryOptions();
        deliveryOptions.setInstanceId("testScheduleBadCronExpressionTrigger");
        Assert.assertEquals((Object)"error", (Object)this.m_schedulerService.addCronTrigger(REPORT_ID, m_criteria, deliveryOptions, "bad expression", (RequestContext)context));
        EasyMock.verify((Object[])new Object[]{this.m_reportWrapperService});
    }

    @Test
    public void testScheduleAndRemove() throws SchedulerException {
        EasyMock.expect((Object)this.m_reportWrapperService.validate(m_criteria, REPORT_ID)).andReturn((Object)true);
        EasyMock.replay((Object[])new Object[]{this.m_reportWrapperService});
        MockRequestContext context = new MockRequestContext();
        DeliveryOptions deliveryOptions = new DeliveryOptions();
        deliveryOptions.setInstanceId("testScheduleAndRemoveTrigger");
        Assert.assertEquals((Object)"success", (Object)this.m_schedulerService.addCronTrigger(REPORT_ID, m_criteria, deliveryOptions, CRON_EXPRESSION, (RequestContext)context));
        EasyMock.verify((Object[])new Object[]{this.m_reportWrapperService});
        String[] triggers = this.m_scheduler.getTriggerNames(TRIGGER_GROUP);
        Assert.assertEquals((long)1L, (long)triggers.length);
        Assert.assertEquals((Object)"testScheduleAndRemoveTrigger", (Object)triggers[0]);
        this.m_schedulerService.removeTrigger("testScheduleAndRemoveTrigger");
        Assert.assertEquals((long)0L, (long)this.m_scheduler.getTriggerNames(TRIGGER_GROUP).length);
    }

    @Test
    public void testMultipleTriggers() throws SchedulerException {
        EasyMock.expect((Object)this.m_reportWrapperService.validate(m_criteria, REPORT_ID)).andReturn((Object)true).times(2);
        EasyMock.replay((Object[])new Object[]{this.m_reportWrapperService});
        MockRequestContext context = new MockRequestContext();
        DeliveryOptions deliveryOptions1 = new DeliveryOptions();
        deliveryOptions1.setInstanceId("trigger1");
        Assert.assertEquals((Object)"success", (Object)this.m_schedulerService.addCronTrigger(REPORT_ID, m_criteria, deliveryOptions1, "0 0/10 * * * ?", (RequestContext)context));
        DeliveryOptions deliveryOptions2 = new DeliveryOptions();
        deliveryOptions2.setInstanceId("trigger2");
        Assert.assertEquals((Object)"success", (Object)this.m_schedulerService.addCronTrigger(REPORT_ID, m_criteria, deliveryOptions2, "0 5/10 * * * ?", (RequestContext)context));
        EasyMock.verify((Object[])new Object[]{this.m_reportWrapperService});
        String[] triggers = this.m_scheduler.getTriggerNames(TRIGGER_GROUP);
        Assert.assertEquals((long)2L, (long)triggers.length);
        Assert.assertEquals((Object)"trigger1", (Object)triggers[0]);
        Assert.assertEquals((Object)"trigger2", (Object)triggers[1]);
        this.m_schedulerService.removeTrigger("trigger1");
        this.m_schedulerService.removeTrigger("trigger2");
        Assert.assertEquals((long)0L, (long)this.m_scheduler.getTriggerNames(TRIGGER_GROUP).length);
    }

    @Test
    public void testScheduleAndRun() throws SchedulerException, InterruptedException {
        DeliveryOptions deliveryOptions = new DeliveryOptions();
        deliveryOptions.setInstanceId("testScheduleAndRunTrigger");
        EasyMock.expect((Object)this.m_reportWrapperService.validate(m_criteria, REPORT_ID)).andReturn((Object)true);
        this.m_reportWrapperService.run(m_criteria, ReportMode.SCHEDULED, deliveryOptions, REPORT_ID);
        EasyMock.replay((Object[])new Object[]{this.m_reportWrapperService});
        MockRequestContext context = new MockRequestContext();
        Assert.assertEquals((Object)"success", (Object)this.m_schedulerService.addCronTrigger(REPORT_ID, m_criteria, deliveryOptions, CRON_EXPRESSION, (RequestContext)context));
        Thread.sleep(61000L);
        this.m_schedulerService.removeTrigger("testScheduleAndRunTrigger");
        EasyMock.verify((Object[])new Object[]{this.m_reportWrapperService});
        this.m_schedulerService.removeTrigger("testScheduleAndRunTrigger");
        Assert.assertEquals((long)0L, (long)this.m_scheduler.getTriggerNames(TRIGGER_GROUP).length);
    }

    @Test
    public void testExists() {
        EasyMock.expect((Object)this.m_reportWrapperService.validate(m_criteria, REPORT_ID)).andReturn((Object)true);
        EasyMock.replay((Object[])new Object[]{this.m_reportWrapperService});
        MockRequestContext context = new MockRequestContext();
        DeliveryOptions deliveryOptions = new DeliveryOptions();
        deliveryOptions.setInstanceId("testExistsTrigger");
        Assert.assertEquals((Object)"success", (Object)this.m_schedulerService.addCronTrigger(REPORT_ID, m_criteria, deliveryOptions, CRON_EXPRESSION, (RequestContext)context));
        EasyMock.verify((Object[])new Object[]{this.m_reportWrapperService});
        Assert.assertTrue((boolean)this.m_schedulerService.exists("testExistsTrigger"));
        Assert.assertFalse((boolean)this.m_schedulerService.exists("bogusTrigger"));
        this.m_schedulerService.removeTrigger("testExistsTrigger");
    }

    @Test
    public void testGetTriggerDescriptions() {
        EasyMock.expect((Object)this.m_reportWrapperService.validate(m_criteria, REPORT_ID)).andReturn((Object)true);
        EasyMock.replay((Object[])new Object[]{this.m_reportWrapperService});
        MockRequestContext context = new MockRequestContext();
        DeliveryOptions deliveryOptions = new DeliveryOptions();
        deliveryOptions.setInstanceId("testGetTriggerDescriptionsTrigger");
        Assert.assertEquals((Object)"success", (Object)this.m_schedulerService.addCronTrigger(REPORT_ID, m_criteria, deliveryOptions, CRON_EXPRESSION, (RequestContext)context));
        EasyMock.verify((Object[])new Object[]{this.m_reportWrapperService});
        Assert.assertEquals((long)1L, (long)this.m_schedulerService.getTriggerDescriptions().size());
        Assert.assertEquals((Object)"testGetTriggerDescriptionsTrigger", (Object)((TriggerDescription)this.m_schedulerService.getTriggerDescriptions().get(0)).getTriggerName());
        this.m_schedulerService.removeTrigger("testGetTriggerDescriptionsTrigger");
    }

    static {
        REPORT_ID = "test";
        CRON_EXPRESSION = "0 * * * * ?";
    }
}

