/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.svclayer.catstatus.support;

import java.util.ArrayList;
import java.util.Collection;
import junit.framework.TestCase;
import org.easymock.EasyMock;
import org.opennms.netmgt.config.categories.Category;
import org.opennms.netmgt.config.viewsdisplay.Section;
import org.opennms.netmgt.config.viewsdisplay.View;
import org.opennms.netmgt.dao.api.OutageDao;
import org.opennms.netmgt.model.OnmsIpInterface;
import org.opennms.netmgt.model.OnmsMonitoredService;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.model.OnmsOutage;
import org.opennms.netmgt.model.OnmsServiceType;
import org.opennms.netmgt.model.OnmsSnmpInterface;
import org.opennms.netmgt.model.ServiceSelector;
import org.opennms.web.svclayer.catstatus.model.StatusCategory;
import org.opennms.web.svclayer.catstatus.model.StatusNode;
import org.opennms.web.svclayer.catstatus.model.StatusSection;
import org.opennms.web.svclayer.catstatus.support.DefaultCategoryStatusService;
import org.opennms.web.svclayer.dao.CategoryConfigDao;
import org.opennms.web.svclayer.dao.ViewDisplayDao;

public class DefaultCategoryStatusServiceTest
extends TestCase {
    private DefaultCategoryStatusService categoryStatusService;
    private ViewDisplayDao viewDisplayDao;
    private CategoryConfigDao categoryDao;
    private OutageDao outageDao;

    protected void setUp() throws Exception {
        super.setUp();
        this.viewDisplayDao = (ViewDisplayDao)EasyMock.createMock(ViewDisplayDao.class);
        this.categoryDao = (CategoryConfigDao)EasyMock.createMock(CategoryConfigDao.class);
        this.outageDao = (OutageDao)EasyMock.createMock(OutageDao.class);
        this.categoryStatusService = new DefaultCategoryStatusService();
        this.categoryStatusService.setViewDisplayDao(this.viewDisplayDao);
        this.categoryStatusService.setCategoryConfigDao(this.categoryDao);
        this.categoryStatusService.setOutageDao(this.outageDao);
    }

    public void testCategoryGroupsReturnedWhenNoneExist() {
        View view = new View();
        EasyMock.expect((Object)this.viewDisplayDao.getView()).andReturn((Object)view);
        EasyMock.replay((Object[])new Object[]{this.viewDisplayDao});
        Collection categories = this.categoryStatusService.getCategoriesStatus();
        EasyMock.verify((Object[])new Object[]{this.viewDisplayDao});
        DefaultCategoryStatusServiceTest.assertTrue((String)"Collection Should Be Empty", (boolean)categories.isEmpty());
    }

    public void testGetCategoriesStatus() {
        View view = new View();
        Section section = new Section();
        org.opennms.netmgt.config.views.Category category = new org.opennms.netmgt.config.views.Category();
        section.setSectionName("Section One");
        section.addCategory("Category One");
        category.setLabel("Category One");
        OnmsOutage outage = new OnmsOutage();
        ArrayList<OnmsOutage> outages = new ArrayList<OnmsOutage>();
        outage.setId(Integer.valueOf(300));
        OnmsServiceType svcType = new OnmsServiceType();
        svcType.setId(Integer.valueOf(3));
        svcType.setName("HTTP");
        OnmsNode node = new OnmsNode();
        node.setId(Integer.valueOf(1));
        node.setLabel("superLabel");
        OnmsSnmpInterface snmpIface = new OnmsSnmpInterface(node, 1);
        OnmsIpInterface iface = new OnmsIpInterface("192.168.1.1", node);
        iface.setSnmpInterface(snmpIface);
        OnmsMonitoredService monSvc = new OnmsMonitoredService(iface, svcType);
        outage.setMonitoredService(monSvc);
        outages.add(outage);
        view.addSection(section);
        ArrayList<String> services = new ArrayList<String>();
        services.add("HTTP");
        EasyMock.expect((Object)this.viewDisplayDao.getView()).andReturn((Object)view);
        EasyMock.expect((Object)this.categoryDao.getCategoryByLabel(category.getLabel())).andReturn((Object)this.createCategoryFromLabel(category.getLabel()));
        EasyMock.expect((Object)this.outageDao.matchingCurrentOutages((ServiceSelector)EasyMock.isA(ServiceSelector.class))).andReturn(outages);
        EasyMock.replay((Object[])new Object[]{this.categoryDao});
        EasyMock.replay((Object[])new Object[]{this.viewDisplayDao});
        EasyMock.replay((Object[])new Object[]{this.outageDao});
        Collection statusSections = this.categoryStatusService.getCategoriesStatus();
        EasyMock.verify((Object[])new Object[]{this.viewDisplayDao});
        EasyMock.verify((Object[])new Object[]{this.categoryDao});
        EasyMock.verify((Object[])new Object[]{this.outageDao});
        DefaultCategoryStatusServiceTest.assertEquals((String)"Wrong Number of StatusSections", (int)view.getSectionCount(), (int)statusSections.size());
        for (StatusSection statusSection : statusSections) {
            DefaultCategoryStatusServiceTest.assertEquals((String)"StatusSection Name Does Not Match", (String)"Section One", (String)statusSection.getName());
            Collection statusCategorys = statusSection.getCategories();
            for (StatusCategory statusCategory : statusCategorys) {
                DefaultCategoryStatusServiceTest.assertEquals((String)"StatusCategoryName does not match", (String)"Category One", (String)statusCategory.getLabel());
                DefaultCategoryStatusServiceTest.assertTrue((String)"Nodes >= 1", (statusCategory.getNodes().size() >= 1 ? 1 : 0) != 0);
                for (StatusNode statusNode : statusCategory.getNodes()) {
                    DefaultCategoryStatusServiceTest.assertEquals((String)"Label does not match", (String)"superLabel", (String)statusNode.getLabel());
                }
            }
        }
    }

    private Category createCategoryFromLabel(String label) {
        Category category = new Category();
        category.setLabel(label);
        category.setRule("isHTTP");
        category.addService("HTTP");
        return category;
    }
}

