/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.svclayer;

import java.util.Iterator;
import java.util.List;
import org.junit.Assert;
import org.opennms.web.svclayer.Palette;
import org.opennms.web.svclayer.PaletteCategory;
import org.opennms.web.svclayer.PaletteItem;

public abstract class PaletteTestUtils
extends Assert {
    public static void assertPaletteItemEquals(PaletteItem expectedItem, PaletteItem actualItem) {
        PaletteTestUtils.assertEquals((Object)expectedItem.getId(), (Object)actualItem.getId());
        PaletteTestUtils.assertEquals((Object)expectedItem.getLabel(), (Object)actualItem.getLabel());
        PaletteTestUtils.assertEquals((Object)expectedItem.isSpacer(), (Object)actualItem.isSpacer());
    }

    public static void assertPaletteCateriesEquals(List<PaletteCategory> expectedCategories, List<PaletteCategory> actualCategories) {
        if (expectedCategories == null) {
            PaletteTestUtils.assertNull(actualCategories);
            return;
        }
        Iterator<PaletteCategory> iter = actualCategories.iterator();
        for (PaletteCategory expectedCategory : expectedCategories) {
            PaletteTestUtils.assertTrue((boolean)iter.hasNext());
            PaletteCategory actualCategory = iter.next();
            PaletteTestUtils.assertPaletteCategoryEquals(expectedCategory, actualCategory);
        }
        PaletteTestUtils.assertFalse((boolean)iter.hasNext());
    }

    public static void assertPaletteEquals(Palette expectedPalette, Palette actualPalette) {
        PaletteTestUtils.assertEquals((Object)expectedPalette.getLabel(), (Object)actualPalette.getLabel());
        PaletteTestUtils.assertPaletteCateriesEquals(expectedPalette.getCategories(), actualPalette.getCategories());
    }

    public static void assertPaletteItemsEqual(List<PaletteItem> expectedItems, List<PaletteItem> actualItems) {
        if (expectedItems == null) {
            PaletteTestUtils.assertNull(actualItems);
            return;
        }
        Iterator<PaletteItem> iter = actualItems.iterator();
        for (PaletteItem expectedItem : expectedItems) {
            PaletteTestUtils.assertTrue((String)("More expected items than actual, Missing: " + expectedItem), (boolean)iter.hasNext());
            PaletteItem actualItem = iter.next();
            PaletteTestUtils.assertPaletteItemEquals(expectedItem, actualItem);
        }
        if (iter.hasNext()) {
            PaletteTestUtils.fail((String)("More actual items than expected, Found: " + iter.next()));
        }
    }

    public static void assertPaletteCategoryEquals(PaletteCategory expectedCategory, PaletteCategory actualCategory) {
        PaletteTestUtils.assertEquals((String)"Unexpected category label", (Object)expectedCategory.getLabel(), (Object)actualCategory.getLabel());
        PaletteTestUtils.assertPaletteItemsEqual(expectedCategory.getItems(), actualCategory.getItems());
    }
}

