/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.svclayer;

import junit.framework.TestCase;
import org.opennms.web.svclayer.Palette;
import org.opennms.web.svclayer.PaletteBuilder;
import org.opennms.web.svclayer.PaletteCategory;
import org.opennms.web.svclayer.PaletteItem;
import org.opennms.web.svclayer.PaletteTestUtils;

public class PaletteBuilderTest
extends TestCase {
    private Palette m_palette;
    private PaletteCategory m_currentCat;

    public void testBuildingPalatte() {
        this.m_palette = new Palette("paletteLabel");
        PaletteBuilder m_builder = new PaletteBuilder("paletteLabel");
        m_builder.addCategory("cat1");
        this.createCategory("cat1");
        m_builder.addItem("c1a_id", "c1a_label");
        this.createItem("c1a_id", "c1a_label");
        m_builder.addItem("c1b_id", "c1b_label");
        this.createItem("c1b_id", "c1b_label");
        m_builder.addItem("c1c_id", "c1c_label");
        this.createItem("c1c_id", "c1c_label");
        m_builder.addCategory("cat2");
        this.createCategory("cat2");
        m_builder.addItem("c2a_id", "c2a_label");
        this.createItem("c2a_id", "c2a_label");
        m_builder.addSpacer();
        this.createSpacer();
        m_builder.addItem("c2b_id", "c2b_label");
        this.createItem("c2b_id", "c2b_label");
        PaletteTestUtils.assertPaletteEquals(this.m_palette, m_builder.getPalette());
    }

    private void createSpacer() {
        this.m_currentCat.addItem(PaletteItem.SPACER);
    }

    private void createCategory(String label) {
        PaletteCategory cat = new PaletteCategory(label);
        this.m_palette.addCategory(cat);
        this.m_currentCat = cat;
    }

    private void createItem(String id, String label) {
        PaletteItem item = new PaletteItem(id, label);
        this.m_currentCat.addItem(item);
    }
}

