/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.rest;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.xml.bind.JAXBContext;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.opennms.core.test.OpenNMSJUnit4ClassRunner;
import org.opennms.core.test.db.annotations.JUnitTemporaryDatabase;
import org.opennms.core.test.rest.AbstractSpringJerseyRestTestCase;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.config.SnmpPeerFactory;
import org.opennms.netmgt.snmp.SnmpAgentConfig;
import org.opennms.test.JUnitConfigurationEnvironment;
import org.opennms.web.snmpinfo.SnmpInfo;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.web.WebAppConfiguration;

@RunWith(value=OpenNMSJUnit4ClassRunner.class)
@WebAppConfiguration
@ContextConfiguration(locations={"classpath:/org/opennms/web/rest/applicationContext-test.xml", "classpath:/META-INF/opennms/applicationContext-commonConfigs.xml", "classpath:/META-INF/opennms/applicationContext-soa.xml", "classpath:/META-INF/opennms/applicationContext-dao.xml", "classpath*:/META-INF/opennms/component-service.xml", "classpath*:/META-INF/opennms/component-dao.xml", "classpath:/META-INF/opennms/applicationContext-reportingCore.xml", "classpath:/META-INF/opennms/applicationContext-databasePopulator.xml", "classpath:/org/opennms/web/svclayer/applicationContext-svclayer.xml", "classpath:/META-INF/opennms/applicationContext-mockEventProxy.xml", "classpath:/applicationContext-jersey-test.xml", "classpath:/META-INF/opennms/applicationContext-reporting.xml", "classpath:/META-INF/opennms/applicationContext-mock-usergroup.xml", "classpath:/META-INF/opennms/applicationContext-minimal-conf.xml", "file:src/main/webapp/WEB-INF/applicationContext-spring-security.xml", "file:src/main/webapp/WEB-INF/applicationContext-jersey.xml"})
@JUnitConfigurationEnvironment
@JUnitTemporaryDatabase
public class SnmpConfigRestServiceTest
extends AbstractSpringJerseyRestTestCase {
    private static final int DEFAULT_PORT = 9161;
    private static final int DEFAULT_RETRIES = 5;
    private static final int DEFAULT_TIMEOUT = 2000;
    private static final String DEFAULT_COMMUNITY = "myPublic";
    private static final String DEFAULT_VERSION = "v1";
    private static final int DEFAULT_MAX_VARS_PER_PDU = 100;
    private static final int DEFAULT_MAX_REPETITIONS = 3;
    private JAXBContext m_jaxbContext;
    private File m_snmpConfigFile;

    protected void beforeServletStart() throws Exception {
        File dir = new File("target/test-work-dir");
        dir.mkdirs();
        this.setSnmpConfigFile(this.getSnmpDefaultConfigFileForSnmpV1());
        this.m_jaxbContext = JAXBContext.newInstance((Class[])new Class[]{SnmpInfo.class});
    }

    private String getSnmpDefaultConfigFileForSnmpV1() {
        return String.format("<?xml version=\"1.0\"?><snmp-config port=\"%s\" retry=\"%s\" timeout=\"%s\"\n             read-community=\"%s\" \n\t\t\t\tversion=\"%s\" \n             max-vars-per-pdu=\"%s\" max-repetitions=\"%s\"  />", 9161, 5, 2000, DEFAULT_COMMUNITY, DEFAULT_VERSION, 100, 3);
    }

    private String getSnmpDefaultConfigFileForSnmpV3() {
        return String.format("<?xml version=\"1.0\"?><snmp-config port=\"%s\" retry=\"%s\" timeout=\"%s\"\n\t\t\t\tversion=\"%s\" \n             max-vars-per-pdu=\"%s\" max-repetitions=\"%s\"  />", 9161, 5, 2000, "v3", 100, 3);
    }

    private void setSnmpConfigFile(String snmpConfigContent) throws IOException {
        this.m_snmpConfigFile = File.createTempFile("snmp-config-", ".xml");
        this.m_snmpConfigFile.deleteOnExit();
        FileUtils.writeStringToFile((File)this.m_snmpConfigFile, (String)snmpConfigContent);
        SnmpPeerFactory.setFile((File)this.m_snmpConfigFile);
        SnmpPeerFactory.init();
    }

    @Test
    public void testGetForUnknownIpSnmpV1() throws Exception {
        String url = "/snmpConfig/1.1.1.1";
        SnmpInfo config = (SnmpInfo)this.getXmlObject(this.m_jaxbContext, url, 200, SnmpInfo.class);
        SnmpInfo expectedConfig = this.createSnmpInfoWithDefaultsForSnmpV1();
        this.assertConfiguration(expectedConfig, config);
        this.assertSnmpV3PropertiesHaveNotBeenSet(config);
    }

    @Test
    public void testGetForUnknownIpSnmpV3() throws Exception {
        String url = "/snmpConfig/1.1.1.1";
        this.setSnmpConfigFile(this.getSnmpDefaultConfigFileForSnmpV3());
        SnmpInfo config = (SnmpInfo)this.getXmlObject(this.m_jaxbContext, url, 200, SnmpInfo.class);
        SnmpInfo expectedConfig = this.createSnmpInfoWithDefaultsForSnmpV3("1.1.1.1");
        this.assertConfiguration(expectedConfig, config);
        this.assertSnmpV1PropertiesHaveNotBeenSet(config);
    }

    @Test
    public void testSetNewValueForSnmpV2c() throws Exception {
        String url = "/snmpConfig/1.1.1.1";
        SnmpInfo config = (SnmpInfo)this.getXmlObject(this.m_jaxbContext, url, 200, SnmpInfo.class);
        SnmpInfo expectedConfig = this.createSnmpInfoWithDefaultsForSnmpV3("1.1.1.1");
        this.assertConfiguration(expectedConfig, config);
        config.setAuthPassPhrase("authPassPhrase");
        config.setAuthProtocol("authProtocol");
        config.setReadCommunity("readCommunity");
        config.setWriteCommunity("writeCommunity");
        config.setContextEngineId("contextEngineId");
        config.setContextName("contextName");
        config.setEngineId("engineId");
        config.setEnterpriseId("enterpriseId");
        config.setMaxRepetitions(Integer.valueOf(1000));
        config.setMaxVarsPerPdu(Integer.valueOf(2000));
        config.setPort(Integer.valueOf(3000));
        config.setPrivPassPhrase("privPassPhrase");
        config.setPrivProtocol("privProtocol");
        config.setProxyHost("127.0.0.1");
        config.setRetries(Integer.valueOf(4000));
        config.setSecurityLevel(Integer.valueOf(5000));
        config.setSecurityName("securityName");
        config.setTimeout(Integer.valueOf(6000));
        config.setVersion("v2c");
        config.setMaxRequestSize(Integer.valueOf(7000));
        this.putXmlObject(this.m_jaxbContext, url, 303, config, "/snmpConfig/1.1.1.1");
        expectedConfig = new SnmpInfo();
        expectedConfig.setMaxRepetitions(Integer.valueOf(1000));
        expectedConfig.setMaxVarsPerPdu(Integer.valueOf(2000));
        expectedConfig.setPort(Integer.valueOf(3000));
        expectedConfig.setRetries(Integer.valueOf(4000));
        expectedConfig.setTimeout(Integer.valueOf(6000));
        expectedConfig.setVersion("v2c");
        expectedConfig.setMaxRequestSize(Integer.valueOf(7000));
        expectedConfig.setReadCommunity("readCommunity");
        expectedConfig.setWriteCommunity("writeCommunity");
        expectedConfig.setAuthPassPhrase(null);
        expectedConfig.setAuthProtocol(null);
        expectedConfig.setContextEngineId(null);
        expectedConfig.setContextName(null);
        expectedConfig.setEngineId(null);
        expectedConfig.setEnterpriseId(null);
        expectedConfig.setPrivPassPhrase(null);
        expectedConfig.setPrivProtocol(null);
        expectedConfig.setProxyHost("127.0.0.1");
        expectedConfig.setSecurityLevel(null);
        expectedConfig.setSecurityName(null);
        SnmpInfo newConfig = (SnmpInfo)this.getXmlObject(this.m_jaxbContext, url, 200, SnmpInfo.class);
        this.assertConfiguration(expectedConfig, newConfig);
        this.dumpConfig();
    }

    @Test
    public void testSetNewValueForSnmpV3() throws Exception {
        String url = "/snmpConfig/1.1.1.1";
        SnmpInfo changedConfig = (SnmpInfo)this.getXmlObject(this.m_jaxbContext, url, 200, SnmpInfo.class);
        SnmpInfo expectedConfig = this.createSnmpInfoWithDefaultsForSnmpV3("1.1.1.1");
        this.assertConfiguration(expectedConfig, changedConfig);
        changedConfig.setAuthPassPhrase("authPassPhrase");
        changedConfig.setAuthProtocol("authProtocol");
        changedConfig.setReadCommunity("readCommunity");
        changedConfig.setWriteCommunity("writeCommunity");
        changedConfig.setContextEngineId("contextEngineId");
        changedConfig.setContextName("contextName");
        changedConfig.setEngineId("engineId");
        changedConfig.setEnterpriseId("enterpriseId");
        changedConfig.setMaxRepetitions(Integer.valueOf(1000));
        changedConfig.setMaxVarsPerPdu(Integer.valueOf(2000));
        changedConfig.setPort(Integer.valueOf(3000));
        changedConfig.setProxyHost("127.0.0.1");
        changedConfig.setPrivPassPhrase("privPassPhrase");
        changedConfig.setPrivProtocol("privProtocol");
        changedConfig.setRetries(Integer.valueOf(4000));
        changedConfig.setSecurityLevel(Integer.valueOf(5000));
        changedConfig.setSecurityName("securityName");
        changedConfig.setTimeout(Integer.valueOf(6000));
        changedConfig.setVersion("v3");
        changedConfig.setMaxRequestSize(Integer.valueOf(7000));
        this.putXmlObject(this.m_jaxbContext, url, 303, changedConfig, "/snmpConfig/1.1.1.1");
        expectedConfig = new SnmpInfo();
        expectedConfig.setAuthPassPhrase("authPassPhrase");
        expectedConfig.setAuthProtocol("authProtocol");
        expectedConfig.setContextEngineId("contextEngineId");
        expectedConfig.setContextName("contextName");
        expectedConfig.setEngineId("engineId");
        expectedConfig.setEnterpriseId("enterpriseId");
        expectedConfig.setMaxRepetitions(Integer.valueOf(1000));
        expectedConfig.setMaxVarsPerPdu(Integer.valueOf(2000));
        expectedConfig.setPort(Integer.valueOf(3000));
        expectedConfig.setProxyHost("127.0.0.1");
        expectedConfig.setPrivPassPhrase("privPassPhrase");
        expectedConfig.setPrivProtocol("privProtocol");
        expectedConfig.setRetries(Integer.valueOf(4000));
        expectedConfig.setSecurityLevel(Integer.valueOf(5000));
        expectedConfig.setSecurityName("securityName");
        expectedConfig.setTimeout(Integer.valueOf(6000));
        expectedConfig.setVersion("v3");
        expectedConfig.setMaxRequestSize(Integer.valueOf(7000));
        expectedConfig.setReadCommunity(null);
        expectedConfig.setWriteCommunity(null);
        SnmpInfo newConfig = (SnmpInfo)this.getXmlObject(this.m_jaxbContext, url, 200, SnmpInfo.class);
        this.assertConfiguration(expectedConfig, newConfig);
        this.dumpConfig();
    }

    private void dumpConfig() throws Exception {
        IOUtils.copy((InputStream)new FileInputStream(this.m_snmpConfigFile), (OutputStream)System.out);
    }

    private SnmpInfo createSnmpInfoWithDefaultsForSnmpV3(String ipAddress) {
        SnmpAgentConfig agentConfig = SnmpPeerFactory.getInstance().getAgentConfig(InetAddressUtils.addr((String)ipAddress));
        return new SnmpInfo(agentConfig);
    }

    private SnmpInfo createSnmpInfoWithDefaultsForSnmpV1() {
        SnmpAgentConfig defaults = new SnmpAgentConfig();
        SnmpInfo config = new SnmpInfo();
        config.setPort(Integer.valueOf(9161));
        config.setRetries(Integer.valueOf(5));
        config.setTimeout(Integer.valueOf(2000));
        config.setReadCommunity(DEFAULT_COMMUNITY);
        config.setVersion(DEFAULT_VERSION);
        config.setMaxVarsPerPdu(Integer.valueOf(100));
        config.setMaxRepetitions(Integer.valueOf(3));
        config.setWriteCommunity(defaults.getWriteCommunity());
        config.setMaxRequestSize(Integer.valueOf(defaults.getMaxRequestSize()));
        return config;
    }

    private void assertConfiguration(SnmpInfo expectedConfig, SnmpInfo actualConfig) {
        Assert.assertNotNull((Object)expectedConfig);
        Assert.assertNotNull((Object)actualConfig);
        Assert.assertEquals((Object)expectedConfig, (Object)actualConfig);
    }

    private void assertSnmpV3PropertiesHaveNotBeenSet(SnmpInfo config) {
        Assert.assertEquals((Object)false, (Object)config.hasSecurityLevel());
        Assert.assertEquals(null, (Object)config.getSecurityLevel());
        Assert.assertEquals(null, (Object)config.getSecurityName());
        Assert.assertEquals(null, (Object)config.getAuthPassPhrase());
        Assert.assertEquals(null, (Object)config.getAuthProtocol());
        Assert.assertEquals(null, (Object)config.getEngineId());
        Assert.assertEquals(null, (Object)config.getContextEngineId());
        Assert.assertEquals(null, (Object)config.getContextName());
        Assert.assertEquals(null, (Object)config.getPrivPassPhrase());
        Assert.assertEquals(null, (Object)config.getPrivProtocol());
        Assert.assertEquals(null, (Object)config.getEnterpriseId());
    }

    private void assertSnmpV1PropertiesHaveNotBeenSet(SnmpInfo config) {
        Assert.assertEquals(null, (Object)config.getReadCommunity());
        Assert.assertEquals(null, (Object)config.getWriteCommunity());
    }
}

