/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.rest;

import java.io.Reader;
import java.io.StringReader;
import java.util.Comparator;
import java.util.HashMap;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletContext;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Unmarshaller;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.opennms.core.test.MockLogAppender;
import org.opennms.core.test.OpenNMSJUnit4ClassRunner;
import org.opennms.core.test.db.annotations.JUnitTemporaryDatabase;
import org.opennms.core.test.rest.AbstractSpringJerseyRestTestCase;
import org.opennms.core.test.xml.XmlTest;
import org.opennms.core.xml.JaxbUtils;
import org.opennms.netmgt.model.OnmsCategory;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.model.OnmsNodeList;
import org.opennms.test.JUnitConfigurationEnvironment;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.web.WebAppConfiguration;

@RunWith(value=OpenNMSJUnit4ClassRunner.class)
@WebAppConfiguration
@ContextConfiguration(locations={"classpath:/org/opennms/web/rest/applicationContext-test.xml", "classpath:/META-INF/opennms/applicationContext-commonConfigs.xml", "classpath:/META-INF/opennms/applicationContext-soa.xml", "classpath:/META-INF/opennms/applicationContext-dao.xml", "classpath*:/META-INF/opennms/component-service.xml", "classpath*:/META-INF/opennms/component-dao.xml", "classpath:/META-INF/opennms/applicationContext-reportingCore.xml", "classpath:/META-INF/opennms/applicationContext-databasePopulator.xml", "classpath:/org/opennms/web/svclayer/applicationContext-svclayer.xml", "classpath:/META-INF/opennms/applicationContext-mockEventProxy.xml", "classpath:/applicationContext-jersey-test.xml", "classpath:/META-INF/opennms/applicationContext-reporting.xml", "classpath:/META-INF/opennms/applicationContext-mock-usergroup.xml", "classpath:/META-INF/opennms/applicationContext-minimal-conf.xml", "file:src/main/webapp/WEB-INF/applicationContext-spring-security.xml", "file:src/main/webapp/WEB-INF/applicationContext-jersey.xml"})
@JUnitConfigurationEnvironment
@JUnitTemporaryDatabase
public class NodeRestServiceTest
extends AbstractSpringJerseyRestTestCase {
    private static final Logger LOG = LoggerFactory.getLogger(NodeRestServiceTest.class);
    private static int m_nodeCounter = 0;

    protected void afterServletStart() throws Exception {
        MockLogAppender.setupLogging((boolean)true, (String)"DEBUG");
        m_nodeCounter = 0;
    }

    @Test
    @JUnitTemporaryDatabase
    public void testNode() throws Exception {
        this.createNode();
        String url = "/nodes";
        String xml = this.sendRequest(GET, url, 200);
        Assert.assertTrue((boolean)xml.contains("Darwin TestMachine 9.4.0 Darwin Kernel Version 9.4.0"));
        OnmsNodeList list = (OnmsNodeList)JaxbUtils.unmarshal(OnmsNodeList.class, (String)xml);
        Assert.assertEquals((long)1L, (long)list.getNodes().size());
        Assert.assertEquals((String)xml, (Object)"TestMachine0", (Object)((OnmsNode)list.getNodes().get(0)).getLabel());
        xml = this.sendRequest(GET, url, NodeRestServiceTest.parseParamData((String)"orderBy=sysObjectId"), 200);
        list = (OnmsNodeList)JaxbUtils.unmarshal(OnmsNodeList.class, (String)xml);
        Assert.assertEquals((long)1L, (long)list.getNodes().size());
        Assert.assertEquals((Object)"TestMachine0", (Object)((OnmsNode)list.getNodes().get(0)).getLabel());
        for (m_nodeCounter = 1; m_nodeCounter < 5; ++m_nodeCounter) {
            this.createNode();
        }
        xml = this.sendRequest(GET, url, NodeRestServiceTest.parseParamData((String)"limit=3&offset=0&orderBy=label"), 200);
        list = (OnmsNodeList)JaxbUtils.unmarshal(OnmsNodeList.class, (String)xml);
        Assert.assertEquals((long)3L, (long)list.getNodes().size());
        Assert.assertEquals((long)3L, (long)list.getCount());
        Assert.assertEquals((long)5L, (long)list.getTotalCount());
        Assert.assertEquals((Object)"TestMachine0", (Object)((OnmsNode)list.getNodes().get(0)).getLabel());
        Assert.assertEquals((Object)"TestMachine1", (Object)((OnmsNode)list.getNodes().get(1)).getLabel());
        Assert.assertEquals((Object)"TestMachine2", (Object)((OnmsNode)list.getNodes().get(2)).getLabel());
        xml = this.sendRequest(GET, url, NodeRestServiceTest.parseParamData((String)"comparator=like&label=%25Test%25"), 200);
        LOG.info(xml);
        list = (OnmsNodeList)JaxbUtils.unmarshal(OnmsNodeList.class, (String)xml);
        Assert.assertEquals((long)5L, (long)list.getCount());
        Assert.assertEquals((long)5L, (long)list.getTotalCount());
        xml = this.sendRequest(GET, url, NodeRestServiceTest.parseParamData((String)"comparator=like&label=%25DOES_NOT_MATCH%25"), 200);
        LOG.info(xml);
        list = (OnmsNodeList)JaxbUtils.unmarshal(OnmsNodeList.class, (String)xml);
        Assert.assertEquals((long)0L, (long)list.getCount());
        Assert.assertEquals((long)0L, (long)list.getTotalCount());
        url = url + "/1";
        this.sendPut(url, "sysContact=OpenNMS&assetRecord.manufacturer=Apple&assetRecord.operatingSystem=MacOSX Leopard", 303, "/nodes/1");
        xml = this.sendRequest(GET, url, 200);
        Assert.assertTrue((boolean)xml.contains("<sysContact>OpenNMS</sysContact>"));
        Assert.assertTrue((boolean)xml.contains("<operatingSystem>MacOSX Leopard</operatingSystem>"));
        this.sendRequest(DELETE, url, 200);
        this.sendRequest(GET, url, 204);
    }

    @Test
    @JUnitTemporaryDatabase
    public void testPutNode() throws Exception {
        JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{OnmsNodeList.class});
        Unmarshaller unmarshaller = context.createUnmarshaller();
        this.createNode();
        String url = "/nodes";
        String xml = this.sendRequest(GET, url, 200);
        Assert.assertTrue((boolean)xml.contains("Darwin TestMachine 9.4.0 Darwin Kernel Version 9.4.0"));
        OnmsNodeList list = (OnmsNodeList)unmarshaller.unmarshal((Reader)new StringReader(xml));
        Assert.assertEquals((long)1L, (long)list.getNodes().size());
        Assert.assertEquals((Object)"TestMachine0", (Object)((OnmsNode)list.getNodes().get(0)).getLabel());
        url = url + "/1";
        this.sendPut(url, "sysContact=OpenNMS&assetRecord.manufacturer=Apple&assetRecord.operatingSystem=MacOSX Leopard", 303, "/nodes/1");
        xml = this.sendRequest(GET, url, 200);
        Assert.assertTrue((boolean)xml.contains("<sysContact>OpenNMS</sysContact>"));
        Assert.assertTrue((boolean)xml.contains("<operatingSystem>MacOSX Leopard</operatingSystem>"));
        this.sendRequest(DELETE, url, 200);
        this.sendRequest(GET, url, 204);
    }

    @Test
    @JUnitTemporaryDatabase
    public void testLimits() throws Exception {
        JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{OnmsNodeList.class});
        Unmarshaller unmarshaller = context.createUnmarshaller();
        for (m_nodeCounter = 0; m_nodeCounter < 20; ++m_nodeCounter) {
            this.createNode();
        }
        String url = "/nodes";
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("limit", "10");
        parameters.put("orderBy", "id");
        String xml = this.sendRequest(GET, url, parameters, 200);
        Assert.assertTrue((String)xml, (boolean)xml.contains("Darwin TestMachine 9.4.0 Darwin Kernel Version 9.4.0"));
        Pattern p = Pattern.compile("<node [^>]*\\s*id=", 42);
        Matcher m = p.matcher(xml);
        int count = 0;
        while (m.find()) {
            ++count;
        }
        Assert.assertEquals((String)"should get 10 nodes back", (long)10L, (long)count);
        OnmsNodeList list = (OnmsNodeList)unmarshaller.unmarshal((Reader)new StringReader(xml));
        Assert.assertEquals((long)10L, (long)list.getCount());
        Assert.assertEquals((long)10L, (long)list.getNodes().size());
        Assert.assertEquals((long)20L, (long)list.getTotalCount());
        int i = 0;
        TreeSet<OnmsNode> sortedNodes = new TreeSet<OnmsNode>(new Comparator<OnmsNode>(){

            @Override
            public int compare(OnmsNode o1, OnmsNode o2) {
                if (o1 == null && o2 == null) {
                    return 0;
                }
                if (o1 == null) {
                    return 1;
                }
                if (o2 == null) {
                    return -1;
                }
                if (o1.getId() == null) {
                    throw new IllegalStateException("Null ID on node: " + o1.toString());
                }
                return o1.getId().compareTo(o2.getId());
            }
        });
        sortedNodes.addAll(list.getNodes());
        for (OnmsNode node : sortedNodes) {
            Assert.assertEquals((String)node.toString(), (Object)("TestMachine" + i++), (Object)node.getLabel());
        }
    }

    @Test
    @JUnitTemporaryDatabase
    public void testIpInterface() throws Exception {
        this.createIpInterface();
        String url = "/nodes/1/ipinterfaces";
        String xml = this.sendRequest(GET, url, 200);
        Assert.assertTrue((boolean)xml.contains("<ipAddress>10.10.10.10</ipAddress>"));
        url = url + "/10.10.10.10";
        this.sendPut(url, "isManaged=U", 303, "/nodes/1/ipinterfaces/10.10.10.10");
        xml = this.sendRequest(GET, url, 200);
        Assert.assertTrue((boolean)xml.contains("isManaged=\"U\""));
        this.sendRequest(DELETE, url, 200);
        this.sendRequest(GET, url, 204);
    }

    @Test
    @JUnitTemporaryDatabase
    public void testIpInterfaceLimit() throws Exception {
        this.createTwoIpInterface();
        String url = "/nodes/1/ipinterfaces";
        String xml = this.sendRequest(GET, url, NodeRestServiceTest.parseParamData((String)"limit=1"), 200);
        Assert.assertTrue((boolean)xml.contains("count=\"1\""));
        url = url + "/10.10.10.10";
        this.sendPut(url, "isManaged=U", 303, "/nodes/1/ipinterfaces/10.10.10.10");
        xml = this.sendRequest(GET, url, 200);
        Assert.assertTrue((boolean)xml.contains("isManaged=\"U\""));
        this.sendRequest(DELETE, url, 200);
        this.sendRequest(GET, url, 204);
    }

    @Test
    @JUnitTemporaryDatabase
    public void testIpInterfaceByIpAddress() throws Exception {
        this.createTwoIpInterface();
        String url = "/nodes/1/ipinterfaces";
        String xml = this.sendRequest(GET, url, NodeRestServiceTest.parseParamData((String)"ipAddress=11&comparator=contains"), 200);
        Assert.assertTrue((boolean)xml.contains("count=\"1\""));
    }

    @Test
    @JUnitTemporaryDatabase
    public void testIpInterfaceIpLikeFilter() throws Exception {
        this.createTwoIpInterface();
        String url = "/nodes/1/ipinterfaces";
        String xml = this.sendRequest(GET, url, NodeRestServiceTest.parseParamData((String)"ipAddress=*.*.*.11&comparator=iplike"), 200);
        Assert.assertTrue((boolean)xml.contains("count=\"1\""));
    }

    @Test
    @JUnitTemporaryDatabase
    public void testSnmpInterface() throws Exception {
        this.createSnmpInterface();
        String url = "/nodes/1/snmpinterfaces";
        String xml = this.sendRequest(GET, url, 200);
        Assert.assertTrue((boolean)xml.contains("ifIndex=\"6\""));
        url = url + "/6";
        this.sendPut(url, "ifName=eth0", 303, "/nodes/1/snmpinterfaces/6");
        xml = this.sendRequest(GET, url, 200);
        Assert.assertTrue((boolean)xml.contains("<ifName>eth0</ifName>"));
        this.sendRequest(DELETE, url, 200);
        this.sendRequest(GET, url, 204);
    }

    @Test
    @JUnitTemporaryDatabase
    public void testMonitoredService() throws Exception {
        this.createService();
        String url = "/nodes/1/ipinterfaces/10.10.10.10/services";
        String xml = this.sendRequest(GET, url, 200);
        Assert.assertTrue((boolean)xml.contains("<name>ICMP</name>"));
        url = url + "/ICMP";
        this.sendPut(url, "status=A", 303, "/nodes/1/ipinterfaces/10.10.10.10/services/ICMP");
        xml = this.sendRequest(GET, url, 200);
        Assert.assertTrue((boolean)xml.contains("status=\"A\""));
        this.sendRequest(DELETE, url, 200);
        this.sendRequest(GET, url, 204);
    }

    @Test
    @JUnitTemporaryDatabase
    public void testCategory() throws Exception {
        this.createNode();
        this.sendRequest(PUT, "/nodes/1/categories/Routers", 303);
        String xml = this.sendRequest(GET, "/nodes/1/categories", 200);
        Assert.assertTrue((boolean)xml.contains("name=\"Routers\""));
        this.sendRequest(PUT, "/nodes/1/categories/Routers", 400);
        this.sendPut("/categories/Routers", "description=My Equipment", 303, "/categories/Routers");
        xml = this.sendRequest(GET, "/nodes/1/categories/Routers", 200);
        Assert.assertTrue((boolean)xml.contains("<description>My Equipment</description>"));
        this.sendRequest(DELETE, "/nodes/1/categories/Routers", 200);
        this.sendRequest(GET, "/nodes/1/categories/Routers", 204);
        xml = this.sendRequest(GET, "/categories/Routers", 200);
        Assert.assertNotNull((Object)xml);
        Assert.assertTrue((boolean)xml.contains("<description>My Equipment</description>"));
        Assert.assertTrue((boolean)xml.contains("name=\"Routers\""));
        this.sendPost("/nodes/1/categories/", JaxbUtils.marshal((Object)new OnmsCategory("Routers")), 303, "/nodes/1/categories/Routers");
        this.sendRequest(DELETE, "/nodes/1/categories/Routers", 200);
    }

    @Test
    @JUnitTemporaryDatabase
    public void testNodeComboQuery() throws Exception {
        String url = "/nodes";
        MockHttpServletRequest request = NodeRestServiceTest.createRequest((ServletContext)this.getServletContext(), (String)GET, (String)url);
        request.addParameter("_dc", "1235761409572");
        request.addParameter("start", "0");
        request.addParameter("limit", "10");
        request.addParameter("query", "hell");
        this.sendRequest(request, 200);
    }

    @Test
    @JUnitTemporaryDatabase
    public void testIPhoneNodeSearch() throws Exception {
        this.createIpInterface();
        String url = "/nodes";
        String xml = this.sendRequest(GET, url, NodeRestServiceTest.parseParamData((String)"comparator=ilike&match=any&label=1%25&ipInterface.ipAddress=1%25&ipInterface.ipHostName=1%25"), 200);
        XmlTest.assertXpathMatches((String)xml, (String)"//node[@type='A' and @id='1' and @label='TestMachine0']");
        Assert.assertTrue((String)xml, (boolean)xml.contains("count=\"1\""));
        Assert.assertTrue((String)xml, (boolean)xml.contains("totalCount=\"1\""));
        xml = this.sendRequest(GET, url, NodeRestServiceTest.parseParamData((String)"comparator=ilike&match=any&label=8%25&ipInterface.ipAddress=8%25&ipInterface.ipHostName=8%25"), 200);
        Assert.assertTrue((String)xml, (boolean)xml.contains("count=\"0\""));
        Assert.assertTrue((String)xml, (boolean)xml.contains("totalCount=\"0\""));
    }

    protected void createNode() throws Exception {
        String node = "<node type=\"A\" label=\"TestMachine" + m_nodeCounter + "\">" + "<labelSource>H</labelSource>" + "<sysContact>The Owner</sysContact>" + "<sysDescription>" + "Darwin TestMachine 9.4.0 Darwin Kernel Version 9.4.0: Mon Jun  9 19:30:53 PDT 2008; root:xnu-1228.5.20~1/RELEASE_I386 i386" + "</sysDescription>" + "<sysLocation>DevJam</sysLocation>" + "<sysName>TestMachine" + m_nodeCounter + "</sysName>" + "<sysObjectId>.1.3.6.1.4.1.8072.3.2.255</sysObjectId>" + "</node>";
        this.sendPost("/nodes", node, 303, null);
    }

    protected void createIpInterface() throws Exception {
        this.createNode();
        String ipInterface = "<ipInterface isManaged=\"M\" snmpPrimary=\"P\"><ipAddress>10.10.10.10</ipAddress><hostName>TestMachine" + m_nodeCounter + "</hostName>" + "</ipInterface>";
        this.sendPost("/nodes/1/ipinterfaces", ipInterface, 303, "/nodes/1/ipinterfaces/10.10.10.10");
    }

    protected void createTwoIpInterface() throws Exception {
        this.createNode();
        String ipInterface = "<ipInterface isManaged=\"M\" snmpPrimary=\"P\"><ipAddress>10.10.10.10</ipAddress><hostName>TestMachine" + m_nodeCounter + "</hostName>" + "</ipInterface>";
        this.sendPost("/nodes/1/ipinterfaces", ipInterface, 303, "/nodes/1/ipinterfaces/10.10.10.10");
        String ipInterface2 = "<ipInterface isManaged=\"M\" snmpPrimary=\"P\"><ipAddress>10.10.10.11</ipAddress><hostName>TestMachine" + (m_nodeCounter + 1) + "</hostName>" + "</ipInterface>";
        this.sendPost("/nodes/1/ipinterfaces", ipInterface2, 303, "/nodes/1/ipinterfaces/10.10.10.11");
    }
}

