/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.rest;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.Reader;
import java.util.HashMap;
import org.apache.commons.io.IOUtils;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.opennms.core.test.MockLogAppender;
import org.opennms.core.test.OpenNMSJUnit4ClassRunner;
import org.opennms.core.test.db.annotations.JUnitTemporaryDatabase;
import org.opennms.core.test.rest.AbstractSpringJerseyRestTestCase;
import org.opennms.netmgt.config.KSC_PerformanceReportFactory;
import org.opennms.test.JUnitConfigurationEnvironment;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.web.WebAppConfiguration;

@RunWith(value=OpenNMSJUnit4ClassRunner.class)
@WebAppConfiguration
@ContextConfiguration(locations={"classpath:/org/opennms/web/rest/applicationContext-test.xml", "classpath:/META-INF/opennms/applicationContext-commonConfigs.xml", "classpath:/META-INF/opennms/applicationContext-soa.xml", "classpath:/META-INF/opennms/applicationContext-dao.xml", "classpath*:/META-INF/opennms/component-service.xml", "classpath*:/META-INF/opennms/component-dao.xml", "classpath:/META-INF/opennms/applicationContext-reportingCore.xml", "classpath:/META-INF/opennms/applicationContext-databasePopulator.xml", "classpath:/org/opennms/web/svclayer/applicationContext-svclayer.xml", "classpath:/META-INF/opennms/applicationContext-mockEventProxy.xml", "classpath:/applicationContext-jersey-test.xml", "classpath:/META-INF/opennms/applicationContext-reporting.xml", "classpath:/META-INF/opennms/applicationContext-mock-usergroup.xml", "classpath:/META-INF/opennms/applicationContext-minimal-conf.xml", "file:src/main/webapp/WEB-INF/applicationContext-spring-security.xml", "file:src/main/webapp/WEB-INF/applicationContext-jersey.xml"})
@JUnitConfigurationEnvironment
@JUnitTemporaryDatabase
public class KscRestServiceTest
extends AbstractSpringJerseyRestTestCase {
    private File m_configFile = new File("target/test-classes/ksc-performance-reports.xml");

    protected void beforeServletStart() throws Exception {
        KSC_PerformanceReportFactory.setConfigFile((File)this.m_configFile);
        KSC_PerformanceReportFactory.getInstance().reload();
    }

    protected void afterServletStart() throws Exception {
        MockLogAppender.setupLogging((boolean)true, (String)"DEBUG");
    }

    @Test
    public void testReadOnly() throws Exception {
        String xml = this.sendRequest(GET, "/ksc", 200);
        Assert.assertTrue((String)xml, (boolean)xml.contains("Test 2"));
        xml = this.sendRequest(GET, "/ksc/0", 200);
        Assert.assertTrue((String)xml, (boolean)xml.contains("label=\"Test\""));
        this.sendRequest(GET, "/ksc/3", 404);
    }

    @Test
    public void testAddGraph() throws Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("title", "foo");
        params.put("reportName", "bar");
        params.put("resourceId", "baz");
        this.sendRequest(PUT, "/ksc/0", params, 303, "/ksc/0");
        String xml = KscRestServiceTest.slurp(this.m_configFile);
        Assert.assertTrue((String)xml, (boolean)xml.contains("title=\"foo\""));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String slurp(File file) throws Exception {
        String string;
        FileReader fileReader = null;
        BufferedReader reader = null;
        try {
            fileReader = new FileReader(file);
            reader = new BufferedReader(fileReader);
            StringBuilder sb = new StringBuilder();
            while (reader.ready()) {
                String line = reader.readLine();
                System.err.println(line);
                sb.append(line).append('\n');
            }
            string = sb.toString();
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(reader);
            IOUtils.closeQuietly((Reader)fileReader);
            throw throwable;
        }
        IOUtils.closeQuietly((Reader)reader);
        IOUtils.closeQuietly((Reader)fileReader);
        return string;
    }
}

