/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.rest;

import java.util.Date;
import java.util.TimeZone;
import junit.framework.TestCase;
import org.opennms.web.rest.ISO8601DateEditor;

public class ISO8601DateEditorTest
extends TestCase {
    private ISO8601DateEditor editor;

    protected void setUp() throws Exception {
        super.setUp();
        this.editor = new ISO8601DateEditor();
    }

    public void testIsPaintable() {
        ISO8601DateEditorTest.assertFalse((String)"IsPaintable must be false", (boolean)this.editor.isPaintable());
    }

    public void testSetAsTextLong() {
        ISO8601DateEditorTest.assertNull((Object)this.editor.getValue());
        this.editor.setAsText("1");
        ISO8601DateEditorTest.assertNotNull((Object)this.editor.getValue());
        ISO8601DateEditorTest.assertEquals(this.editor.getValue().getClass(), Date.class);
        Date dateValue = (Date)this.editor.getValue();
        ISO8601DateEditorTest.assertEquals((long)1L, (long)dateValue.getTime());
    }

    public void testSetAsTextFullDateString() {
        ISO8601DateEditorTest.assertNull((Object)this.editor.getValue());
        this.editor.setAsText("1970-01-01T00:00:00.000+00:00");
        ISO8601DateEditorTest.assertNotNull((Object)this.editor.getValue());
        ISO8601DateEditorTest.assertEquals(this.editor.getValue().getClass(), Date.class);
        Date dateValue = (Date)this.editor.getValue();
        ISO8601DateEditorTest.assertEquals((long)0L, (long)dateValue.getTime());
    }

    public void testSetAsTextFullDateString2() {
        ISO8601DateEditorTest.assertNull((Object)this.editor.getValue());
        this.editor.setAsText("1970-01-02T00:00:00.000+00:00");
        ISO8601DateEditorTest.assertNotNull((Object)this.editor.getValue());
        ISO8601DateEditorTest.assertEquals(this.editor.getValue().getClass(), Date.class);
        Date dateValue = (Date)this.editor.getValue();
        ISO8601DateEditorTest.assertEquals((long)86400000L, (long)dateValue.getTime());
    }

    public void testGetAsText1() {
        this.editor.setValue((Object)new Date(1L));
        TimeZone.setDefault(TimeZone.getTimeZone("UTC"));
        String formatted = this.editor.getAsText();
        ISO8601DateEditorTest.assertEquals((String)"1970-01-01T00:00:00.001Z", (String)formatted);
    }
}

