/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.rest;

import java.io.Reader;
import java.io.StringReader;
import javax.xml.bind.JAXB;
import org.apache.commons.lang.StringUtils;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.opennms.core.test.MockLogAppender;
import org.opennms.core.test.OpenNMSJUnit4ClassRunner;
import org.opennms.core.test.db.annotations.JUnitTemporaryDatabase;
import org.opennms.core.test.rest.AbstractSpringJerseyRestTestCase;
import org.opennms.core.xml.JaxbUtils;
import org.opennms.netmgt.model.OnmsCategory;
import org.opennms.netmgt.model.OnmsCategoryCollection;
import org.opennms.netmgt.model.OnmsGroup;
import org.opennms.netmgt.model.OnmsGroupList;
import org.opennms.netmgt.model.OnmsUser;
import org.opennms.netmgt.model.OnmsUserList;
import org.opennms.test.JUnitConfigurationEnvironment;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.web.WebAppConfiguration;

@RunWith(value=OpenNMSJUnit4ClassRunner.class)
@WebAppConfiguration
@ContextConfiguration(locations={"classpath:/org/opennms/web/rest/applicationContext-test.xml", "classpath:/META-INF/opennms/applicationContext-commonConfigs.xml", "classpath:/META-INF/opennms/applicationContext-soa.xml", "classpath:/META-INF/opennms/applicationContext-dao.xml", "classpath*:/META-INF/opennms/component-service.xml", "classpath*:/META-INF/opennms/component-dao.xml", "classpath:/META-INF/opennms/applicationContext-reportingCore.xml", "classpath:/META-INF/opennms/applicationContext-databasePopulator.xml", "classpath:/org/opennms/web/svclayer/applicationContext-svclayer.xml", "classpath:/META-INF/opennms/applicationContext-mockEventProxy.xml", "classpath:/applicationContext-jersey-test.xml", "classpath:/META-INF/opennms/applicationContext-reporting.xml", "classpath:/META-INF/opennms/applicationContext-mock-usergroup.xml", "classpath:/META-INF/opennms/applicationContext-minimal-conf.xml", "file:src/main/webapp/WEB-INF/applicationContext-spring-security.xml", "file:src/main/webapp/WEB-INF/applicationContext-jersey.xml"})
@JUnitConfigurationEnvironment
@JUnitTemporaryDatabase
public class GroupRestServiceTest
extends AbstractSpringJerseyRestTestCase {
    protected void afterServletStart() throws Exception {
        MockLogAppender.setupLogging((boolean)true, (String)"DEBUG");
    }

    @Test
    public void testGroup() throws Exception {
        String xml = this.sendRequest(GET, "/groups", 200);
        Assert.assertTrue((boolean)xml.contains("Admin"));
        OnmsGroupList list = (OnmsGroupList)JaxbUtils.unmarshal(OnmsGroupList.class, (String)xml);
        Assert.assertEquals((long)1L, (long)list.getGroups().size());
        Assert.assertEquals((String)xml, (Object)"Admin", (Object)((OnmsGroup)list.getGroups().get(0)).getName());
        xml = this.sendRequest(GET, "/groups/Admin", 200);
        Assert.assertTrue((boolean)xml.contains(">Admin<"));
        this.sendRequest(GET, "/groups/idontexist", 404);
    }

    @Test
    public void testWriteGroup() throws Exception {
        this.createGroup("test");
        String xml = this.sendRequest(GET, "/groups/test", 200);
        Assert.assertTrue((boolean)xml.contains("<group><name>test</name>"));
        this.sendPut("/groups/test", "comments=MONKEYS", 303, "/groups/test");
        xml = this.sendRequest(GET, "/groups/test", 200);
        Assert.assertTrue((boolean)xml.contains(">MONKEYS<"));
    }

    @Test
    public void testDeleteGroup() throws Exception {
        this.createGroup("deleteMe");
        String xml = this.sendRequest(GET, "/groups", 200);
        Assert.assertTrue((boolean)xml.contains("deleteMe"));
        this.sendRequest(DELETE, "/groups/idontexist", 400);
        this.sendRequest(DELETE, "/groups/deleteMe", 200);
        this.sendRequest(GET, "/groups/deleteMe", 404);
    }

    @Test
    public void testUsers() throws Exception {
        this.createGroup("deleteMe");
        this.sendRequest(PUT, "/groups/deleteMe/users/totallyUniqueUser", 400);
        this.createUser("totallyUniqueUser");
        this.sendRequest(PUT, "/groups/deleteMe/users/totallyUniqueUser", 303);
        String xml = this.sendRequest(GET, "/groups/deleteMe", 200);
        Assert.assertTrue((boolean)xml.contains("totallyUniqueUser"));
        this.sendRequest(PUT, "/groups/deleteMe/users/totallyUniqueUser", 400);
        xml = this.sendRequest(GET, "/groups/deleteMe/users", 200);
        Assert.assertEquals((long)1L, (long)StringUtils.countMatches((String)xml, (String)"totallyUniqueUser"));
        xml = this.sendRequest(GET, "/groups/deleteMe/users", 200);
        Assert.assertNotNull((Object)xml);
        Assert.assertEquals((long)1L, (long)((OnmsUserList)JaxbUtils.unmarshal(OnmsUserList.class, (String)xml)).size());
        xml = this.sendRequest(GET, "/groups/deleteMe/users/totallyUniqueUser", 200);
        Assert.assertNotNull((Object)xml);
        OnmsUser user = (OnmsUser)JaxbUtils.unmarshal(OnmsUser.class, (String)xml);
        Assert.assertNotNull((Object)user);
        Assert.assertEquals((Object)"totallyUniqueUser", (Object)user.getUsername());
        this.sendRequest(DELETE, "/groups/deleteMe/users/totallyBogusUser", 400);
        this.sendRequest(DELETE, "/groups/deleteMe/users/totallyUniqueUser", 200);
        xml = this.sendRequest(GET, "/groups/deleteMe", 200);
        Assert.assertFalse((boolean)xml.contains("totallyUniqueUser"));
        xml = this.sendRequest(GET, "/groups/deleteMe/users", 200);
        Assert.assertNotNull((Object)xml);
        Assert.assertEquals((long)0L, (long)((OnmsUserList)JaxbUtils.unmarshal(OnmsUserList.class, (String)xml)).size());
        this.sendRequest(GET, "/groups/deleteMe/users/totallyUniqueUser", 404);
    }

    @Test
    public void testAddGroup() throws Exception {
        OnmsGroupList groups = (OnmsGroupList)JaxbUtils.unmarshal(OnmsGroupList.class, (String)this.sendRequest(GET, "/groups", 200));
        Assert.assertNotNull((Object)groups);
        Assert.assertTrue((groups.size() > 0 ? 1 : 0) != 0);
        int initialGroupSize = groups.size();
        this.createGroup("My little Test group");
        String xml = this.sendRequest(GET, "/groups", 200);
        groups = (OnmsGroupList)JaxbUtils.unmarshal(OnmsGroupList.class, (String)xml);
        Assert.assertEquals((long)(initialGroupSize + 1), (long)groups.size());
        Assert.assertTrue((boolean)xml.contains(">My little Test group<"));
    }

    @Test
    public void testCategories() throws Exception {
        this.createGroup("testGroup");
        String xml = this.sendRequest(GET, "/groups/testGroup/categories", 200);
        Assert.assertNotNull((Object)xml);
        OnmsCategoryCollection categories = (OnmsCategoryCollection)JAXB.unmarshal((Reader)new StringReader(xml), OnmsCategoryCollection.class);
        Assert.assertNotNull((Object)categories);
        Assert.assertTrue((boolean)categories.isEmpty());
        this.sendRequest(PUT, "/groups/testGroup/categories/testCategory", 400);
        this.createCategory("testCategory");
        this.sendRequest(PUT, "/groups/testGroup/categories/testCategory", 200);
        xml = this.sendRequest(GET, "/groups/testGroup/categories/testCategory", 200);
        Assert.assertNotNull((Object)xml);
        OnmsCategory category = (OnmsCategory)JAXB.unmarshal((Reader)new StringReader(xml), OnmsCategory.class);
        Assert.assertNotNull((Object)category);
        Assert.assertEquals((Object)"testCategory", (Object)category.getName());
        this.sendRequest(PUT, "/groups/testGroup/categories/testCategory", 400);
        this.sendRequest(DELETE, "/groups/testGroup/categories/testCategory", 200);
        this.sendRequest(DELETE, "/groups/testGroup/categories/testCategory", 400);
        xml = this.sendRequest(GET, "/groups/testGroup/categories", 200);
        Assert.assertNotNull((Object)xml);
        categories = (OnmsCategoryCollection)JaxbUtils.unmarshal(OnmsCategoryCollection.class, (String)xml);
        Assert.assertNotNull((Object)categories);
        Assert.assertTrue((boolean)categories.isEmpty());
    }

    protected void createCategory(String categoryName) throws Exception {
        OnmsCategory cat = new OnmsCategory(categoryName);
        this.sendPost("/categories", JaxbUtils.marshal((Object)cat), 303, "/categories/" + categoryName);
    }

    private void createUser(String userName) throws Exception {
        OnmsUser user = new OnmsUser();
        user.setUsername(userName);
        this.sendPost("/users", JaxbUtils.marshal((Object)user), 303, "/users/" + userName);
    }

    protected void createGroup(String groupname) throws Exception {
        String group = "<group><name>" + groupname + "</name>" + "<comments>" + groupname + "</comments>" + "</group>";
        this.sendPost("/groups", group, 303, "/groups/" + groupname);
    }
}

