/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.rest;

import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.opennms.core.test.OpenNMSJUnit4ClassRunner;
import org.opennms.core.test.db.annotations.JUnitTemporaryDatabase;
import org.opennms.core.test.rest.AbstractSpringJerseyRestTestCase;
import org.opennms.test.JUnitConfigurationEnvironment;
import org.springframework.mock.web.MockHttpServletResponse;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.web.WebAppConfiguration;

@RunWith(value=OpenNMSJUnit4ClassRunner.class)
@WebAppConfiguration
@ContextConfiguration(locations={"classpath:/org/opennms/web/rest/applicationContext-test.xml", "classpath:/META-INF/opennms/applicationContext-commonConfigs.xml", "classpath:/META-INF/opennms/applicationContext-soa.xml", "classpath:/META-INF/opennms/applicationContext-dao.xml", "classpath*:/META-INF/opennms/component-service.xml", "classpath*:/META-INF/opennms/component-dao.xml", "classpath:/META-INF/opennms/applicationContext-reportingCore.xml", "classpath:/META-INF/opennms/applicationContext-databasePopulator.xml", "classpath:/org/opennms/web/svclayer/applicationContext-svclayer.xml", "classpath:/META-INF/opennms/applicationContext-mockEventProxy.xml", "classpath:/applicationContext-jersey-test.xml", "classpath:/META-INF/opennms/applicationContext-reporting.xml", "classpath:/META-INF/opennms/applicationContext-mock-usergroup.xml", "classpath:/META-INF/opennms/applicationContext-minimal-conf.xml", "file:src/main/webapp/WEB-INF/applicationContext-spring-security.xml", "file:src/main/webapp/WEB-INF/applicationContext-jersey.xml"})
@JUnitConfigurationEnvironment
@JUnitTemporaryDatabase
public class ForeignSourceRestServiceTest
extends AbstractSpringJerseyRestTestCase {
    @Test
    public void testForeignSources() throws Exception {
        this.createForeignSource();
        String url = "/foreignSources";
        String xml = this.sendRequest(GET, url, 200);
        Assert.assertTrue((boolean)xml.contains("ICMP"));
        url = "/foreignSources/test";
        this.sendPut(url, "scanInterval=1h", 303, "/foreignSources/test");
        xml = this.sendRequest(GET, url, 200);
        Assert.assertTrue((boolean)xml.contains("<scan-interval>1h</scan-interval>"));
        url = "/foreignSources/test";
        this.sendPut(url, "scanInterval=1h", 303, "/foreignSources/test");
        this.sendRequest(DELETE, url, 200);
        xml = this.sendRequest(GET, url, 200);
        Assert.assertTrue((boolean)xml.contains("<scan-interval>1d</scan-interval>"));
        this.sendRequest(DELETE, url, 200);
        xml = this.sendRequest(GET, url, 200);
        Assert.assertTrue((boolean)xml.contains("<scan-interval>1d</scan-interval>"));
    }

    @Test
    public void testDetectors() throws Exception {
        this.createForeignSource();
        String url = "/foreignSources/test/detectors";
        String xml = this.sendRequest(GET, url, 200);
        Assert.assertTrue((boolean)xml.contains("<detectors "));
        Assert.assertTrue((boolean)xml.contains("<detector "));
        Assert.assertTrue((boolean)xml.contains("name=\"ICMP\""));
        url = "/foreignSources/test/detectors/HTTP";
        xml = this.sendRequest(GET, url, 200);
        Assert.assertTrue((boolean)xml.contains("org.opennms.netmgt.provision.detector.simple.HttpDetector"));
        xml = this.sendRequest(DELETE, url, 200);
        xml = this.sendRequest(GET, url, 204);
    }

    @Test
    public void testPolicies() throws Exception {
        this.createForeignSource();
        String url = "/foreignSources/test/policies";
        String xml = this.sendRequest(GET, url, 200);
        Assert.assertTrue((boolean)xml.contains("<policies "));
        Assert.assertTrue((boolean)xml.contains("<policy "));
        Assert.assertTrue((boolean)xml.contains("name=\"lower-case-node\""));
        Assert.assertTrue((boolean)xml.contains("value=\"Lower-Case-Nodes\""));
        url = "/foreignSources/test/policies/all-ipinterfaces";
        xml = this.sendRequest(GET, url, 200);
        Assert.assertTrue((boolean)xml.contains("org.opennms.netmgt.provision.persist.policies.InclusiveInterfacePolicy"));
        xml = this.sendRequest(DELETE, url, 200);
        xml = this.sendRequest(GET, url, 204);
    }

    private void createForeignSource() throws Exception {
        String fs = "<foreign-source xmlns=\"http://xmlns.opennms.org/xsd/config/foreign-source\" name=\"test\"><scan-interval>1d</scan-interval><detectors><detector class=\"org.opennms.netmgt.provision.detector.datagram.DnsDetector\" name=\"DNS\"/><detector class=\"org.opennms.netmgt.provision.detector.simple.HttpDetector\" name=\"HTTP\"/><detector class=\"org.opennms.netmgt.provision.detector.simple.HttpsDetector\" name=\"HTTPS\"/><detector class=\"org.opennms.netmgt.provision.detector.icmp.IcmpDetector\" name=\"ICMP\"/></detectors><policies><policy name=\"lower-case-node\" class=\"org.opennms.netmgt.provision.persist.policies.NodeCategoryPolicy\"><parameter key=\"label\" value=\"~^[a-z]$\" /><parameter key=\"category\" value=\"Lower-Case-Nodes\" /></policy><policy name=\"all-ipinterfaces\" class=\"org.opennms.netmgt.provision.persist.policies.InclusiveInterfacePolicy\" /></policies></foreign-source>";
        MockHttpServletResponse response = this.sendPost("/foreignSources", fs, 303, "/foreignSources/test");
        System.err.println("response = " + this.stringifyResponse(response));
    }
}

