/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.rest;

import javax.servlet.ServletContext;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.opennms.core.test.MockLogAppender;
import org.opennms.core.test.OpenNMSJUnit4ClassRunner;
import org.opennms.core.test.db.annotations.JUnitTemporaryDatabase;
import org.opennms.core.test.rest.AbstractSpringJerseyRestTestCase;
import org.opennms.netmgt.dao.DatabasePopulator;
import org.opennms.test.JUnitConfigurationEnvironment;
import org.springframework.mock.web.MockHttpServletResponse;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.web.WebAppConfiguration;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

@RunWith(value=OpenNMSJUnit4ClassRunner.class)
@WebAppConfiguration
@ContextConfiguration(locations={"classpath:/org/opennms/web/rest/applicationContext-test.xml", "classpath:/META-INF/opennms/applicationContext-commonConfigs.xml", "classpath:/META-INF/opennms/applicationContext-soa.xml", "classpath:/META-INF/opennms/applicationContext-dao.xml", "classpath*:/META-INF/opennms/component-service.xml", "classpath*:/META-INF/opennms/component-dao.xml", "classpath:/META-INF/opennms/applicationContext-reportingCore.xml", "classpath:/META-INF/opennms/applicationContext-databasePopulator.xml", "classpath:/org/opennms/web/svclayer/applicationContext-svclayer.xml", "classpath:/META-INF/opennms/applicationContext-mockEventProxy.xml", "classpath:/applicationContext-jersey-test.xml", "classpath:/META-INF/opennms/applicationContext-reporting.xml", "classpath:/META-INF/opennms/applicationContext-mock-usergroup.xml", "classpath:/META-INF/opennms/applicationContext-minimal-conf.xml", "file:src/main/webapp/WEB-INF/applicationContext-spring-security.xml", "file:src/main/webapp/WEB-INF/applicationContext-jersey.xml"})
@JUnitConfigurationEnvironment
@JUnitTemporaryDatabase
@Transactional
public class DataLinkInterfaceRestServiceTest
extends AbstractSpringJerseyRestTestCase {
    private DatabasePopulator m_databasePopulator;

    protected void afterServletStart() {
        MockLogAppender.setupLogging((boolean)true, (String)"DEBUG");
        WebApplicationContext context = WebApplicationContextUtils.getWebApplicationContext((ServletContext)this.getServletContext());
        this.m_databasePopulator = (DatabasePopulator)context.getBean("databasePopulator", DatabasePopulator.class);
        this.m_databasePopulator.populateDatabase();
    }

    @Test
    @JUnitTemporaryDatabase
    public void testLinks() throws Exception {
        String xml = this.sendRequest(GET, "/links", 200);
        Assert.assertTrue((boolean)xml.contains("<links count=\"3\""));
    }

    @Test
    @JUnitTemporaryDatabase
    public void testLink() throws Exception {
        String xml = this.sendRequest(GET, "/links/64", 200);
        Assert.assertTrue((boolean)xml.contains("<link "));
        Assert.assertTrue((boolean)xml.contains("id=\"64\""));
        Assert.assertTrue((boolean)xml.contains("source=\"linkd\""));
        xml = this.sendRequest(GET, "/links/65", 200);
        Assert.assertTrue((boolean)xml.contains("<link "));
        Assert.assertTrue((boolean)xml.contains("id=\"65\""));
        Assert.assertTrue((boolean)xml.contains("source=\"linkd\""));
        xml = this.sendRequest(GET, "/links/66", 200);
        Assert.assertTrue((boolean)xml.contains("<link "));
        Assert.assertTrue((boolean)xml.contains("id=\"66\""));
        Assert.assertTrue((boolean)xml.contains("source=\"linkd\""));
    }

    @Test
    @JUnitTemporaryDatabase
    public void testQueryWithNodeid() throws Exception {
        String xml = this.sendRequest(GET, "/links", DataLinkInterfaceRestServiceTest.parseParamData((String)"node.id=2"), 200);
        Assert.assertTrue((boolean)xml.contains("<links count=\"1\""));
    }

    @Test
    @JUnitTemporaryDatabase
    public void testQueryWithIfIndex() throws Exception {
        String xml = this.sendRequest(GET, "/links", DataLinkInterfaceRestServiceTest.parseParamData((String)"ifIndex=1"), 200);
        Assert.assertTrue((boolean)xml.contains("<links count=\"2\""));
    }

    @Test
    @JUnitTemporaryDatabase
    public void testQueryWithParentNodeid() throws Exception {
        String xml = this.sendRequest(GET, "/links", DataLinkInterfaceRestServiceTest.parseParamData((String)"nodeParentId=2"), 200);
        Assert.assertTrue((boolean)xml.contains("<links count=\"0\""));
    }

    @Test
    @JUnitTemporaryDatabase
    public void testQueryWithParentIfindex() throws Exception {
        String xml = this.sendRequest(GET, "/links", DataLinkInterfaceRestServiceTest.parseParamData((String)"parentIfIndex=1"), 200);
        Assert.assertTrue((boolean)xml.contains("<links count=\"3\""));
    }

    @Test
    @JUnitTemporaryDatabase
    public void testQueryWithStatus() throws Exception {
        String xml = this.sendRequest(GET, "/links", DataLinkInterfaceRestServiceTest.parseParamData((String)"status=A"), 200);
        Assert.assertTrue((boolean)xml.contains("<links count=\"3\""));
    }

    @Test
    @JUnitTemporaryDatabase
    public void testPost() throws Exception {
        String xml = "  <link status=\"A\" source=\"monkey\">    <ifIndex>1</ifIndex>    <lastPollTime>2012-10-30T14:27:38.685-04:00</lastPollTime>    <linkTypeId>-1</linkTypeId>    <nodeId>2</nodeId>    <nodeParentId>1</nodeParentId>    <parentIfIndex>1</parentIfIndex>  </link>";
        MockHttpServletResponse response = this.sendPost("/links", "  <link status=\"A\" source=\"monkey\">    <ifIndex>1</ifIndex>    <lastPollTime>2012-10-30T14:27:38.685-04:00</lastPollTime>    <linkTypeId>-1</linkTypeId>    <nodeId>2</nodeId>    <nodeParentId>1</nodeParentId>    <parentIfIndex>1</parentIfIndex>  </link>", 303, null);
        Assert.assertTrue((boolean)response.getHeader("Location").toString().contains(contextPath + "links/"));
        String newXml = this.sendRequest(GET, "/links", 200);
        Assert.assertTrue((boolean)newXml.contains("<links count=\"4\""));
    }

    @Test
    @JUnitTemporaryDatabase
    public void testPut() throws Exception {
        String xml = this.sendRequest(GET, "/links/64", 200);
        Assert.assertNotNull((Object)xml);
        Assert.assertTrue((boolean)xml.contains("<link "));
        Assert.assertTrue((boolean)xml.contains("source=\"linkd\""));
        this.sendPut("/links/64", "source=monkey", 303, "/links/64");
        xml = this.sendRequest(GET, "/links/64", 200);
        Assert.assertNotNull((Object)xml);
        Assert.assertTrue((boolean)xml.contains("<link "));
        Assert.assertTrue((boolean)xml.contains("source=\"monkey\""));
    }

    @Test
    @JUnitTemporaryDatabase
    public void testDelete() throws Exception {
        String xml = this.sendRequest(GET, "/links/64", 200);
        Assert.assertNotNull((Object)xml);
        Assert.assertTrue((boolean)xml.contains("<link "));
        this.sendRequest(DELETE, "/links/64", 200);
        xml = this.sendRequest(GET, "/links/64", 204);
    }
}

