/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.rest;

import java.io.Reader;
import java.io.StringReader;
import javax.xml.bind.JAXB;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.opennms.core.test.MockLogAppender;
import org.opennms.core.test.OpenNMSJUnit4ClassRunner;
import org.opennms.core.test.db.annotations.JUnitTemporaryDatabase;
import org.opennms.core.test.rest.AbstractSpringJerseyRestTestCase;
import org.opennms.core.xml.JaxbUtils;
import org.opennms.netmgt.model.OnmsCategory;
import org.opennms.netmgt.model.OnmsCategoryCollection;
import org.opennms.test.JUnitConfigurationEnvironment;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.web.WebAppConfiguration;

@RunWith(value=OpenNMSJUnit4ClassRunner.class)
@WebAppConfiguration
@ContextConfiguration(locations={"classpath:/org/opennms/web/rest/applicationContext-test.xml", "classpath:/META-INF/opennms/applicationContext-commonConfigs.xml", "classpath:/META-INF/opennms/applicationContext-soa.xml", "classpath:/META-INF/opennms/applicationContext-dao.xml", "classpath*:/META-INF/opennms/component-service.xml", "classpath*:/META-INF/opennms/component-dao.xml", "classpath:/META-INF/opennms/applicationContext-reportingCore.xml", "classpath:/META-INF/opennms/applicationContext-databasePopulator.xml", "classpath:/org/opennms/web/svclayer/applicationContext-svclayer.xml", "classpath:/META-INF/opennms/applicationContext-mockEventProxy.xml", "classpath:/applicationContext-jersey-test.xml", "classpath:/META-INF/opennms/applicationContext-reporting.xml", "classpath:/META-INF/opennms/applicationContext-mock-usergroup.xml", "classpath:/META-INF/opennms/applicationContext-minimal-conf.xml", "file:src/main/webapp/WEB-INF/applicationContext-spring-security.xml", "file:src/main/webapp/WEB-INF/applicationContext-jersey.xml"})
@JUnitConfigurationEnvironment
@JUnitTemporaryDatabase
public class CategoryRestServiceTest
extends AbstractSpringJerseyRestTestCase {
    protected void afterServletStart() throws Exception {
        MockLogAppender.setupLogging((boolean)true, (String)"DEBUG");
    }

    @Test
    public void testCategories() throws Exception {
        String xml = this.sendRequest("GET", "/categories", 200);
        junit.framework.Assert.assertNotNull((Object)xml);
        OnmsCategoryCollection categories = (OnmsCategoryCollection)JAXB.unmarshal((Reader)new StringReader(xml), OnmsCategoryCollection.class);
        int initialSize = categories.size();
        junit.framework.Assert.assertNotNull((Object)categories);
        junit.framework.Assert.assertEquals((int)initialSize, (int)categories.size());
        this.createCategory("testCategory");
        xml = this.sendRequest("GET", "/categories", 200);
        categories = (OnmsCategoryCollection)JAXB.unmarshal((Reader)new StringReader(xml), OnmsCategoryCollection.class);
        junit.framework.Assert.assertEquals((int)(initialSize + 1), (int)categories.size());
        Assert.assertTrue((boolean)xml.contains("name=\"testCategory\""));
        this.sendData("POST", "application/xml", "/categories", JaxbUtils.marshal((Object)new OnmsCategory("testCategory")), 400);
        xml = this.sendRequest("GET", "/categories", 200);
        categories = (OnmsCategoryCollection)JAXB.unmarshal((Reader)new StringReader(xml), OnmsCategoryCollection.class);
        junit.framework.Assert.assertEquals((int)(initialSize + 1), (int)categories.size());
        Assert.assertTrue((boolean)xml.contains("name=\"testCategory\""));
        this.sendRequest("DELETE", "/categories/testCategory", 303);
        xml = this.sendRequest("GET", "/categories", 200);
        categories = (OnmsCategoryCollection)JAXB.unmarshal((Reader)new StringReader(xml), OnmsCategoryCollection.class);
        junit.framework.Assert.assertEquals((int)initialSize, (int)categories.size());
        Assert.assertFalse((boolean)xml.contains("name=\"testCategory\""));
    }

    @Test
    public void testAddCategory() throws Exception {
        OnmsCategory createMe = new OnmsCategory();
        createMe.setDescription("This is a description");
        createMe.setName("myName");
        this.createCategory(createMe);
        String xml = this.sendRequest("GET", "/categories/myName", 200);
        OnmsCategory category = (OnmsCategory)JAXB.unmarshal((Reader)new StringReader(xml), OnmsCategory.class);
        junit.framework.Assert.assertNotNull((Object)category.getId());
        createMe.setId(category.getId());
        Assert.assertTrue((boolean)category.getId().equals(createMe.getId()));
        junit.framework.Assert.assertEquals((Object)createMe, (Object)category);
    }

    @Test
    @JUnitTemporaryDatabase
    public void testUpdateCategory() throws Exception {
        OnmsCategory createMe = new OnmsCategory();
        createMe.setDescription("This is a description");
        createMe.setName("myName");
        this.createCategory(createMe);
        String url = "/categories";
        String xml = this.sendRequest(GET, url, 200);
        Assert.assertTrue((boolean)xml.contains("<description>This is a description</description>"));
        Assert.assertTrue((boolean)xml.contains("name=\"myName\""));
        url = url + "/myName";
        this.sendPut(url, "description=My Equipment&name=NewCategory", 303, url);
        xml = this.sendRequest(GET, url, 200);
        Assert.assertTrue((boolean)xml.contains("<description>My Equipment</description>"));
        Assert.assertTrue((boolean)xml.contains("name=\"NewCategory\""));
        xml = this.sendRequest(DELETE, url, 303);
        Assert.assertFalse((boolean)xml.contains("<description>My Equipment</description>"));
        Assert.assertFalse((boolean)xml.contains("name=\"NewCategory\""));
        Assert.assertFalse((boolean)xml.contains("name=\"myName\""));
        Assert.assertFalse((boolean)xml.contains("<description>This is a description</description>"));
        this.sendRequest(GET, url, 200);
    }

    @Test
    public void testNodeCategories() throws Exception {
        this.createNode();
        this.sendRequest(GET, "/categories/nodes/1", 200);
        this.sendRequest(PUT, "/categories/Routers/nodes/1", 303);
        this.sendRequest(DELETE, "/nodes/1/categories/Routers", 200);
    }

    @Test
    public void testGroupCategories() throws Exception {
        this.sendRequest(GET, "/categories/groups/Admin", 200);
        this.sendRequest(PUT, "/categories/Routers/groups/Admin", 200);
        this.sendRequest(DELETE, "/categories/Routers/groups/Admin", 200);
    }

    protected void createCategory(OnmsCategory category) throws Exception {
        this.sendPost("/categories", JaxbUtils.marshal((Object)category), 303, "/categories/" + category.getName());
    }

    protected void createCategory(String categoryName) throws Exception {
        OnmsCategory cat = new OnmsCategory();
        cat.setName(categoryName);
        this.createCategory(cat);
    }
}

