/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.rest;

import java.io.Serializable;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.TreeSet;
import javax.servlet.ServletContext;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.opennms.core.test.MockLogAppender;
import org.opennms.core.test.OpenNMSJUnit4ClassRunner;
import org.opennms.core.test.db.annotations.JUnitTemporaryDatabase;
import org.opennms.core.test.rest.AbstractSpringJerseyRestTestCase;
import org.opennms.core.test.xml.XmlTest;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.dao.DatabasePopulator;
import org.opennms.netmgt.dao.api.AlarmDao;
import org.opennms.netmgt.dao.api.DistPollerDao;
import org.opennms.netmgt.dao.api.EventDao;
import org.opennms.netmgt.model.OnmsAlarm;
import org.opennms.netmgt.model.OnmsDistPoller;
import org.opennms.netmgt.model.OnmsEvent;
import org.opennms.netmgt.model.OnmsSeverity;
import org.opennms.test.JUnitConfigurationEnvironment;
import org.opennms.web.rest.MockUserPrincipal;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.web.WebAppConfiguration;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionCallbackWithoutResult;
import org.springframework.transaction.support.TransactionTemplate;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

@RunWith(value=OpenNMSJUnit4ClassRunner.class)
@WebAppConfiguration
@ContextConfiguration(locations={"classpath:/org/opennms/web/rest/applicationContext-test.xml", "classpath:/META-INF/opennms/applicationContext-commonConfigs.xml", "classpath:/META-INF/opennms/applicationContext-soa.xml", "classpath:/META-INF/opennms/applicationContext-dao.xml", "classpath*:/META-INF/opennms/component-service.xml", "classpath*:/META-INF/opennms/component-dao.xml", "classpath:/META-INF/opennms/applicationContext-reportingCore.xml", "classpath:/META-INF/opennms/applicationContext-databasePopulator.xml", "classpath:/org/opennms/web/svclayer/applicationContext-svclayer.xml", "classpath:/META-INF/opennms/applicationContext-mockEventProxy.xml", "classpath:/applicationContext-jersey-test.xml", "classpath:/META-INF/opennms/applicationContext-reporting.xml", "classpath:/META-INF/opennms/applicationContext-mock-usergroup.xml", "classpath:/META-INF/opennms/applicationContext-minimal-conf.xml", "file:src/main/webapp/WEB-INF/applicationContext-spring-security.xml", "file:src/main/webapp/WEB-INF/applicationContext-jersey.xml"})
@JUnitConfigurationEnvironment
@JUnitTemporaryDatabase
public class AlarmRestServiceTest
extends AbstractSpringJerseyRestTestCase {
    @Autowired
    TransactionTemplate m_template;
    private DatabasePopulator m_databasePopulator;

    protected void afterServletStart() {
        MockLogAppender.setupLogging((boolean)true, (String)"DEBUG");
        WebApplicationContext context = WebApplicationContextUtils.getWebApplicationContext((ServletContext)this.getServletContext());
        this.m_databasePopulator = (DatabasePopulator)context.getBean("databasePopulator", DatabasePopulator.class);
        this.m_template.execute((TransactionCallback)new TransactionCallbackWithoutResult(){

            protected void doInTransactionWithoutResult(TransactionStatus status) {
                AlarmRestServiceTest.this.m_databasePopulator.populateDatabase();
            }
        });
    }

    @Test
    @JUnitTemporaryDatabase
    public void testAlarms() throws Exception {
        String xml = this.sendRequest(GET, "/alarms", AlarmRestServiceTest.parseParamData((String)"orderBy=lastEventTime&order=desc&alarmAckUser=null&limit=1"), 200);
        Assert.assertTrue((boolean)xml.contains("This is a test alarm"));
        xml = this.sendRequest(GET, "/alarms/1", AlarmRestServiceTest.parseParamData((String)"orderBy=lastEventTime&order=desc&alarmAckUser=null&limit=1"), 200);
        Assert.assertTrue((boolean)xml.contains("This is a test alarm"));
        Assert.assertTrue((boolean)xml.contains("<nodeLabel>node1</nodeLabel>"));
    }

    @Test
    @JUnitTemporaryDatabase
    public void testAlarmQueryByNode() throws Exception {
        String xml = this.sendRequest(GET, "/alarms", AlarmRestServiceTest.parseParamData((String)"nodeId=6&limit=1"), 200);
        Assert.assertTrue((boolean)xml.contains("<alarms"));
        xml = this.sendRequest(GET, "/alarms", AlarmRestServiceTest.parseParamData((String)"node.id=6&limit=1"), 200);
        Assert.assertTrue((boolean)xml.contains("<alarms"));
        xml = this.sendRequest(GET, "/alarms", AlarmRestServiceTest.parseParamData((String)"node.label=node1&limit=1"), 200);
        Assert.assertTrue((boolean)xml.contains("node1"));
        xml = this.sendRequest(GET, "/alarms", AlarmRestServiceTest.parseParamData((String)"ipInterface.ipAddress=192.168.1.2&limit=1"), 200);
        Assert.assertTrue((boolean)xml.contains("node1"));
    }

    @Test
    @JUnitTemporaryDatabase
    public void testAlarmQueryBySeverityEquals() throws Exception {
        String xml = null;
        xml = this.sendRequest(GET, "/alarms", AlarmRestServiceTest.parseParamData((String)"comparator=eq&severity=NORMAL&limit=1"), 200);
        Assert.assertTrue((boolean)xml.contains("This is a test alarm"));
        xml = this.sendRequest(GET, "/alarms", AlarmRestServiceTest.parseParamData((String)"comparator=eq&severity=MAJOR&limit=1"), 200);
        Assert.assertFalse((boolean)xml.contains("This is a test alarm"));
    }

    @Test
    @JUnitTemporaryDatabase
    public void testAlarmQueryBySeverityLessThan() throws Exception {
        String xml = null;
        xml = this.sendRequest(GET, "/alarms", AlarmRestServiceTest.parseParamData((String)"comparator=le&severity=NORMAL&limit=1"), 200);
        Assert.assertTrue((boolean)xml.contains("This is a test alarm"));
        xml = this.sendRequest(GET, "/alarms", AlarmRestServiceTest.parseParamData((String)"comparator=lt&severity=NORMAL&limit=1"), 200);
        Assert.assertFalse((boolean)xml.contains("This is a test alarm"));
        xml = this.sendRequest(GET, "/alarms", AlarmRestServiceTest.parseParamData((String)"comparator=lt&severity=WARNING&limit=1"), 200);
        Assert.assertTrue((boolean)xml.contains("This is a test alarm"));
    }

    @Test
    @JUnitTemporaryDatabase
    public void testAlarmQueryBySeverityGreaterThan() throws Exception {
        String xml = null;
        xml = this.sendRequest(GET, "/alarms", AlarmRestServiceTest.parseParamData((String)"comparator=ge&severity=NORMAL&limit=1"), 200);
        Assert.assertTrue((boolean)xml.contains("This is a test alarm"));
        xml = this.sendRequest(GET, "/alarms", AlarmRestServiceTest.parseParamData((String)"comparator=gt&severity=NORMAL&limit=1"), 200);
        Assert.assertFalse((boolean)xml.contains("This is a test alarm"));
        xml = this.sendRequest(GET, "/alarms", AlarmRestServiceTest.parseParamData((String)"comparator=gt&severity=CLEARED&limit=1"), 200);
        Assert.assertTrue((boolean)xml.contains("This is a test alarm"));
    }

    @Test
    @Transactional
    @JUnitTemporaryDatabase
    public void testAlarmUpdates() throws Exception {
        this.createAlarm(OnmsSeverity.MAJOR);
        OnmsAlarm alarm = this.getLastAlarm();
        alarm.setAlarmAckTime(null);
        alarm.setAlarmAckUser(null);
        this.getAlarmDao().saveOrUpdate((Object)alarm);
        Integer alarmId = alarm.getId();
        this.sendPut("/alarms", "ack=true&alarmId=" + alarmId, 303, "/alarms/" + alarmId);
        String xml = this.sendRequest(GET, "/alarms/" + alarmId, 200);
        Assert.assertTrue((boolean)xml.contains("ackUser>admin<"));
        this.sendPut("/alarms/" + alarmId, "clear=true", 303, "/alarms/" + alarmId);
        xml = this.sendRequest(GET, "/alarms/" + alarmId, 200);
        Assert.assertTrue((boolean)xml.contains("severity=\"CLEARED\""));
        this.sendPut("/alarms/" + alarmId, "escalate=true", 303, "/alarms/" + alarmId);
        xml = this.sendRequest(GET, "/alarms/" + alarmId, 200);
        Assert.assertTrue((boolean)xml.contains("severity=\"NORMAL\""));
        alarm = this.getLastAlarm();
        alarm.setSeverity(OnmsSeverity.MAJOR);
        alarm.setAlarmAckTime(null);
        alarm.setAlarmAckUser(null);
        this.getAlarmDao().saveOrUpdate((Object)alarm);
        MockUserPrincipal.setName("foo");
        IllegalArgumentException failure = null;
        try {
            this.sendPut("/alarms/" + alarmId, "ack=true&ackUser=bar", 303, "/alarms/" + alarmId);
        }
        catch (IllegalArgumentException e) {
            failure = e;
        }
        Assert.assertNotNull((Object)failure);
    }

    private OnmsAlarm getLastAlarm() {
        TreeSet<OnmsAlarm> alarms = new TreeSet<OnmsAlarm>(new Comparator<OnmsAlarm>(){

            @Override
            public int compare(OnmsAlarm a, OnmsAlarm b) {
                return a.getId().compareTo(b.getId());
            }
        });
        alarms.addAll(this.getAlarmDao().findAll());
        return (OnmsAlarm)alarms.last();
    }

    @Test
    @JUnitTemporaryDatabase
    @Transactional
    public void testComplexQuery() throws Exception {
        String xml = null;
        HashMap<String, String> parameters = new HashMap<String, String>();
        this.createAlarm(OnmsSeverity.CRITICAL);
        for (OnmsAlarm alarm : this.getAlarmDao().findAll()) {
            System.err.println("alarm = " + alarm);
        }
        parameters.put("offset", "00");
        parameters.put("limit", "10");
        parameters.put("orderBy", "lastEventTime");
        parameters.put("order", "desc");
        parameters.put("query", "lastEventTime > '2011-08-19T11:11:11.000-07:00' AND severity = 3");
        xml = this.sendRequest(GET, "/alarms", parameters, 200);
        XmlTest.assertXpathMatches((String)xml, (String)"//alarm[@severity='NORMAL' and @id='1']");
        XmlTest.assertXpathDoesNotMatch((String)xml, (String)"//alarm[@severity='CRITICAL' and @id='2']");
        parameters.put("query", "lastEventTime > '2011-08-19T11:11:11.000-07:00' AND severity >= 3");
        xml = this.sendRequest(GET, "/alarms", parameters, 200);
        XmlTest.assertXpathMatches((String)xml, (String)"//alarm[@severity='NORMAL' and @id='1']");
        XmlTest.assertXpathMatches((String)xml, (String)"//alarm[@severity='CRITICAL' and @id='2']");
        parameters.put("query", "lastEventTime > '2011-08-19T11:11:11.000-07:00' AND severity >= NORMAL");
        xml = this.sendRequest(GET, "/alarms", parameters, 200);
        XmlTest.assertXpathMatches((String)xml, (String)"//alarm[@severity='NORMAL' and @id='1']");
        XmlTest.assertXpathMatches((String)xml, (String)"//alarm[@severity='CRITICAL' and @id='2']");
        parameters.put("query", "lastEventTime > '2011-08-19T11:11:11.000-07:00' AND severity < NORMAL");
        xml = this.sendRequest(GET, "/alarms", parameters, 200);
        XmlTest.assertXpathDoesNotMatch((String)xml, (String)"//alarm[@severity='NORMAL' and @id='1']");
        XmlTest.assertXpathDoesNotMatch((String)xml, (String)"//alarm[@severity='CRITICAL' and @id='2']");
        XmlTest.assertXpathMatches((String)xml, (String)"//alarms[@count='0']");
        parameters.put("query", "lastEventTime > '2011-08-19T11:11:11.000-07:00' AND severity > MAJOR AND alarmAckUser = 'admin'");
        xml = this.sendRequest(GET, "/alarms", parameters, 200);
        XmlTest.assertXpathDoesNotMatch((String)xml, (String)"//alarm[@severity='NORMAL' and @id='1']");
        XmlTest.assertXpathMatches((String)xml, (String)"//alarm[@severity='CRITICAL' and @id='2']");
        parameters.put("query", "lastEventTime > '2011-08-19T11:11:11.000-07:00' AND severity > MAJOR AND alarmAckUser IS NULL");
        xml = this.sendRequest(GET, "/alarms", parameters, 200);
        XmlTest.assertXpathMatches((String)xml, (String)"//alarms[@count='0']");
        parameters.put("query", "lastEventTime > '2011-08-19T11:11:11.000-07:00' AND severity < MAJOR AND alarmAckUser IS NULL");
        xml = this.sendRequest(GET, "/alarms", parameters, 200);
        XmlTest.assertXpathMatches((String)xml, (String)"//alarm[@severity='NORMAL' and @id='1']");
        XmlTest.assertXpathDoesNotMatch((String)xml, (String)"//alarm[@severity='CRITICAL' and @id='2']");
    }

    private void createAlarm(OnmsSeverity severity) {
        OnmsEvent event = (OnmsEvent)this.getEventDao().findAll().get(0);
        OnmsAlarm alarm = new OnmsAlarm();
        alarm.setDistPoller((OnmsDistPoller)this.getDistPollerDao().load((Serializable)((Object)"localhost")));
        alarm.setUei(event.getEventUei());
        alarm.setAlarmType(Integer.valueOf(1));
        alarm.setNode(this.m_databasePopulator.getNode1());
        alarm.setDescription("This is a test alarm");
        alarm.setLogMsg("this is a test alarm log message");
        alarm.setCounter(Integer.valueOf(1));
        alarm.setIpAddr(InetAddressUtils.getInetAddress((String)"192.168.1.1"));
        alarm.setSeverity(severity);
        alarm.setFirstEventTime(event.getEventTime());
        alarm.setLastEvent(event);
        alarm.setAlarmAckTime(new Date());
        alarm.setAlarmAckUser("admin");
        this.getAlarmDao().save((Object)alarm);
        this.getAlarmDao().flush();
    }

    private EventDao getEventDao() {
        return this.m_databasePopulator.getEventDao();
    }

    private AlarmDao getAlarmDao() {
        return this.m_databasePopulator.getAlarmDao();
    }

    private DistPollerDao getDistPollerDao() {
        return this.m_databasePopulator.getDistPollerDao();
    }
}

