/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.notification;

import java.util.Date;
import java.util.Properties;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.opennms.core.test.MockLogAppender;
import org.opennms.core.test.OpenNMSJUnit4ClassRunner;
import org.opennms.core.test.db.annotations.JUnitTemporaryDatabase;
import org.opennms.core.utils.BeanUtils;
import org.opennms.netmgt.dao.DatabasePopulator;
import org.opennms.test.JUnitConfigurationEnvironment;
import org.opennms.web.filter.Filter;
import org.opennms.web.notification.Notification;
import org.opennms.web.notification.WebNotificationRepository;
import org.opennms.web.notification.filter.AcknowledgedByFilter;
import org.opennms.web.notification.filter.InterfaceFilter;
import org.opennms.web.notification.filter.NodeFilter;
import org.opennms.web.notification.filter.NotificationCriteria;
import org.opennms.web.notification.filter.NotificationIdFilter;
import org.opennms.web.notification.filter.NotificationIdListFilter;
import org.opennms.web.notification.filter.ResponderFilter;
import org.opennms.web.notification.filter.ServiceFilter;
import org.opennms.web.notification.filter.UserFilter;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.transaction.annotation.Transactional;

@RunWith(value=OpenNMSJUnit4ClassRunner.class)
@ContextConfiguration(locations={"classpath:/META-INF/opennms/applicationContext-soa.xml", "classpath:/META-INF/opennms/applicationContext-dao.xml", "classpath*:/META-INF/opennms/component-dao.xml", "classpath*:/META-INF/opennms/component-service.xml", "classpath:/daoWebRepositoryTestContext.xml", "classpath:/jdbcWebRepositoryTestContext.xml", "classpath:/META-INF/opennms/applicationContext-minimal-conf.xml"})
@JUnitConfigurationEnvironment
@JUnitTemporaryDatabase
public class WebNotificationRepositoryFilterTest
implements InitializingBean {
    @Autowired
    DatabasePopulator m_dbPopulator;
    @Autowired
    @Qualifier(value="dao")
    WebNotificationRepository m_daoNotificationRepo;
    @Autowired
    @Qualifier(value="jdbc")
    WebNotificationRepository m_jdbcNotificationRepo;

    public void afterPropertiesSet() throws Exception {
        BeanUtils.assertAutowiring((Object)this);
    }

    @BeforeClass
    public static void setUpLogging() {
        Properties props = new Properties();
        props.setProperty("log4j.logger.org.hibernate", "INFO");
        props.setProperty("log4j.logger.org.springframework", "INFO");
        props.setProperty("log4j.logger.org.hibernate.SQL", "DEBUG");
        MockLogAppender.setupLogging((Properties)props);
    }

    @Before
    public void setUp() {
        this.m_dbPopulator.populateDatabase();
    }

    @Test
    @Transactional
    public void testAcknowledgeByFilter() {
        this.m_daoNotificationRepo.acknowledgeMatchingNotification("TestUser", new Date(), new NotificationCriteria(new Filter[0]));
        AcknowledgedByFilter filter = new AcknowledgedByFilter("TestUser");
        this.assert1Result((Filter)filter);
    }

    @Test
    @Transactional
    public void testInterfaceFilter() {
        InterfaceFilter filter = new InterfaceFilter("192.168.1.1");
        this.assert1Result((Filter)filter);
    }

    @Test
    @JUnitTemporaryDatabase
    public void testNodeFilter() {
        NodeFilter filter = new NodeFilter(1);
        this.assert1Result((Filter)filter);
    }

    @Test
    @JUnitTemporaryDatabase
    public void testNotificationIdFilter() {
        NotificationIdFilter filter = new NotificationIdFilter(1);
        this.assert1Result((Filter)filter);
    }

    @Test
    @JUnitTemporaryDatabase
    public void testNotificationIdListFilter() {
        int[] ids = new int[]{1};
        NotificationIdListFilter filter = new NotificationIdListFilter(ids);
        this.assert1Result((Filter)filter);
    }

    @Test
    @Transactional
    public void testResponderFilter() {
        this.m_daoNotificationRepo.acknowledgeMatchingNotification("TestUser", new Date(), new NotificationCriteria(new Filter[0]));
        ResponderFilter filter = new ResponderFilter("TestUser");
        this.assert1Result((Filter)filter);
    }

    @Test
    @JUnitTemporaryDatabase
    public void testServiceFilter() {
        Notification[] notifs = this.m_daoNotificationRepo.getMatchingNotifications(new NotificationCriteria(new Filter[0]));
        System.out.println(notifs[0].getServiceId());
        ServiceFilter filter = new ServiceFilter(1, null);
        this.assert1Result((Filter)filter);
    }

    @Test
    @Transactional
    public void testUserFilter() {
        UserFilter filter = new UserFilter("TestUser");
        this.assert1Result((Filter)filter);
    }

    private void assert1Result(Filter filter) {
        System.out.println(filter.getSql());
        NotificationCriteria criteria = new NotificationCriteria(new Filter[]{filter});
        Notification[] notifs = this.m_daoNotificationRepo.getMatchingNotifications(criteria);
        Assert.assertEquals((long)1L, (long)notifs.length);
        notifs = this.m_jdbcNotificationRepo.getMatchingNotifications(criteria);
        Assert.assertEquals((long)1L, (long)notifs.length);
    }
}

