/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.event;

import java.util.Date;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.opennms.core.test.OpenNMSJUnit4ClassRunner;
import org.opennms.core.test.db.annotations.JUnitTemporaryDatabase;
import org.opennms.core.utils.BeanUtils;
import org.opennms.netmgt.dao.DatabasePopulator;
import org.opennms.netmgt.model.OnmsSeverity;
import org.opennms.test.JUnitConfigurationEnvironment;
import org.opennms.web.event.AcknowledgeType;
import org.opennms.web.event.Event;
import org.opennms.web.event.SortStyle;
import org.opennms.web.event.WebEventRepository;
import org.opennms.web.event.filter.AcknowledgedByFilter;
import org.opennms.web.event.filter.EventCriteria;
import org.opennms.web.event.filter.EventIdFilter;
import org.opennms.web.event.filter.NegativeSeverityFilter;
import org.opennms.web.event.filter.SeverityFilter;
import org.opennms.web.filter.Filter;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.transaction.annotation.Transactional;

@RunWith(value=OpenNMSJUnit4ClassRunner.class)
@ContextConfiguration(locations={"classpath:/META-INF/opennms/applicationContext-soa.xml", "classpath:/META-INF/opennms/applicationContext-dao.xml", "classpath*:/META-INF/opennms/component-dao.xml", "classpath*:/META-INF/opennms/component-service.xml", "classpath:/jdbcWebRepositoryTestContext.xml", "classpath:/META-INF/opennms/applicationContext-minimal-conf.xml"})
@JUnitConfigurationEnvironment
@JUnitTemporaryDatabase
public class JdbcWebEventRepositoryTest
implements InitializingBean {
    @Autowired
    DatabasePopulator m_dbPopulator;
    @Autowired
    WebEventRepository m_eventRepo;

    public void afterPropertiesSet() throws Exception {
        BeanUtils.assertAutowiring((Object)this);
    }

    @Before
    public void setUp() {
        this.m_dbPopulator.populateDatabase();
    }

    @Test
    @Transactional
    public void testCountMatchingEvents() {
        EventCriteria criteria = new EventCriteria(new Filter[0]);
        int event = this.m_eventRepo.countMatchingEvents(criteria);
        Assert.assertEquals((long)1L, (long)event);
    }

    @Test
    @Transactional
    public void testCountMatchingEventsBySeverity() {
        EventCriteria criteria = new EventCriteria(new Filter[0]);
        int[] matchingEvents = this.m_eventRepo.countMatchingEventsBySeverity(criteria);
        Assert.assertEquals((long)8L, (long)matchingEvents.length);
        Assert.assertEquals((long)0L, (long)matchingEvents[OnmsSeverity.CLEARED.getId()]);
        Assert.assertEquals((long)0L, (long)matchingEvents[OnmsSeverity.CRITICAL.getId()]);
        Assert.assertEquals((long)1L, (long)matchingEvents[OnmsSeverity.INDETERMINATE.getId()]);
        Assert.assertEquals((long)0L, (long)matchingEvents[OnmsSeverity.MAJOR.getId()]);
        Assert.assertEquals((long)0L, (long)matchingEvents[OnmsSeverity.MINOR.getId()]);
        Assert.assertEquals((long)0L, (long)matchingEvents[OnmsSeverity.NORMAL.getId()]);
        Assert.assertEquals((long)0L, (long)matchingEvents[OnmsSeverity.WARNING.getId()]);
    }

    @Test
    @JUnitTemporaryDatabase
    public void testGetEvent() {
        Event event = this.m_eventRepo.getEvent(1);
        Assert.assertNotNull((Object)event);
    }

    @Test
    @JUnitTemporaryDatabase
    public void testAcknowledgeUnacknowledgeMatchingAlarms() {
        this.m_eventRepo.acknowledgeMatchingEvents("TestUser", new Date(), new EventCriteria(new Filter[]{new EventIdFilter(1)}));
        int matchingEventCount = this.m_eventRepo.countMatchingEvents(new EventCriteria(new Filter[]{new AcknowledgedByFilter("TestUser")}));
        Assert.assertEquals((long)1L, (long)matchingEventCount);
        this.m_eventRepo.unacknowledgeMatchingEvents(new EventCriteria(new Filter[]{new AcknowledgedByFilter("TestUser")}));
        matchingEventCount = this.m_eventRepo.countMatchingEvents(new EventCriteria(new Filter[]{new AcknowledgedByFilter("TestUser")}));
        Assert.assertEquals((long)0L, (long)matchingEventCount);
    }

    @Test
    @Transactional
    public void testAcknowledgeUnacknowledgeAllAlarms() {
        this.m_eventRepo.acknowledgeAll("TestUser", new Date());
        int matchingEventCount = this.m_eventRepo.countMatchingEvents(new EventCriteria(new Filter[]{new AcknowledgedByFilter("TestUser")}));
        Assert.assertEquals((long)1L, (long)matchingEventCount);
        this.m_eventRepo.unacknowledgeAll();
        matchingEventCount = this.m_eventRepo.countMatchingEvents(new EventCriteria(new Filter[]{new AcknowledgedByFilter("TestUser")}));
        Assert.assertEquals((long)0L, (long)matchingEventCount);
    }

    @Test
    @Transactional
    public void testCountMatchingBySeverity() {
        int[] matchingEventCount = this.m_eventRepo.countMatchingEventsBySeverity(new EventCriteria(new Filter[]{new SeverityFilter(3)}));
        Assert.assertEquals((long)8L, (long)matchingEventCount.length);
    }

    @Test
    @Transactional
    public void testFilterBySeverity() {
        NegativeSeverityFilter filter = new NegativeSeverityFilter(OnmsSeverity.NORMAL.getId());
        EventCriteria criteria = new EventCriteria(new Filter[]{filter});
        Event[] events = this.m_eventRepo.getMatchingEvents(criteria);
        Assert.assertTrue((events.length > 0 ? 1 : 0) != 0);
        EventCriteria sortedCriteria = new EventCriteria(new Filter[]{filter}, SortStyle.ID, AcknowledgeType.UNACKNOWLEDGED, 100, 0);
        Event[] sortedEvents = this.m_eventRepo.getMatchingEvents(sortedCriteria);
        Assert.assertTrue((sortedEvents.length > 0 ? 1 : 0) != 0);
    }

    @Test
    @JUnitTemporaryDatabase
    public void testDoubleFilterTest() {
        this.m_eventRepo.acknowledgeAll("TestUser", new Date());
        EventIdFilter filter1 = new EventIdFilter(1);
        AcknowledgedByFilter filter2 = new AcknowledgedByFilter("TestUser");
        EventCriteria criteria = new EventCriteria(new Filter[]{filter1, filter2});
        Event[] events = this.m_eventRepo.getMatchingEvents(criteria);
        Assert.assertEquals((long)1L, (long)events.length);
    }
}

