/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.asset;

import java.util.ArrayList;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.opennms.web.asset.Asset;
import org.opennms.web.asset.ImportAssetsServlet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImportAssetsServletTest {
    private Logger logger = LoggerFactory.getLogger(ImportAssetsServletTest.class);
    private ImportAssetsServlet m_importAssetServlet;
    private List<String> m_assetsAsCvs;
    private String m_testCvs = "";

    @Before
    public void setUp() throws InterruptedException {
        this.m_importAssetServlet = new ImportAssetsServlet();
        this.m_assetsAsCvs = new ArrayList<String>();
        this.m_assetsAsCvs.add("\"TakPad\",\"1\",\"Unspecified\",\"\",\"\",\"\",\"\",\"\",\"\",\"\",\"\",\"\",\"\",\"\",\"\",\"\",\"\",\"\",\"\",\"\",\"\",\"cassandra\",\"\",\"\",\"\",\"\",\"\",\"\",\"\",\"\",\"\",\"\",\"\",\"\",\"\",\"\",\"\",\"\",\"\",\"\",\"\",\"\",\" \",\"\",\"\",\"\",\"\",\"\",\"\",\"\",\"\",\"\",\"\",\"\",\"\",\"\",\"\",\"\",\"4\"");
        this.m_assetsAsCvs.add("'Indigo','2','Unspecified','','','','','','','','','','','','','','','','','','','Jasperrrr','','','','','','','','','','','','','','','','','','','','',' ','','','','','','','','','','','','','','','','3'");
        this.m_assetsAsCvs.add("S. Lem,3,Unspecified,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,8");
        this.m_assetsAsCvs.add("Fake Node Label,431,Category,Manufacturer,Vendor,Model Number,Serial Number,Description,Circuit ID,Asset Number,Operating System,Rack,Slot,Port,Region,Division,Department,Address 1,Address 2,City,State,Zip,Building,Floor,Room,Vendor Phone,Vendor Fax,Date Installed,Lease,Lease Expires,Support Phone,Maint Contract,Vendor Asset Number,Maint Contract Expires,Display Category,Notification Category,Poller Category,Threshold Category,Username,Password,Enable,Connection,A,Comments,Cpu,Ram,Storage Controller,HDD 1,HDD 2,HDD 3,HDD 4,HDD 5,HDD 6,9,Inputpower,Additional hardware,Admin,SNMP Community,12");
        this.m_assetsAsCvs.add("\"Marria\",\"5\",\"Unspecified\",\"\",\"\",\"\",\"\",\"\",\"\",\"\",\"\",\"\",\"\",\"\",\"\",\"\",\"\",\"\",\"\",\"\",\"\",\"Jasperrrr\",\"\",\"\",\"\",\"\",\"\",\"\",\"\",\"\",\"\",\"\",\"\",\"\",\"\",\"\",\"\",\"\",\"\",\"\",\"\",\"\",\" \",\"\",\"\",\"\",\"\",\"\",\"\",\"\",\"\",\"\",\"\",\"\",\"\",\"\",\"\",\"\",\"4\"");
        for (String assetCvs : this.m_assetsAsCvs) {
            this.m_testCvs = this.m_testCvs.concat(assetCvs + "\n");
        }
    }

    @Test
    public void testDecodeAssetsText() throws Exception {
        this.logger.debug(this.m_testCvs);
        List decodedAssets = this.m_importAssetServlet.decodeAssetsText(this.m_testCvs);
        Assert.assertEquals((long)5L, (long)decodedAssets.size());
        for (Asset decodedAsset : decodedAssets) {
            this.logger.debug("decodedAsset:'{}'", (Object)decodedAsset);
        }
    }
}

