/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.report.database;

import com.sun.jersey.spi.container.servlet.ServletContainer;
import com.sun.jersey.spi.spring.container.servlet.SpringServlet;
import javax.servlet.Filter;
import javax.servlet.FilterConfig;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletException;
import javax.sql.DataSource;
import junit.framework.TestCase;
import org.opennms.core.db.DataSourceFactory;
import org.opennms.core.test.db.MockDatabase;
import org.opennms.test.DaoTestConfigBean;
import org.springframework.mock.web.MockFilterConfig;
import org.springframework.mock.web.MockServletConfig;
import org.springframework.mock.web.MockServletContext;
import org.springframework.orm.hibernate3.support.OpenSessionInViewFilter;
import org.springframework.web.context.ContextLoaderListener;

public class SpringWebflowContextTest
extends TestCase {
    private String contextPath = "/opennms/rest";
    private ServletContainer dispatcher;
    private MockServletConfig servletConfig;
    private MockServletContext servletContext;
    private ContextLoaderListener contextListener;
    private Filter filter;

    public void testLoadContext() throws Throwable {
        DaoTestConfigBean bean = new DaoTestConfigBean();
        bean.afterPropertiesSet();
        MockDatabase db = new MockDatabase(true);
        DataSourceFactory.setInstance((DataSource)db);
        this.servletContext = new MockServletContext("file:src/main/webapp");
        this.servletContext.addInitParameter("contextConfigLocation", "classpath:/org/opennms/web/rest/applicationContext-test.xml classpath:/META-INF/opennms/applicationContext-commonConfigs.xml classpath*:/META-INF/opennms/component-service.xml classpath*:/META-INF/opennms/component-dao.xml classpath:/META-INF/opennms/applicationContext-reportingCore.xml classpath:/org/opennms/web/svclayer/applicationContext-svclayer.xml classpath:/META-INF/opennms/applicationContext-reporting.xml /WEB-INF/applicationContext-spring-security.xml /WEB-INF/applicationContext-spring-webflow.xml");
        this.servletContext.addInitParameter("parentContextKey", "daoContext");
        ServletContextEvent e = new ServletContextEvent((ServletContext)this.servletContext);
        this.contextListener = new ContextLoaderListener();
        this.contextListener.contextInitialized(e);
        this.servletContext.setContextPath(this.contextPath);
        this.servletConfig = new MockServletConfig((ServletContext)this.servletContext, "dispatcher");
        this.servletConfig.addInitParameter("com.sun.jersey.config.property.resourceConfigClass", "com.sun.jersey.api.core.PackagesResourceConfig");
        this.servletConfig.addInitParameter("com.sun.jersey.config.property.packages", "org.opennms.web.rest");
        try {
            MockFilterConfig filterConfig = new MockFilterConfig((ServletContext)this.servletContext, "openSessionInViewFilter");
            this.filter = new OpenSessionInViewFilter();
            this.filter.init((FilterConfig)filterConfig);
            this.dispatcher = new SpringServlet();
            this.dispatcher.init((ServletConfig)this.servletConfig);
        }
        catch (ServletException se) {
            throw se.getRootCause();
        }
    }
}

