/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.alarm;

import java.util.Date;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.opennms.core.test.OpenNMSJUnit4ClassRunner;
import org.opennms.core.test.db.annotations.JUnitTemporaryDatabase;
import org.opennms.core.utils.BeanUtils;
import org.opennms.netmgt.dao.DatabasePopulator;
import org.opennms.netmgt.model.OnmsSeverity;
import org.opennms.test.JUnitConfigurationEnvironment;
import org.opennms.web.alarm.Alarm;
import org.opennms.web.alarm.WebAlarmRepository;
import org.opennms.web.alarm.filter.AcknowledgedByFilter;
import org.opennms.web.alarm.filter.AlarmCriteria;
import org.opennms.web.alarm.filter.AlarmIdFilter;
import org.opennms.web.alarm.filter.SeverityFilter;
import org.opennms.web.filter.Filter;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.transaction.annotation.Transactional;

@RunWith(value=OpenNMSJUnit4ClassRunner.class)
@ContextConfiguration(locations={"classpath:/META-INF/opennms/applicationContext-soa.xml", "classpath:/META-INF/opennms/applicationContext-dao.xml", "classpath*:/META-INF/opennms/component-dao.xml", "classpath*:/META-INF/opennms/component-service.xml", "classpath:/jdbcWebRepositoryTestContext.xml", "classpath:/META-INF/opennms/applicationContext-minimal-conf.xml"})
@JUnitConfigurationEnvironment
@JUnitTemporaryDatabase
public class JdbcWebAlarmRepositoryTest
implements InitializingBean {
    @Autowired
    DatabasePopulator m_dbPopulator;
    @Autowired
    WebAlarmRepository m_alarmRepo;

    public void afterPropertiesSet() throws Exception {
        BeanUtils.assertAutowiring((Object)this);
    }

    @Before
    public void setUp() {
        this.m_dbPopulator.populateDatabase();
    }

    @After
    public void tearDown() {
    }

    @Test
    @Transactional
    @JUnitTemporaryDatabase
    public void testCountMatchingAlarms() {
        AlarmCriteria criteria = new AlarmCriteria(new Filter[]{new AlarmIdFilter(1)});
        int alarms = this.m_alarmRepo.countMatchingAlarms(criteria);
        Assert.assertEquals((long)1L, (long)alarms);
    }

    @Test
    @Transactional
    @JUnitTemporaryDatabase
    public void testCountMatchingAlarmsBySeverity() {
        AlarmCriteria criteria = new AlarmCriteria(new Filter[0]);
        int[] matchingAlarms = this.m_alarmRepo.countMatchingAlarmsBySeverity(criteria);
        Assert.assertEquals((long)8L, (long)matchingAlarms.length);
        Assert.assertEquals((long)0L, (long)matchingAlarms[OnmsSeverity.CLEARED.getId()]);
        Assert.assertEquals((long)0L, (long)matchingAlarms[OnmsSeverity.CRITICAL.getId()]);
        Assert.assertEquals((long)0L, (long)matchingAlarms[OnmsSeverity.INDETERMINATE.getId()]);
        Assert.assertEquals((long)0L, (long)matchingAlarms[OnmsSeverity.MINOR.getId()]);
        Assert.assertEquals((long)1L, (long)matchingAlarms[OnmsSeverity.NORMAL.getId()]);
        Assert.assertEquals((long)0L, (long)matchingAlarms[OnmsSeverity.WARNING.getId()]);
        Assert.assertEquals((long)0L, (long)matchingAlarms[OnmsSeverity.MAJOR.getId()]);
    }

    @Test
    @JUnitTemporaryDatabase
    public void testGetAlarm() {
        Alarm[] alarms = this.m_alarmRepo.getMatchingAlarms(new AlarmCriteria(new Filter[]{new AlarmIdFilter(1)}));
        Assert.assertNotNull((Object)alarms);
        Assert.assertEquals((long)1L, (long)alarms.length);
        Alarm alarm = this.m_alarmRepo.getAlarm(1);
        Assert.assertNotNull((Object)alarm);
    }

    @Test
    @JUnitTemporaryDatabase
    public void testAcknowledgeUnacknowledgeMatchingAlarms() {
        String user = "TestUser";
        this.m_alarmRepo.acknowledgeMatchingAlarms(user, new Date(), new AlarmCriteria(new Filter[]{new AlarmIdFilter(1)}));
        int matchingAlarmCount = this.m_alarmRepo.countMatchingAlarms(new AlarmCriteria(new Filter[]{new AcknowledgedByFilter(user)}));
        Assert.assertEquals((long)1L, (long)matchingAlarmCount);
        this.m_alarmRepo.unacknowledgeMatchingAlarms(new AlarmCriteria(new Filter[]{new AlarmIdFilter(1)}), user);
        matchingAlarmCount = this.m_alarmRepo.countMatchingAlarms(new AlarmCriteria(new Filter[]{new AcknowledgedByFilter(user)}));
        Assert.assertEquals((long)0L, (long)matchingAlarmCount);
    }

    @Test
    @Transactional
    @JUnitTemporaryDatabase
    public void testAcknowledgeUnacknowledgeAllAlarms() {
        String user = "TestUser";
        this.m_alarmRepo.acknowledgeAll(user, new Date());
        int matchingAlarmCount = this.m_alarmRepo.countMatchingAlarms(new AlarmCriteria(new Filter[]{new AcknowledgedByFilter(user)}));
        Assert.assertEquals((long)1L, (long)matchingAlarmCount);
        this.m_alarmRepo.unacknowledgeAll(user);
        matchingAlarmCount = this.m_alarmRepo.countMatchingAlarms(new AlarmCriteria(new Filter[]{new AcknowledgedByFilter(user)}));
        Assert.assertEquals((long)0L, (long)matchingAlarmCount);
    }

    @Test
    @Transactional
    @JUnitTemporaryDatabase
    public void testCountMatchingBySeverity() {
        int[] matchingAlarmCount = this.m_alarmRepo.countMatchingAlarmsBySeverity(new AlarmCriteria(new Filter[]{new SeverityFilter(OnmsSeverity.NORMAL)}));
        Assert.assertEquals((long)8L, (long)matchingAlarmCount.length);
    }

    @Test
    @JUnitTemporaryDatabase
    public void testEscalateAlarms() {
        int[] alarmIds = new int[]{1};
        this.m_alarmRepo.escalateAlarms(alarmIds, "TestUser", new Date());
        Alarm[] alarms = this.m_alarmRepo.getMatchingAlarms(new AlarmCriteria(new Filter[]{new AlarmIdFilter(1)}));
        Assert.assertNotNull((Object)alarms);
        Assert.assertEquals((long)OnmsSeverity.WARNING.getId(), (long)alarms[0].severity.getId());
    }

    @Test
    @JUnitTemporaryDatabase
    public void testClearAlarms() {
        Alarm alarm = this.m_alarmRepo.getAlarm(1);
        Assert.assertNotNull((Object)alarm);
        Assert.assertEquals((long)OnmsSeverity.NORMAL.getId(), (long)alarm.severity.getId());
        int[] alarmIds = new int[]{1};
        this.m_alarmRepo.clearAlarms(alarmIds, "TestUser", new Date());
        alarm = this.m_alarmRepo.getAlarm(1);
        Assert.assertNotNull((Object)alarm);
        Assert.assertEquals((long)OnmsSeverity.CLEARED.getId(), (long)alarm.severity.getId());
    }
}

