/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.svclayer.support;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.dao.GraphDao;
import org.opennms.netmgt.dao.NodeDao;
import org.opennms.netmgt.dao.ResourceDao;
import org.opennms.netmgt.dao.RrdDao;
import org.opennms.netmgt.model.OnmsResource;
import org.opennms.netmgt.model.PrefabGraph;
import org.opennms.netmgt.model.RrdGraphAttribute;
import org.opennms.netmgt.model.events.EventBuilder;
import org.opennms.netmgt.model.events.EventProxy;
import org.opennms.netmgt.model.events.EventProxyException;
import org.opennms.web.graph.Graph;
import org.opennms.web.graph.GraphResults;
import org.opennms.web.graph.RelativeTimePeriod;
import org.opennms.web.svclayer.GraphResultsService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;

public class DefaultGraphResultsService
implements GraphResultsService,
InitializingBean {
    private static Logger logger = LoggerFactory.getLogger((String)("OpenNMS.WEB." + DefaultGraphResultsService.class));
    private ResourceDao m_resourceDao;
    private GraphDao m_graphDao;
    private NodeDao m_nodeDao;
    private RrdDao m_rrdDao;
    private EventProxy m_eventProxy;
    private RelativeTimePeriod[] m_periods = RelativeTimePeriod.getDefaultPeriods();

    @Override
    public GraphResults findResults(String[] resourceIds, String[] reports, long start, long end, String relativeTime) {
        if (resourceIds == null) {
            throw new IllegalArgumentException("resourceIds argument cannot be null");
        }
        if (reports == null) {
            throw new IllegalArgumentException("reports argument cannot be null");
        }
        if (end < start) {
            throw new IllegalArgumentException("end time cannot be before start time");
        }
        GraphResults graphResults = new GraphResults();
        graphResults.setStart(new Date(start));
        graphResults.setEnd(new Date(end));
        graphResults.setRelativeTime(relativeTime);
        graphResults.setRelativeTimePeriods(this.m_periods);
        graphResults.setReports(reports);
        HashMap<String, List> resourcesMap = new HashMap<String, List>();
        for (String resourceId : resourceIds) {
            String[] values = DefaultGraphResultsService.parseResourceId(resourceId);
            if (values == null) continue;
            String parent = values[0];
            String childType = values[1];
            String childName = values[2];
            DefaultGraphResultsService.log().debug("findResults: parent, childType, childName = " + values[0] + ", " + values[1] + ", " + values[2]);
            OnmsResource resource = null;
            if (!resourcesMap.containsKey(parent)) {
                List resourceList = this.m_resourceDao.getResourceListById(resourceId);
                if (resourceList == null) {
                    DefaultGraphResultsService.log().warn("findResults: zero child resources found for " + parent);
                } else {
                    resourcesMap.put(parent, resourceList);
                    DefaultGraphResultsService.log().debug("findResults: add resourceList to map for " + parent);
                }
            }
            for (OnmsResource r : (List)resourcesMap.get(parent)) {
                if (!childType.equals(r.getResourceType().getName()) || !childName.equals(r.getName())) continue;
                resource = r;
                DefaultGraphResultsService.log().debug("findResults: found resource in map" + r.toString());
                break;
            }
            try {
                graphResults.addGraphResultSet(this.createGraphResultSet(resourceId, resource, reports, graphResults));
            }
            catch (IllegalArgumentException e) {
                DefaultGraphResultsService.log().warn(e.getMessage(), (Throwable)e);
            }
        }
        graphResults.setGraphTopOffsetWithText(this.m_rrdDao.getGraphTopOffsetWithText());
        graphResults.setGraphLeftOffset(this.m_rrdDao.getGraphLeftOffset());
        graphResults.setGraphRightOffset(this.m_rrdDao.getGraphRightOffset());
        return graphResults;
    }

    public static String[] parseResourceId(String resourceId) {
        try {
            String parent = resourceId.substring(0, resourceId.indexOf(93) + 1);
            String child = resourceId.substring(resourceId.indexOf(93) + 2);
            String childType = child.substring(0, child.indexOf(91));
            String childName = child.substring(child.indexOf(91) + 1, child.indexOf(93));
            return new String[]{parent, childType, childName};
        }
        catch (Throwable e) {
            DefaultGraphResultsService.log().warn("Illegally formatted resourceId found in DefaultGraphResultsService: " + resourceId, e);
            return null;
        }
    }

    private GraphResults.GraphResultSet createGraphResultSet(String resourceId, OnmsResource resource, String[] reports, GraphResults graphResults) throws IllegalArgumentException {
        if (resource == null && (resource = this.m_resourceDao.getResourceById(resourceId)) == null) {
            throw new IllegalArgumentException("Could not find resource \"" + resourceId + "\"");
        }
        GraphResults.GraphResultSet rs = new GraphResults.GraphResultSet(graphResults);
        rs.setResource(resource);
        if (reports.length == 1 && "all".equals(reports[0])) {
            PrefabGraph[] queries = this.m_graphDao.getPrefabGraphsForResource(resource);
            ArrayList<String> queryNames = new ArrayList<String>(queries.length);
            for (String string : queries) {
                queryNames.add(string.getName());
            }
            reports = queryNames.toArray(new String[queryNames.size()]);
        }
        ArrayList<Graph> graphs = new ArrayList<Graph>(reports.length);
        LinkedList<String> filesToPromote = new LinkedList<String>();
        for (String string : reports) {
            PrefabGraph prefabGraph = this.m_graphDao.getPrefabGraph(string);
            Graph graph = new Graph(prefabGraph, resource, graphResults.getStart(), graphResults.getEnd());
            this.getAttributeFiles(graph, filesToPromote);
            graphs.add(graph);
        }
        this.sendEvent(filesToPromote);
        Collections.sort(graphs);
        rs.setGraphs(graphs);
        return rs;
    }

    private void sendEvent(List<String> filesToPromote) {
        EventBuilder bldr = new EventBuilder("uei.opennms.org/internal/promoteQueueData", "OpenNMS.Webapp");
        bldr.addParam("filesToPromote", filesToPromote);
        try {
            this.m_eventProxy.send(bldr.getEvent());
        }
        catch (EventProxyException e) {
            DefaultGraphResultsService.log().warn("Unable to send promotion event to opennms daemon", (Throwable)e);
        }
    }

    private static ThreadCategory log() {
        return ThreadCategory.getInstance(DefaultGraphResultsService.class);
    }

    private void getAttributeFiles(Graph graph, List<String> filesToPromote) {
        Collection<RrdGraphAttribute> attrs = graph.getRequiredRrGraphdAttributes();
        for (RrdGraphAttribute rrdAttr : attrs) {
            DefaultGraphResultsService.log().debug("getAttributeFiles: ResourceType, ParentResourceType = " + rrdAttr.getResource().getResourceType().getLabel() + ", " + rrdAttr.getResource().getParent().getResourceType().getLabel());
            if (rrdAttr.getResource().getParent().getResourceType().getLabel().equals("nodeSource")) {
                filesToPromote.add(this.m_resourceDao.getRrdDirectory() + File.separator + "foreignSource" + File.separator + rrdAttr.getRrdRelativePath());
                continue;
            }
            filesToPromote.add(this.m_resourceDao.getRrdDirectory() + File.separator + rrdAttr.getRrdRelativePath());
        }
    }

    public void afterPropertiesSet() {
        Assert.state((this.m_nodeDao != null ? 1 : 0) != 0, (String)"nodeDao property has not been set");
        Assert.state((this.m_resourceDao != null ? 1 : 0) != 0, (String)"resourceDao property has not been set");
        Assert.state((this.m_graphDao != null ? 1 : 0) != 0, (String)"graphDao property has not been set");
        Assert.state((this.m_rrdDao != null ? 1 : 0) != 0, (String)"rrdDao property has not been set");
    }

    public ResourceDao getResourceDao() {
        return this.m_resourceDao;
    }

    public void setResourceDao(ResourceDao resourceDao) {
        this.m_resourceDao = resourceDao;
    }

    public NodeDao getNodeDao() {
        return this.m_nodeDao;
    }

    public void setNodeDao(NodeDao nodeDao) {
        this.m_nodeDao = nodeDao;
    }

    public GraphDao getGraphDao() {
        return this.m_graphDao;
    }

    public void setGraphDao(GraphDao graphDao) {
        this.m_graphDao = graphDao;
    }

    public RrdDao getRrdDao() {
        return this.m_rrdDao;
    }

    public void setRrdDao(RrdDao rrdDao) {
        this.m_rrdDao = rrdDao;
    }

    public void setEventProxy(EventProxy eventProxy) {
        this.m_eventProxy = eventProxy;
    }
}

