/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.rest;

import com.sun.jersey.spi.resource.PerRequest;
import java.net.InetAddress;
import java.net.URI;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.config.SnmpEventInfo;
import org.opennms.netmgt.config.SnmpPeerFactory;
import org.opennms.netmgt.snmp.SnmpAgentConfig;
import org.opennms.web.rest.MultivaluedMapImpl;
import org.opennms.web.rest.OnmsRestService;
import org.opennms.web.snmpinfo.SnmpInfo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
@PerRequest
@Scope(value="prototype")
@Path(value="snmpConfig")
@Transactional
public class SnmpConfigRestService
extends OnmsRestService {
    @Context
    UriInfo m_uriInfo;
    @Autowired
    private SnmpPeerFactory m_snmpPeerFactory;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GET
    @Produces(value={"application/xml", "application/json", "application/atom+xml"})
    @Path(value="{ipAddr}")
    public SnmpInfo getSnmpInfo(@PathParam(value="ipAddr") String ipAddr) {
        this.readLock();
        try {
            InetAddress addr = InetAddressUtils.addr((String)ipAddr);
            if (addr == null) {
                throw new WebApplicationException(Response.serverError().build());
            }
            SnmpAgentConfig config = this.m_snmpPeerFactory.getAgentConfig(addr);
            SnmpInfo snmpInfo = new SnmpInfo(config);
            return snmpInfo;
        }
        finally {
            this.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PUT
    @Consumes(value={"application/xml"})
    @Path(value="{ipAddr}")
    public Response setSnmpInfo(@PathParam(value="ipAddr") String ipAddress, SnmpInfo snmpInfo) {
        this.writeLock();
        try {
            SnmpEventInfo eventInfo = snmpInfo.createEventInfo(ipAddress);
            this.m_snmpPeerFactory.define(eventInfo);
            SnmpPeerFactory.saveCurrent();
            Response response = Response.seeOther((URI)SnmpConfigRestService.getRedirectUri(this.m_uriInfo, new Object[0])).build();
            return response;
        }
        catch (Throwable e) {
            Response response = Response.serverError().build();
            return response;
        }
        finally {
            this.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PUT
    @Path(value="{ipAddr}")
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Transactional
    public Response updateInterface(@PathParam(value="ipAddr") String ipAddress, MultivaluedMapImpl params) {
        this.writeLock();
        try {
            SnmpInfo info = new SnmpInfo();
            this.setProperties(params, info);
            SnmpEventInfo eventInfo = info.createEventInfo(ipAddress);
            this.m_snmpPeerFactory.define(eventInfo);
            SnmpPeerFactory.saveCurrent();
            Response response = Response.seeOther((URI)SnmpConfigRestService.getRedirectUri(this.m_uriInfo, new Object[0])).build();
            return response;
        }
        catch (Throwable e) {
            Response response = Response.serverError().build();
            return response;
        }
        finally {
            this.writeUnlock();
        }
    }
}

