/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.rest;

import com.sun.jersey.spi.resource.PerRequest;
import java.net.URI;
import java.text.ParseException;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.core.UriInfo;
import javax.xml.bind.ValidationException;
import org.opennms.core.utils.LogUtils;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.provision.persist.requisition.Requisition;
import org.opennms.netmgt.provision.persist.requisition.RequisitionAsset;
import org.opennms.netmgt.provision.persist.requisition.RequisitionAssetCollection;
import org.opennms.netmgt.provision.persist.requisition.RequisitionCategory;
import org.opennms.netmgt.provision.persist.requisition.RequisitionCategoryCollection;
import org.opennms.netmgt.provision.persist.requisition.RequisitionCollection;
import org.opennms.netmgt.provision.persist.requisition.RequisitionInterface;
import org.opennms.netmgt.provision.persist.requisition.RequisitionInterfaceCollection;
import org.opennms.netmgt.provision.persist.requisition.RequisitionMonitoredService;
import org.opennms.netmgt.provision.persist.requisition.RequisitionMonitoredServiceCollection;
import org.opennms.netmgt.provision.persist.requisition.RequisitionNode;
import org.opennms.netmgt.provision.persist.requisition.RequisitionNodeCollection;
import org.opennms.web.rest.MultivaluedMapImpl;
import org.opennms.web.rest.OnmsRestService;
import org.opennms.web.rest.RequisitionAccessService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
@PerRequest
@Scope(value="prototype")
@Path(value="requisitions")
public class RequisitionRestService
extends OnmsRestService {
    @Autowired
    private RequisitionAccessService m_accessService;
    @Context
    UriInfo m_uriInfo;
    @Context
    HttpHeaders m_headers;
    @Context
    SecurityContext m_securityContext;

    @GET
    @Path(value="deployed/count")
    @Produces(value={"text/plain"})
    public String getDeployedCount() {
        return Integer.toString(this.m_accessService.getDeployedCount());
    }

    @Override
    protected ThreadCategory log() {
        return super.log();
    }

    @GET
    @Path(value="deployed")
    @Produces(value={"application/xml", "application/json", "application/atom+xml"})
    public RequisitionCollection getDeployedRequisitions() throws ParseException {
        return this.m_accessService.getDeployedRequisitions();
    }

    @GET
    @Produces(value={"application/xml", "application/json", "application/atom+xml"})
    public RequisitionCollection getRequisitions() throws ParseException {
        return this.m_accessService.getRequisitions();
    }

    @GET
    @Path(value="count")
    @Produces(value={"text/plain"})
    public String getPendingCount() {
        return Integer.toString(this.m_accessService.getPendingCount());
    }

    @GET
    @Path(value="{foreignSource}")
    @Produces(value={"application/xml", "application/json", "application/atom+xml"})
    public Requisition getRequisition(@PathParam(value="foreignSource") String foreignSource) {
        return this.m_accessService.getRequisition(foreignSource);
    }

    @GET
    @Path(value="{foreignSource}/nodes")
    @Produces(value={"application/xml", "application/json", "application/atom+xml"})
    public RequisitionNodeCollection getNodes(@PathParam(value="foreignSource") String foreignSource) throws ParseException {
        RequisitionNodeCollection results = this.m_accessService.getNodes(foreignSource);
        if (results == null) {
            throw this.getException(Response.Status.NOT_FOUND, "Foreign source '" + foreignSource + "' not found.");
        }
        return results;
    }

    @GET
    @Path(value="{foreignSource}/nodes/{foreignId}")
    @Produces(value={"application/xml", "application/json", "application/atom+xml"})
    public RequisitionNode getNode(@PathParam(value="foreignSource") String foreignSource, @PathParam(value="foreignId") String foreignId) throws ParseException {
        RequisitionNode node = this.m_accessService.getNode(foreignSource, foreignId);
        if (node == null) {
            throw this.getException(Response.Status.NOT_FOUND, "Node with Foreign ID '" + foreignId + "' and Foreign source '" + foreignSource + "' not found.");
        }
        return node;
    }

    @GET
    @Path(value="{foreignSource}/nodes/{foreignId}/interfaces")
    @Produces(value={"application/xml", "application/json", "application/atom+xml"})
    public RequisitionInterfaceCollection getInterfacesForNode(@PathParam(value="foreignSource") String foreignSource, @PathParam(value="foreignId") String foreignId) throws ParseException {
        RequisitionInterfaceCollection ifaces = this.m_accessService.getInterfacesForNode(foreignSource, foreignId);
        if (ifaces == null) {
            throw this.getException(Response.Status.NOT_FOUND, "Foreign ID '" + foreignId + "' not found in foreign source '" + foreignSource + "'.");
        }
        return ifaces;
    }

    @GET
    @Path(value="{foreignSource}/nodes/{foreignId}/interfaces/{ipAddress}")
    @Produces(value={"application/xml", "application/json", "application/atom+xml"})
    public RequisitionInterface getInterfaceForNode(@PathParam(value="foreignSource") String foreignSource, @PathParam(value="foreignId") String foreignId, @PathParam(value="ipAddress") String ipAddress) throws ParseException {
        RequisitionInterface iface = this.m_accessService.getInterfaceForNode(foreignSource, foreignId, ipAddress);
        if (iface == null) {
            throw this.getException(Response.Status.NOT_FOUND, "Foreign ID '" + foreignId + "' not found in foreign source '" + foreignSource + "'.");
        }
        return iface;
    }

    @GET
    @Path(value="{foreignSource}/nodes/{foreignId}/interfaces/{ipAddress}/services")
    @Produces(value={"application/xml", "application/json", "application/atom+xml"})
    public RequisitionMonitoredServiceCollection getServicesForInterface(@PathParam(value="foreignSource") String foreignSource, @PathParam(value="foreignId") String foreignId, @PathParam(value="ipAddress") String ipAddress) throws ParseException {
        RequisitionMonitoredServiceCollection services = this.m_accessService.getServicesForInterface(foreignSource, foreignId, ipAddress);
        if (services == null) {
            throw this.getException(Response.Status.NOT_FOUND, "Unable to locate IP address '" + ipAddress + "' in " + foreignSource + ":" + foreignId + ".");
        }
        return services;
    }

    @GET
    @Path(value="{foreignSource}/nodes/{foreignId}/interfaces/{ipAddress}/services/{service}")
    @Produces(value={"application/xml", "application/json", "application/atom+xml"})
    public RequisitionMonitoredService getServiceForInterface(@PathParam(value="foreignSource") String foreignSource, @PathParam(value="foreignId") String foreignId, @PathParam(value="ipAddress") String ipAddress, @PathParam(value="service") String service) throws ParseException {
        RequisitionMonitoredService monitoredService = this.m_accessService.getServiceForInterface(foreignSource, foreignId, ipAddress, service);
        if (monitoredService == null) {
            throw this.getException(Response.Status.NOT_FOUND, "Unable to locate IP address '" + ipAddress + "' in " + foreignSource + ":" + foreignId + ".");
        }
        return monitoredService;
    }

    @GET
    @Path(value="{foreignSource}/nodes/{foreignId}/categories")
    @Produces(value={"application/xml", "application/json", "application/atom+xml"})
    public RequisitionCategoryCollection getCategories(@PathParam(value="foreignSource") String foreignSource, @PathParam(value="foreignId") String foreignId) throws ParseException {
        RequisitionCategoryCollection categories = this.m_accessService.getCategories(foreignSource, foreignId);
        if (categories == null) {
            throw this.getException(Response.Status.NOT_FOUND, "Unable to location node with ForeignSource: " + foreignSource + " and ForeignId: " + foreignId);
        }
        return categories;
    }

    @GET
    @Path(value="{foreignSource}/nodes/{foreignId}/categories/{category}")
    @Produces(value={"application/xml", "application/json", "application/atom+xml"})
    public RequisitionCategory getCategory(@PathParam(value="foreignSource") String foreignSource, @PathParam(value="foreignId") String foreignId, @PathParam(value="category") String category) throws ParseException {
        RequisitionCategory reqCategory = this.m_accessService.getCategory(foreignSource, foreignId, category);
        if (reqCategory == null) {
            throw this.getException(Response.Status.NOT_FOUND, "Unable to find category " + category + " on node with Foreign ID '" + foreignId + "' and foreign source '" + foreignSource + "'.");
        }
        return reqCategory;
    }

    @GET
    @Path(value="{foreignSource}/nodes/{foreignId}/assets")
    @Produces(value={"application/xml", "application/json", "application/atom+xml"})
    public RequisitionAssetCollection getAssetParameters(@PathParam(value="foreignSource") String foreignSource, @PathParam(value="foreignId") String foreignId) throws ParseException {
        RequisitionAssetCollection assets = this.m_accessService.getAssetParameters(foreignSource, foreignId);
        if (assets == null) {
            throw this.getException(Response.Status.NOT_FOUND, "Unable able to find assets for node with foreign ID '" + foreignId + "' not found in foreign source '" + foreignSource + "'.");
        }
        return assets;
    }

    @GET
    @Path(value="{foreignSource}/nodes/{foreignId}/assets/{parameter}")
    @Produces(value={"application/xml", "application/json", "application/atom+xml"})
    public RequisitionAsset getAssetParameter(@PathParam(value="foreignSource") String foreignSource, @PathParam(value="foreignId") String foreignId, @PathParam(value="parameter") String parameter) throws ParseException {
        RequisitionAsset asset = this.m_accessService.getAssetParameter(foreignSource, foreignId, parameter);
        if (asset == null) {
            throw this.getException(Response.Status.NOT_FOUND, "Unable to find asset " + parameter + " for node with foreign ID '" + foreignId + "' not found in foreign source '" + foreignSource + "'.");
        }
        return asset;
    }

    @POST
    @Consumes(value={"application/xml"})
    @Transactional
    public Response addOrReplaceRequisition(Requisition requisition) {
        try {
            requisition.validate();
        }
        catch (ValidationException e) {
            LogUtils.debugf((Object)this, (Throwable)e, (String)"error validating incoming requisition with foreign source '%s'", (Object[])new Object[]{requisition.getForeignSource()});
            throw this.getException(Response.Status.BAD_REQUEST, e.getMessage());
        }
        this.debug("addOrReplaceRequisition: Adding requisition %s (containing %d nodes)", requisition.getForeignSource(), requisition.getNodeCount());
        this.m_accessService.addOrReplaceRequisition(requisition);
        return Response.seeOther((URI)RequisitionRestService.getRedirectUri(this.m_uriInfo, requisition.getForeignSource())).build();
    }

    @POST
    @Path(value="{foreignSource}/nodes")
    @Consumes(value={"application/xml"})
    @Transactional
    public Response addOrReplaceNode(@PathParam(value="foreignSource") String foreignSource, RequisitionNode node) {
        this.debug("addOrReplaceNode: Adding node %s to requisition %s", node.getForeignId(), foreignSource);
        this.m_accessService.addOrReplaceNode(foreignSource, node);
        return Response.seeOther((URI)RequisitionRestService.getRedirectUri(this.m_uriInfo, node.getForeignId())).build();
    }

    @POST
    @Path(value="{foreignSource}/nodes/{foreignId}/interfaces")
    @Consumes(value={"application/xml"})
    @Transactional
    public Response addOrReplaceInterface(@PathParam(value="foreignSource") String foreignSource, @PathParam(value="foreignId") String foreignId, RequisitionInterface iface) {
        this.debug("addOrReplaceInterface: Adding interface %s to node %s/%s", iface, foreignSource, foreignId);
        this.m_accessService.addOrReplaceInterface(foreignSource, foreignId, iface);
        return Response.seeOther((URI)RequisitionRestService.getRedirectUri(this.m_uriInfo, iface.getIpAddr())).build();
    }

    @POST
    @Path(value="{foreignSource}/nodes/{foreignId}/interfaces/{ipAddress}/services")
    @Consumes(value={"application/xml"})
    @Transactional
    public Response addOrReplaceService(@PathParam(value="foreignSource") String foreignSource, @PathParam(value="foreignId") String foreignId, @PathParam(value="ipAddress") String ipAddress, RequisitionMonitoredService service) {
        this.debug("addOrReplaceService: Adding service %s to node %s/%s, interface %s", service.getServiceName(), foreignSource, foreignId, ipAddress);
        this.m_accessService.addOrReplaceService(foreignSource, foreignId, ipAddress, service);
        return Response.seeOther((URI)RequisitionRestService.getRedirectUri(this.m_uriInfo, service.getServiceName())).build();
    }

    @POST
    @Path(value="{foreignSource}/nodes/{foreignId}/categories")
    @Consumes(value={"application/xml"})
    @Transactional
    public Response addOrReplaceNodeCategory(@PathParam(value="foreignSource") String foreignSource, @PathParam(value="foreignId") String foreignId, RequisitionCategory category) {
        this.debug("addOrReplaceNodeCategory: Adding category %s to node %s/%s", category.getName(), foreignSource, foreignId);
        this.m_accessService.addOrReplaceNodeCategory(foreignSource, foreignId, category);
        return Response.seeOther((URI)RequisitionRestService.getRedirectUri(this.m_uriInfo, category.getName())).build();
    }

    @POST
    @Path(value="{foreignSource}/nodes/{foreignId}/assets")
    @Consumes(value={"application/xml"})
    @Transactional
    public Response addOrReplaceNodeAssetParameter(@PathParam(value="foreignSource") String foreignSource, @PathParam(value="foreignId") String foreignId, RequisitionAsset asset) {
        this.debug("addOrReplaceNodeCategory: Adding asset %s to node %s/%s", asset.getName(), foreignSource, foreignId);
        this.m_accessService.addOrReplaceNodeAssetParameter(foreignSource, foreignId, asset);
        return Response.seeOther((URI)RequisitionRestService.getRedirectUri(this.m_uriInfo, asset.getName())).build();
    }

    @PUT
    @Path(value="{foreignSource}/import")
    @Transactional
    public Response importRequisition(@PathParam(value="foreignSource") String foreignSource, @QueryParam(value="rescanExisting") Boolean rescanExisting) {
        this.debug("importRequisition: Importing requisition for foreign source %s", foreignSource);
        this.m_accessService.importRequisition(foreignSource, rescanExisting);
        return Response.seeOther((URI)this.m_uriInfo.getBaseUriBuilder().path(this.getClass()).path(this.getClass(), "getRequisition").build(new Object[]{foreignSource})).build();
    }

    @PUT
    @Path(value="{foreignSource}")
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Transactional
    public Response updateRequisition(@PathParam(value="foreignSource") String foreignSource, MultivaluedMapImpl params) {
        this.m_accessService.updateRequisition(foreignSource, params);
        return Response.seeOther((URI)RequisitionRestService.getRedirectUri(this.m_uriInfo, new Object[0])).build();
    }

    @PUT
    @Path(value="{foreignSource}/nodes/{foreignId}")
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Transactional
    public Response updateNode(@PathParam(value="foreignSource") String foreignSource, @PathParam(value="foreignId") String foreignId, MultivaluedMapImpl params) {
        this.m_accessService.updateNode(foreignSource, foreignId, params);
        return Response.seeOther((URI)RequisitionRestService.getRedirectUri(this.m_uriInfo, new Object[0])).build();
    }

    @PUT
    @Path(value="{foreignSource}/nodes/{foreignId}/interfaces/{ipAddress}")
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Transactional
    public Response updateInterface(@PathParam(value="foreignSource") String foreignSource, @PathParam(value="foreignId") String foreignId, @PathParam(value="ipAddress") String ipAddress, MultivaluedMapImpl params) {
        this.m_accessService.updateInterface(foreignSource, foreignId, ipAddress, params);
        return Response.seeOther((URI)RequisitionRestService.getRedirectUri(this.m_uriInfo, new Object[0])).build();
    }

    @DELETE
    @Path(value="{foreignSource}")
    @Transactional
    public Response deletePendingRequisition(@PathParam(value="foreignSource") String foreignSource) {
        this.m_accessService.deletePendingRequisition(foreignSource);
        return Response.ok().build();
    }

    @DELETE
    @Path(value="deployed/{foreignSource}")
    @Transactional
    public Response deleteDeployedRequisition(@PathParam(value="foreignSource") String foreignSource) {
        this.m_accessService.deleteDeployedRequisition(foreignSource);
        return Response.ok().build();
    }

    @DELETE
    @Path(value="{foreignSource}/nodes/{foreignId}")
    @Transactional
    public Response deleteNode(@PathParam(value="foreignSource") String foreignSource, @PathParam(value="foreignId") String foreignId) {
        this.m_accessService.deleteNode(foreignSource, foreignId);
        return Response.ok().build();
    }

    @DELETE
    @Path(value="{foreignSource}/nodes/{foreignId}/interfaces/{ipAddress}")
    @Transactional
    public Response deleteInterface(@PathParam(value="foreignSource") String foreignSource, @PathParam(value="foreignId") String foreignId, @PathParam(value="ipAddress") String ipAddress) {
        this.m_accessService.deleteInterface(foreignSource, foreignId, ipAddress);
        return Response.ok().build();
    }

    @DELETE
    @Path(value="{foreignSource}/nodes/{foreignId}/interfaces/{ipAddress}/services/{service}")
    @Transactional
    public Response deleteInterfaceService(@PathParam(value="foreignSource") String foreignSource, @PathParam(value="foreignId") String foreignId, @PathParam(value="ipAddress") String ipAddress, @PathParam(value="service") String service) {
        this.m_accessService.deleteInterfaceService(foreignSource, foreignId, ipAddress, service);
        return Response.ok().build();
    }

    @DELETE
    @Path(value="{foreignSource}/nodes/{foreignId}/categories/{category}")
    @Transactional
    public Response deleteCategory(@PathParam(value="foreignSource") String foreignSource, @PathParam(value="foreignId") String foreignId, @PathParam(value="category") String category) {
        this.m_accessService.deleteCategory(foreignSource, foreignId, category);
        return Response.ok().build();
    }

    @DELETE
    @Path(value="{foreignSource}/nodes/{foreignId}/assets/{parameter}")
    @Transactional
    public Response deleteAssetParameter(@PathParam(value="foreignSource") String foreignSource, @PathParam(value="foreignId") String foreignId, @PathParam(value="parameter") String parameter) {
        this.m_accessService.deleteAssetParameter(foreignSource, foreignId, parameter);
        return Response.ok().build();
    }

    void debug(String format, Object ... values) {
        LogUtils.debugf((Object)this, (String)format, (Object[])values);
    }
}

