/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.rest;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import org.opennms.core.utils.LogUtils;
import org.opennms.netmgt.model.events.EventBuilder;
import org.opennms.netmgt.model.events.EventProxy;
import org.opennms.netmgt.model.events.EventProxyException;
import org.opennms.netmgt.provision.persist.ForeignSourceRepository;
import org.opennms.netmgt.provision.persist.RequisitionFileUtils;
import org.opennms.netmgt.provision.persist.requisition.Requisition;
import org.opennms.netmgt.provision.persist.requisition.RequisitionAsset;
import org.opennms.netmgt.provision.persist.requisition.RequisitionAssetCollection;
import org.opennms.netmgt.provision.persist.requisition.RequisitionCategory;
import org.opennms.netmgt.provision.persist.requisition.RequisitionCategoryCollection;
import org.opennms.netmgt.provision.persist.requisition.RequisitionCollection;
import org.opennms.netmgt.provision.persist.requisition.RequisitionInterface;
import org.opennms.netmgt.provision.persist.requisition.RequisitionInterfaceCollection;
import org.opennms.netmgt.provision.persist.requisition.RequisitionMonitoredService;
import org.opennms.netmgt.provision.persist.requisition.RequisitionMonitoredServiceCollection;
import org.opennms.netmgt.provision.persist.requisition.RequisitionNode;
import org.opennms.netmgt.provision.persist.requisition.RequisitionNodeCollection;
import org.opennms.web.rest.MultivaluedMapImpl;
import org.opennms.web.rest.RestUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.dao.DataAccessResourceFailureException;

public class RequisitionAccessService {
    @Autowired
    @Qualifier(value="pending")
    private ForeignSourceRepository m_pendingForeignSourceRepository;
    @Autowired
    @Qualifier(value="deployed")
    private ForeignSourceRepository m_deployedForeignSourceRepository;
    @Autowired
    private EventProxy m_eventProxy;
    private final ExecutorService m_executor = Executors.newSingleThreadExecutor(new ThreadFactory(){

        @Override
        public Thread newThread(Runnable r) {
            return new Thread(r, "Requisition-Accessor-Thread");
        }
    });
    private final Map<String, RequisitionAccessor> m_accessors = new HashMap<String, RequisitionAccessor>();

    private RequisitionAccessor getAccessor(String foreignSource) {
        RequisitionAccessor accessor = this.m_accessors.get(foreignSource);
        if (accessor == null) {
            accessor = new RequisitionAccessor(foreignSource, this.m_pendingForeignSourceRepository, this.m_deployedForeignSourceRepository);
            this.m_accessors.put(foreignSource, accessor);
        }
        return accessor;
    }

    private void flushAll() {
        for (RequisitionAccessor accessor : this.m_accessors.values()) {
            accessor.flush();
        }
    }

    private ForeignSourceRepository getPendingForeignSourceRepository() {
        return this.m_pendingForeignSourceRepository;
    }

    private ForeignSourceRepository getDeployedForeignSourceRepository() {
        return this.m_deployedForeignSourceRepository;
    }

    private EventProxy getEventProxy() {
        return this.m_eventProxy;
    }

    private <T> T submitAndWait(Callable<T> callable) {
        try {
            return this.m_executor.submit(callable).get();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof RuntimeException) {
                throw (RuntimeException)e.getCause();
            }
            throw new RuntimeException(e.getCause());
        }
    }

    private Future<?> submitWriteOp(Runnable r) {
        return this.m_executor.submit(r);
    }

    public int getDeployedCount() {
        return this.submitAndWait(new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                RequisitionAccessService.this.flushAll();
                return RequisitionAccessService.this.getDeployedForeignSourceRepository().getRequisitions().size();
            }
        });
    }

    public RequisitionCollection getDeployedRequisitions() {
        return this.submitAndWait(new Callable<RequisitionCollection>(){

            @Override
            public RequisitionCollection call() throws Exception {
                RequisitionAccessService.this.flushAll();
                return new RequisitionCollection((Collection)RequisitionAccessService.this.getDeployedForeignSourceRepository().getRequisitions());
            }
        });
    }

    public RequisitionCollection getRequisitions() {
        return this.submitAndWait(new Callable<RequisitionCollection>(){

            @Override
            public RequisitionCollection call() throws Exception {
                RequisitionAccessService.this.flushAll();
                TreeSet<Requisition> reqs = new TreeSet<Requisition>();
                Set fsNames = RequisitionAccessService.this.getPendingForeignSourceRepository().getActiveForeignSourceNames();
                fsNames.addAll(RequisitionAccessService.this.getDeployedForeignSourceRepository().getActiveForeignSourceNames());
                Set activeForeignSourceNames = fsNames;
                for (String fsName : activeForeignSourceNames) {
                    Requisition r = RequisitionAccessService.this.getAccessor(fsName).getActiveRequisition(false);
                    if (r == null) continue;
                    reqs.add(r);
                }
                return new RequisitionCollection(reqs);
            }
        });
    }

    public int getPendingCount() {
        return this.submitAndWait(new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                RequisitionAccessService.this.flushAll();
                return RequisitionAccessService.this.getPendingForeignSourceRepository().getRequisitions().size();
            }
        });
    }

    public Requisition getRequisition(final String foreignSource) {
        return this.submitAndWait(new Callable<Requisition>(){

            @Override
            public Requisition call() throws Exception {
                return RequisitionAccessService.this.getAccessor(foreignSource).getRequisition();
            }
        });
    }

    public RequisitionNodeCollection getNodes(final String foreignSource) {
        return this.submitAndWait(new Callable<RequisitionNodeCollection>(){

            @Override
            public RequisitionNodeCollection call() throws Exception {
                return RequisitionAccessService.this.getAccessor(foreignSource).getNodes();
            }
        });
    }

    public RequisitionNode getNode(final String foreignSource, final String foreignId) {
        return this.submitAndWait(new Callable<RequisitionNode>(){

            @Override
            public RequisitionNode call() throws Exception {
                RequisitionAccessor accessor = RequisitionAccessService.this.getAccessor(foreignSource);
                return accessor.getNode(foreignId);
            }
        });
    }

    public RequisitionInterfaceCollection getInterfacesForNode(final String foreignSource, final String foreignId) {
        return this.submitAndWait(new Callable<RequisitionInterfaceCollection>(){

            @Override
            public RequisitionInterfaceCollection call() throws Exception {
                return RequisitionAccessService.this.getAccessor(foreignSource).getInterfacesForNode(foreignId);
            }
        });
    }

    public RequisitionInterface getInterfaceForNode(final String foreignSource, final String foreignId, final String ipAddress) {
        return this.submitAndWait(new Callable<RequisitionInterface>(){

            @Override
            public RequisitionInterface call() throws Exception {
                return RequisitionAccessService.this.getAccessor(foreignSource).getInterfaceForNode(foreignId, ipAddress);
            }
        });
    }

    public RequisitionMonitoredServiceCollection getServicesForInterface(final String foreignSource, final String foreignId, final String ipAddress) {
        return this.submitAndWait(new Callable<RequisitionMonitoredServiceCollection>(){

            @Override
            public RequisitionMonitoredServiceCollection call() throws Exception {
                return RequisitionAccessService.this.getAccessor(foreignSource).getServicesForInterface(foreignId, ipAddress);
            }
        });
    }

    public RequisitionMonitoredService getServiceForInterface(final String foreignSource, final String foreignId, final String ipAddress, final String service) {
        return this.submitAndWait(new Callable<RequisitionMonitoredService>(){

            @Override
            public RequisitionMonitoredService call() throws Exception {
                return RequisitionAccessService.this.getAccessor(foreignSource).getServiceForInterface(foreignId, ipAddress, service);
            }
        });
    }

    public RequisitionCategoryCollection getCategories(final String foreignSource, final String foreignId) {
        return this.submitAndWait(new Callable<RequisitionCategoryCollection>(){

            @Override
            public RequisitionCategoryCollection call() throws Exception {
                return RequisitionAccessService.this.getAccessor(foreignSource).getCategories(foreignId);
            }
        });
    }

    public RequisitionCategory getCategory(final String foreignSource, final String foreignId, final String category) {
        return this.submitAndWait(new Callable<RequisitionCategory>(){

            @Override
            public RequisitionCategory call() throws Exception {
                return RequisitionAccessService.this.getAccessor(foreignSource).getCategory(foreignId, category);
            }
        });
    }

    public RequisitionAssetCollection getAssetParameters(final String foreignSource, final String foreignId) {
        return this.submitAndWait(new Callable<RequisitionAssetCollection>(){

            @Override
            public RequisitionAssetCollection call() throws Exception {
                return RequisitionAccessService.this.getAccessor(foreignSource).getAssetParameters(foreignId);
            }
        });
    }

    public RequisitionAsset getAssetParameter(final String foreignSource, final String foreignId, final String parameter) {
        return this.submitAndWait(new Callable<RequisitionAsset>(){

            @Override
            public RequisitionAsset call() throws Exception {
                return RequisitionAccessService.this.getAccessor(foreignSource).getAssetParameter(foreignId, parameter);
            }
        });
    }

    public void addOrReplaceRequisition(final Requisition requisition) {
        this.submitWriteOp(new Runnable(){

            @Override
            public void run() {
                RequisitionAccessService.this.getAccessor(requisition.getForeignSource()).save(requisition);
            }
        });
    }

    public void addOrReplaceNode(final String foreignSource, final RequisitionNode node) {
        this.submitWriteOp(new Runnable(){

            @Override
            public void run() {
                RequisitionAccessService.this.getAccessor(foreignSource).addOrReplaceNode(node);
            }
        });
    }

    public void addOrReplaceInterface(final String foreignSource, final String foreignId, final RequisitionInterface iface) {
        this.submitWriteOp(new Runnable(){

            @Override
            public void run() {
                RequisitionAccessService.this.getAccessor(foreignSource).addOrReplaceInterface(foreignId, iface);
            }
        });
    }

    public void addOrReplaceService(final String foreignSource, final String foreignId, final String ipAddress, final RequisitionMonitoredService service) {
        this.submitWriteOp(new Runnable(){

            @Override
            public void run() {
                RequisitionAccessService.this.getAccessor(foreignSource).addOrReplaceService(foreignId, ipAddress, service);
            }
        });
    }

    public void addOrReplaceNodeCategory(final String foreignSource, final String foreignId, final RequisitionCategory category) {
        this.submitWriteOp(new Runnable(){

            @Override
            public void run() {
                RequisitionAccessService.this.getAccessor(foreignSource).addOrReplaceNodeCategory(foreignId, category);
            }
        });
    }

    public void addOrReplaceNodeAssetParameter(final String foreignSource, final String foreignId, final RequisitionAsset asset) {
        this.submitWriteOp(new Runnable(){

            @Override
            public void run() {
                RequisitionAccessService.this.getAccessor(foreignSource).addOrReplaceNodeAssetParameter(foreignId, asset);
            }
        });
    }

    public void importRequisition(String foreignSource, Boolean rescanExisting) {
        URL activeUrl = this.createSnapshot(foreignSource);
        String url = activeUrl.toString();
        this.debug("importRequisition: Sending import event with URL %s", url);
        EventBuilder bldr = new EventBuilder("uei.opennms.org/internal/importer/reloadImport", "Web");
        bldr.addParam("url", url);
        if (rescanExisting != null) {
            bldr.addParam("importRescanExisting", rescanExisting.booleanValue());
        }
        try {
            this.getEventProxy().send(bldr.getEvent());
        }
        catch (EventProxyException e) {
            throw new DataAccessResourceFailureException("Unable to send event to import group " + foreignSource, (Throwable)e);
        }
    }

    private URL createSnapshot(final String foreignSource) {
        return this.submitAndWait(new Callable<URL>(){

            @Override
            public URL call() throws Exception {
                return RequisitionAccessService.this.getAccessor(foreignSource).createSnapshot();
            }
        });
    }

    public void updateRequisition(final String foreignSource, final MultivaluedMapImpl params) {
        this.submitWriteOp(new Runnable(){

            @Override
            public void run() {
                RequisitionAccessService.this.getAccessor(foreignSource).updateRequisition(params);
            }
        });
    }

    public void updateNode(final String foreignSource, final String foreignId, final MultivaluedMapImpl params) {
        this.submitWriteOp(new Runnable(){

            @Override
            public void run() {
                RequisitionAccessService.this.getAccessor(foreignSource).updateNode(foreignId, params);
            }
        });
    }

    public void updateInterface(final String foreignSource, final String foreignId, final String ipAddress, final MultivaluedMapImpl params) {
        this.submitWriteOp(new Runnable(){

            @Override
            public void run() {
                RequisitionAccessService.this.getAccessor(foreignSource).updateInterface(foreignId, ipAddress, params);
            }
        });
    }

    public void deletePendingRequisition(final String foreignSource) {
        this.submitWriteOp(new Runnable(){

            @Override
            public void run() {
                RequisitionAccessService.this.getAccessor(foreignSource).deletePending();
            }
        });
    }

    public void deleteDeployedRequisition(final String foreignSource) {
        this.submitWriteOp(new Runnable(){

            @Override
            public void run() {
                RequisitionAccessService.this.getAccessor(foreignSource).deleteDeployed();
            }
        });
    }

    public void deleteNode(final String foreignSource, final String foreignId) {
        this.submitWriteOp(new Runnable(){

            @Override
            public void run() {
                RequisitionAccessService.this.getAccessor(foreignSource).deleteNode(foreignId);
            }
        });
    }

    public void deleteInterface(final String foreignSource, final String foreignId, final String ipAddress) {
        this.submitWriteOp(new Runnable(){

            @Override
            public void run() {
                RequisitionAccessService.this.getAccessor(foreignSource).deleteInterface(foreignId, ipAddress);
            }
        });
    }

    public void deleteInterfaceService(final String foreignSource, final String foreignId, final String ipAddress, final String service) {
        this.submitWriteOp(new Runnable(){

            @Override
            public void run() {
                RequisitionAccessService.this.getAccessor(foreignSource).deleteInterfaceService(foreignId, ipAddress, service);
            }
        });
    }

    public void deleteCategory(final String foreignSource, final String foreignId, final String category) {
        this.submitWriteOp(new Runnable(){

            @Override
            public void run() {
                RequisitionAccessService.this.getAccessor(foreignSource).deleteCategory(foreignId, category);
            }
        });
    }

    public void deleteAssetParameter(final String foreignSource, final String foreignId, final String parameter) {
        this.submitWriteOp(new Runnable(){

            @Override
            public void run() {
                RequisitionAccessService.this.getAccessor(foreignSource).deleteAssetParameter(foreignId, parameter);
            }
        });
    }

    void debug(String format, Object ... args) {
        LogUtils.debugf((Object)this, (String)format, (Object[])args);
    }

    void warn(Throwable t, String format, Object ... args) {
        LogUtils.warnf((Object)this, (Throwable)t, (String)format, (Object[])args);
    }

    static class RequisitionAccessor {
        private final String m_foreignSource;
        private final ForeignSourceRepository m_pendingRepo;
        private final ForeignSourceRepository m_deployedRepo;
        private Requisition m_pending = null;

        public RequisitionAccessor(String foreignSource, ForeignSourceRepository pendingRepo, ForeignSourceRepository deployedRepo) {
            this.m_foreignSource = foreignSource;
            this.m_pendingRepo = pendingRepo;
            this.m_deployedRepo = deployedRepo;
            this.m_pending = null;
        }

        public String getForeignSource() {
            return this.m_foreignSource;
        }

        public ForeignSourceRepository getPendingForeignSourceRepository() {
            return this.m_pendingRepo;
        }

        public ForeignSourceRepository getDeployedForeignSourceRepository() {
            return this.m_deployedRepo;
        }

        public void debug(String format, Object ... args) {
            LogUtils.debugf((Object)this, (String)format, (Object[])args);
        }

        public void warn(Throwable t, String format, Object ... args) {
            LogUtils.warnf((Object)this, (Throwable)t, (String)format, (Object[])args);
        }

        public Requisition getActiveRequisition(boolean createIfMissing) {
            if (this.m_pending != null) {
                return this.m_pending;
            }
            Requisition pending = RequisitionFileUtils.getLatestPendingOrSnapshotRequisition((ForeignSourceRepository)this.getPendingForeignSourceRepository(), (String)this.m_foreignSource);
            Requisition deployed = this.getDeployedForeignSourceRepository().getRequisition(this.m_foreignSource);
            if (pending == null && deployed == null && createIfMissing) {
                return new Requisition(this.m_foreignSource);
            }
            if (pending == null) {
                return deployed;
            }
            if (deployed == null) {
                return pending;
            }
            if (deployed.getDate().after(pending.getDate())) {
                return deployed;
            }
            return pending;
        }

        public void save(Requisition requisition) {
            this.m_pending = requisition;
        }

        void addOrReplaceNode(RequisitionNode node) {
            Requisition req = this.getActiveRequisition(true);
            if (req != null) {
                req.updateDateStamp();
                req.putNode(node);
                this.save(req);
            }
        }

        void addOrReplaceInterface(String foreignId, RequisitionInterface iface) {
            RequisitionNode node;
            Requisition req = this.getActiveRequisition(true);
            if (req != null && (node = req.getNode(foreignId)) != null) {
                req.updateDateStamp();
                node.putInterface(iface);
                this.save(req);
            }
        }

        void addOrReplaceService(String foreignId, String ipAddress, RequisitionMonitoredService service) {
            RequisitionInterface iface;
            RequisitionNode node;
            Requisition req = this.getActiveRequisition(true);
            if (req != null && (node = req.getNode(foreignId)) != null && (iface = node.getInterface(ipAddress)) != null) {
                req.updateDateStamp();
                iface.putMonitoredService(service);
                this.save(req);
            }
        }

        void addOrReplaceNodeCategory(String foreignId, RequisitionCategory category) {
            RequisitionNode node;
            Requisition req = this.getActiveRequisition(true);
            if (req != null && (node = req.getNode(foreignId)) != null) {
                req.updateDateStamp();
                node.putCategory(category);
                this.save(req);
            }
        }

        void addOrReplaceNodeAssetParameter(String foreignId, RequisitionAsset asset) {
            RequisitionNode node;
            Requisition req = this.getActiveRequisition(true);
            if (req != null && (node = req.getNode(foreignId)) != null) {
                req.updateDateStamp();
                node.putAsset(asset);
                this.save(req);
            }
        }

        void updateRequisition(MultivaluedMapImpl params) {
            String foreignSource = this.m_foreignSource;
            this.debug("updateRequisition: Updating requisition with foreign source %s", foreignSource);
            if (params.isEmpty()) {
                return;
            }
            Requisition req = this.getActiveRequisition(false);
            if (req != null) {
                req.updateDateStamp();
                RestUtils.setBeanProperties(req, params);
                this.save(req);
                this.debug("updateRequisition: Requisition with foreign source %s updated", foreignSource);
            }
        }

        void updateNode(String foreignId, MultivaluedMapImpl params) {
            RequisitionNode node;
            String foreignSource = this.m_foreignSource;
            this.debug("updateNode: Updating node with foreign source %s and foreign id %s", foreignSource, foreignId);
            if (params.isEmpty()) {
                return;
            }
            Requisition req = this.getActiveRequisition(false);
            if (req != null && (node = req.getNode(foreignId)) != null) {
                req.updateDateStamp();
                RestUtils.setBeanProperties(node, params);
                this.save(req);
                this.debug("updateNode: Node with foreign source %s and foreign id %s updated", foreignSource, foreignId);
            }
        }

        void updateInterface(String foreignId, String ipAddress, MultivaluedMapImpl params) {
            RequisitionInterface iface;
            RequisitionNode node;
            String foreignSource = this.m_foreignSource;
            this.debug("updateInterface: Updating interface %s on node %s/%s", ipAddress, foreignSource, foreignId);
            if (params.isEmpty()) {
                return;
            }
            Requisition req = this.getActiveRequisition(false);
            if (req != null && (node = req.getNode(foreignId)) != null && (iface = node.getInterface(ipAddress)) != null) {
                req.updateDateStamp();
                RestUtils.setBeanProperties(iface, params);
                this.save(req);
                this.debug("updateInterface: Interface %s on node %s/%s updated", ipAddress, foreignSource, foreignId);
            }
        }

        void deletePending() {
            this.debug("deletePendingRequisition: deleting pending requisition with foreign source %s", this.getForeignSource());
            Requisition req = this.getActiveRequisition(false);
            this.getPendingForeignSourceRepository().delete(req);
        }

        void deleteDeployed() {
            this.debug("deleteDeployedRequisition: deleting pending requisition with foreign source %s", this.getForeignSource());
            Requisition req = this.getActiveRequisition(false);
            this.getDeployedForeignSourceRepository().delete(req);
        }

        void deleteNode(String foreignId) {
            this.debug("deleteNode: Deleting node %s from foreign source %s", foreignId, this.getForeignSource());
            Requisition req = this.getActiveRequisition(false);
            if (req != null) {
                req.updateDateStamp();
                req.deleteNode(foreignId);
                this.save(req);
            }
        }

        void deleteInterface(String foreignId, String ipAddress) {
            RequisitionNode node;
            this.debug("deleteInterface: Deleting interface %s from node %s/%s", ipAddress, this.getForeignSource(), foreignId);
            Requisition req = this.getActiveRequisition(false);
            if (req != null && (node = req.getNode(foreignId)) != null) {
                req.updateDateStamp();
                node.deleteInterface(ipAddress);
                this.save(req);
            }
        }

        void deleteInterfaceService(String foreignId, String ipAddress, String service) {
            RequisitionInterface iface;
            RequisitionNode node;
            this.debug("deleteInterfaceService: Deleting service %s from interface %s on node %s/%s", service, ipAddress, this.getForeignSource(), foreignId);
            Requisition req = this.getActiveRequisition(false);
            if (req != null && (node = req.getNode(foreignId)) != null && (iface = node.getInterface(ipAddress)) != null) {
                req.updateDateStamp();
                iface.deleteMonitoredService(service);
                this.save(req);
            }
        }

        void deleteCategory(String foreignId, String category) {
            RequisitionNode node;
            this.debug("deleteCategory: Deleting category %s from node %s/%s", category, this.getForeignSource(), foreignId);
            Requisition req = this.getActiveRequisition(false);
            if (req != null && (node = req.getNode(foreignId)) != null) {
                req.updateDateStamp();
                node.deleteCategory(category);
                this.save(req);
            }
        }

        void deleteAssetParameter(String foreignId, String parameter) {
            RequisitionNode node;
            this.debug("deleteAssetParameter: Deleting asset parameter %s from node %s/%s", parameter, this.getForeignSource(), foreignId);
            Requisition req = this.getActiveRequisition(false);
            if (req != null && (node = req.getNode(foreignId)) != null) {
                req.updateDateStamp();
                node.deleteAsset(parameter);
                this.save(req);
            }
        }

        RequisitionAsset getAssetParameter(String foreignId, String parameter) {
            this.flush();
            Requisition req = this.getActiveRequisition(false);
            RequisitionNode node = req == null ? null : req.getNode(foreignId);
            return node == null ? null : node.getAsset(parameter);
        }

        RequisitionAssetCollection getAssetParameters(String foreignId) {
            this.flush();
            Requisition req = this.getActiveRequisition(false);
            RequisitionNode node = req == null ? null : req.getNode(foreignId);
            return node == null ? null : new RequisitionAssetCollection((Collection)node.getAssets());
        }

        RequisitionCategory getCategory(String foreignId, String category) {
            this.flush();
            Requisition req = this.getActiveRequisition(false);
            RequisitionNode node = req == null ? null : req.getNode(foreignId);
            return node == null ? null : node.getCategory(category);
        }

        RequisitionCategoryCollection getCategories(String foreignId) {
            this.flush();
            Requisition req = this.getActiveRequisition(false);
            RequisitionNode node = req == null ? null : req.getNode(foreignId);
            return node == null ? null : new RequisitionCategoryCollection((Collection)node.getCategories());
        }

        RequisitionInterface getInterfaceForNode(String foreignId, String ipAddress) {
            this.flush();
            Requisition req = this.getActiveRequisition(false);
            RequisitionNode node = req == null ? null : req.getNode(foreignId);
            return node == null ? null : node.getInterface(ipAddress);
        }

        RequisitionInterfaceCollection getInterfacesForNode(String foreignId) {
            this.flush();
            Requisition req = this.getActiveRequisition(false);
            RequisitionNode node = req == null ? null : req.getNode(foreignId);
            return node == null ? null : new RequisitionInterfaceCollection((Collection)node.getInterfaces());
        }

        RequisitionNode getNode(String foreignId) {
            this.flush();
            Requisition req = this.getActiveRequisition(false);
            return req == null ? null : req.getNode(foreignId);
        }

        RequisitionNodeCollection getNodes() {
            this.flush();
            Requisition req = this.getActiveRequisition(false);
            return req == null ? null : new RequisitionNodeCollection((Collection)req.getNodes());
        }

        Requisition getRequisition() {
            this.flush();
            return this.getActiveRequisition(false);
        }

        RequisitionMonitoredService getServiceForInterface(String foreignId, String ipAddress, String service) {
            this.flush();
            Requisition req = this.getActiveRequisition(false);
            RequisitionNode node = req == null ? null : req.getNode(foreignId);
            RequisitionInterface iface = node == null ? null : node.getInterface(ipAddress);
            return iface == null ? null : iface.getMonitoredService(service);
        }

        RequisitionMonitoredServiceCollection getServicesForInterface(String foreignId, String ipAddress) {
            this.flush();
            Requisition req = this.getActiveRequisition(false);
            RequisitionNode node = req == null ? null : req.getNode(foreignId);
            RequisitionInterface iface = node == null ? null : node.getInterface(ipAddress);
            return iface == null ? null : new RequisitionMonitoredServiceCollection((Collection)iface.getMonitoredServices());
        }

        URL createSnapshot() throws MalformedURLException {
            this.flush();
            Requisition pending = this.getPendingForeignSourceRepository().getRequisition(this.getForeignSource());
            Requisition deployed = this.getDeployedForeignSourceRepository().getRequisition(this.getForeignSource());
            URL activeUrl = pending == null || deployed != null && deployed.getDateStamp().compare(pending.getDateStamp()) > -1 ? this.getDeployedForeignSourceRepository().getRequisitionURL(this.getForeignSource()) : RequisitionFileUtils.createSnapshot((ForeignSourceRepository)this.getPendingForeignSourceRepository(), (String)this.getForeignSource(), (Date)pending.getDate()).toURI().toURL();
            return activeUrl;
        }

        private void flush() {
            if (this.m_pending != null) {
                this.getPendingForeignSourceRepository().save(this.m_pending);
                this.m_pending = null;
            }
            this.getPendingForeignSourceRepository().flush();
            this.getDeployedForeignSourceRepository().flush();
        }
    }
}

