/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.rest;

import com.sun.jersey.spi.resource.PerRequest;
import java.net.URI;
import java.util.Collection;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.opennms.netmgt.dao.CategoryDao;
import org.opennms.netmgt.dao.NodeDao;
import org.opennms.netmgt.model.OnmsCategory;
import org.opennms.netmgt.model.OnmsCategoryCollection;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.web.rest.MultivaluedMapImpl;
import org.opennms.web.rest.OnmsRestService;
import org.springframework.beans.BeanWrapper;
import org.springframework.beans.PropertyAccessorFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
@PerRequest
@Scope(value="prototype")
@Path(value="categories")
@Transactional
public class OnmsCategoryResource
extends OnmsRestService {
    @Context
    UriInfo m_uriInfo;
    @Autowired
    private NodeDao m_nodeDao;
    @Autowired
    private CategoryDao m_categoryDao;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GET
    @Produces(value={"application/xml", "application/json"})
    public OnmsCategoryCollection getCategories(@PathParam(value="nodeCriteria") String nodeCriteria) {
        this.readLock();
        try {
            OnmsNode node = this.m_nodeDao.get(nodeCriteria);
            if (node == null) {
                throw this.getException(Response.Status.BAD_REQUEST, "getCategories: Can't find node " + nodeCriteria);
            }
            OnmsCategoryCollection onmsCategoryCollection = new OnmsCategoryCollection((Collection)node.getCategories());
            return onmsCategoryCollection;
        }
        finally {
            this.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GET
    @Produces(value={"application/xml", "application/json"})
    @Path(value="{categoryName}")
    public OnmsCategory getCategory(@PathParam(value="nodeCriteria") String nodeCriteria, @PathParam(value="categoryName") String categoryName) {
        this.readLock();
        try {
            OnmsNode node = this.m_nodeDao.get(nodeCriteria);
            if (node == null) {
                throw this.getException(Response.Status.BAD_REQUEST, "getCategory: Can't find node " + nodeCriteria);
            }
            OnmsCategory onmsCategory = this.getCategory(node, categoryName);
            return onmsCategory;
        }
        finally {
            this.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    @Consumes(value={"application/xml"})
    public Response addCategory(@PathParam(value="nodeCriteria") String nodeCriteria, OnmsCategory category) {
        this.writeLock();
        try {
            OnmsNode node = this.m_nodeDao.get(nodeCriteria);
            if (node == null) {
                throw this.getException(Response.Status.BAD_REQUEST, "addCategory: Can't find node " + nodeCriteria);
            }
            OnmsCategory found = this.m_categoryDao.findByName(category.getName());
            if (found == null) {
                this.log().debug("addCategory: Saving category " + category);
                this.m_categoryDao.save((Object)category);
            } else {
                category = found;
            }
            this.log().debug("addCategory: Adding category " + category + " to node " + nodeCriteria);
            node.addCategory(category);
            this.m_nodeDao.save((Object)node);
            Response response = Response.seeOther((URI)OnmsCategoryResource.getRedirectUri(this.m_uriInfo, category.getName())).build();
            return response;
        }
        finally {
            this.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PUT
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Path(value="{categoryName}")
    public Response updateCategory(@PathParam(value="nodeCriteria") String nodeCriteria, @PathParam(value="categoryName") String categoryName, MultivaluedMapImpl params) {
        this.writeLock();
        try {
            OnmsNode node = this.m_nodeDao.get(nodeCriteria);
            if (node == null) {
                throw this.getException(Response.Status.BAD_REQUEST, "updateCategory: Can't find node " + nodeCriteria);
            }
            OnmsCategory category = this.getCategory(node, categoryName);
            if (category == null) {
                throw this.getException(Response.Status.BAD_REQUEST, "updateCategory: Category " + categoryName + " not found on node " + nodeCriteria);
            }
            this.log().debug("updateCategory: updating category " + category);
            BeanWrapper wrapper = PropertyAccessorFactory.forBeanPropertyAccess((Object)category);
            for (String key : params.keySet()) {
                if (!wrapper.isWritableProperty(key)) continue;
                String stringValue = params.getFirst(key);
                Object value = wrapper.convertIfNecessary((Object)stringValue, wrapper.getPropertyType(key));
                wrapper.setPropertyValue(key, value);
            }
            this.log().debug("updateCategory: category " + category + " updated");
            this.m_nodeDao.saveOrUpdate((Object)node);
            Response response = Response.seeOther((URI)OnmsCategoryResource.getRedirectUri(this.m_uriInfo, new Object[0])).build();
            return response;
        }
        finally {
            this.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @DELETE
    @Path(value="{categoryName}")
    public Response deleteCaegory(@PathParam(value="nodeCriteria") String nodeCriteria, @PathParam(value="categoryName") String categoryName) {
        this.writeLock();
        try {
            OnmsNode node = this.m_nodeDao.get(nodeCriteria);
            if (node == null) {
                throw this.getException(Response.Status.BAD_REQUEST, "deleteCaegory: Can't find node " + nodeCriteria);
            }
            OnmsCategory category = this.getCategory(node, categoryName);
            if (category == null) {
                throw this.getException(Response.Status.BAD_REQUEST, "deleteCaegory: Category " + categoryName + " not found on node " + nodeCriteria);
            }
            this.log().debug("deleteCaegory: deleting category " + categoryName + " from node " + nodeCriteria);
            node.getCategories().remove(category);
            this.m_nodeDao.saveOrUpdate((Object)node);
            Response response = Response.ok().build();
            return response;
        }
        finally {
            this.writeUnlock();
        }
    }

    private OnmsCategory getCategory(OnmsNode node, String categoryName) {
        for (OnmsCategory category : node.getCategories()) {
            if (!category.getName().equals(categoryName)) continue;
            return category;
        }
        return null;
    }
}

