/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.rest;

import com.sun.jersey.spi.resource.PerRequest;
import java.io.Serializable;
import java.net.URI;
import java.text.ParseException;
import java.util.Collection;
import java.util.Date;
import javax.ws.rs.Consumes;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.core.UriInfo;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;
import org.opennms.core.criteria.CriteriaBuilder;
import org.opennms.netmgt.dao.EventDao;
import org.opennms.netmgt.model.OnmsEvent;
import org.opennms.netmgt.model.OnmsEventCollection;
import org.opennms.web.rest.MultivaluedMapImpl;
import org.opennms.web.rest.OnmsRestService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
@PerRequest
@Scope(value="prototype")
@Path(value="events")
public class EventRestService
extends OnmsRestService {
    private static final DateTimeFormatter ISO8601_FORMATTER_MILLIS = ISODateTimeFormat.dateTime();
    private static final DateTimeFormatter ISO8601_FORMATTER = ISODateTimeFormat.dateTimeNoMillis();
    @Autowired
    private EventDao m_eventDao;
    @Context
    UriInfo m_uriInfo;
    @Context
    HttpHeaders m_headers;
    @Context
    SecurityContext m_securityContext;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GET
    @Produces(value={"application/xml", "application/json", "application/atom+xml"})
    @Path(value="{eventId}")
    @Transactional
    public OnmsEvent getEvent(@PathParam(value="eventId") String eventId) {
        this.readLock();
        try {
            OnmsEvent onmsEvent = (OnmsEvent)this.m_eventDao.get((Serializable)new Integer(eventId));
            return onmsEvent;
        }
        finally {
            this.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GET
    @Produces(value={"text/plain"})
    @Path(value="count")
    @Transactional
    public String getCount() {
        this.readLock();
        try {
            String string = Integer.toString(this.m_eventDao.countAll());
            return string;
        }
        finally {
            this.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GET
    @Produces(value={"application/xml", "application/json", "application/atom+xml"})
    @Transactional
    public OnmsEventCollection getEvents() throws ParseException {
        this.readLock();
        try {
            CriteriaBuilder builder = new CriteriaBuilder(OnmsEvent.class);
            this.applyQueryFilters((MultivaluedMap<String, String>)this.m_uriInfo.getQueryParameters(), builder);
            builder.orderBy("eventTime").asc();
            OnmsEventCollection coll = new OnmsEventCollection((Collection)this.m_eventDao.findMatching(builder.toCriteria()));
            coll.setTotalCount(this.m_eventDao.countMatching(builder.clearOrder().toCriteria()));
            OnmsEventCollection onmsEventCollection = coll;
            return onmsEventCollection;
        }
        finally {
            this.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GET
    @Produces(value={"application/xml", "application/json", "application/atom+xml"})
    @Path(value="between")
    @Transactional
    public OnmsEventCollection getEventsBetween() throws ParseException {
        this.readLock();
        try {
            Date end;
            Date begin;
            String column;
            CriteriaBuilder builder = new CriteriaBuilder(OnmsEvent.class);
            MultivaluedMap params = this.m_uriInfo.getQueryParameters();
            if (params.containsKey((Object)"column")) {
                column = (String)params.getFirst((Object)"column");
                params.remove((Object)"column");
            } else {
                column = "eventTime";
            }
            if (params.containsKey((Object)"begin")) {
                try {
                    begin = ISO8601_FORMATTER.parseLocalDateTime((String)params.getFirst((Object)"begin")).toDate();
                }
                catch (Throwable t) {
                    begin = ISO8601_FORMATTER_MILLIS.parseDateTime((String)params.getFirst((Object)"begin")).toDate();
                }
                params.remove((Object)"begin");
            } else {
                begin = new Date(0L);
            }
            if (params.containsKey((Object)"end")) {
                try {
                    end = ISO8601_FORMATTER.parseLocalDateTime((String)params.getFirst((Object)"end")).toDate();
                }
                catch (Throwable t) {
                    end = ISO8601_FORMATTER_MILLIS.parseLocalDateTime((String)params.getFirst((Object)"end")).toDate();
                }
                params.remove((Object)"end");
            } else {
                end = new Date();
            }
            this.applyQueryFilters((MultivaluedMap<String, String>)params, builder);
            builder.match("all");
            try {
                builder.between(column, (Object)begin, (Object)end);
            }
            catch (Throwable t) {
                throw new IllegalArgumentException("Unable to parse " + begin + " and " + end + " as dates!");
            }
            OnmsEventCollection coll = new OnmsEventCollection((Collection)this.m_eventDao.findMatching(builder.toCriteria()));
            coll.setTotalCount(this.m_eventDao.countMatching(builder.clearOrder().toCriteria()));
            OnmsEventCollection onmsEventCollection = coll;
            return onmsEventCollection;
        }
        finally {
            this.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PUT
    @Path(value="{eventId}")
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Transactional
    public Response updateEvent(@PathParam(value="eventId") String eventId, @FormParam(value="ack") Boolean ack) {
        this.writeLock();
        try {
            OnmsEvent event = (OnmsEvent)this.m_eventDao.get((Serializable)new Integer(eventId));
            if (ack == null) {
                throw new IllegalArgumentException("Must supply the 'ack' parameter, set to either 'true' or 'false'");
            }
            this.processEventAck(event, ack);
            Response response = Response.seeOther((URI)EventRestService.getRedirectUri(this.m_uriInfo, new Object[0])).build();
            return response;
        }
        finally {
            this.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PUT
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Transactional
    public Response updateEvents(MultivaluedMapImpl formProperties) {
        this.writeLock();
        try {
            Boolean ack = false;
            if (formProperties.containsKey("ack")) {
                ack = "true".equals(formProperties.getFirst("ack"));
                formProperties.remove("ack");
            }
            CriteriaBuilder builder = new CriteriaBuilder(OnmsEvent.class);
            this.applyQueryFilters(formProperties, builder);
            builder.orderBy("eventTime").desc();
            for (OnmsEvent event : this.m_eventDao.findMatching(builder.toCriteria())) {
                this.processEventAck(event, ack);
            }
            Response response = Response.seeOther((URI)EventRestService.getRedirectUri(this.m_uriInfo, new Object[0])).build();
            return response;
        }
        finally {
            this.writeUnlock();
        }
    }

    private void processEventAck(OnmsEvent event, Boolean ack) {
        if (ack.booleanValue()) {
            event.setEventAckTime(new Date());
            event.setEventAckUser(this.m_securityContext.getUserPrincipal().getName());
        } else {
            event.setEventAckTime(null);
            event.setEventAckUser(null);
        }
        this.m_eventDao.save((Object)event);
    }
}

