/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.outage;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import javax.servlet.ServletContext;
import org.opennms.core.resource.Vault;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.web.filter.Filter;
import org.opennms.web.outage.Outage;
import org.opennms.web.outage.OutageType;
import org.opennms.web.outage.SortStyle;
import org.opennms.web.outage.filter.InterfaceFilter;
import org.opennms.web.outage.filter.NodeFilter;
import org.opennms.web.outage.filter.ServiceFilter;

public class OutageFactory {
    protected static final ThreadCategory log = ThreadCategory.getInstance((String)"OutageFactory");

    private OutageFactory() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getOutageCount() throws SQLException {
        int outageCount = 0;
        Connection conn = Vault.getDbConnection();
        try {
            Statement stmt = conn.createStatement();
            ResultSet rs = stmt.executeQuery("SELECT COUNT(OUTAGEID) AS OUTAGECOUNT FROM OUTAGES JOIN NODE USING(NODEID) JOIN IPINTERFACE ON OUTAGES.NODEID=IPINTERFACE.NODEID AND OUTAGES.IPADDR=IPINTERFACE.IPADDR JOIN IFSERVICES ON OUTAGES.NODEID=IFSERVICES.NODEID AND OUTAGES.IPADDR=IFSERVICES.IPADDR AND OUTAGES.SERVICEID=IFSERVICES.SERVICEID WHERE IFREGAINEDSERVICE IS NULL AND (NODE.NODETYPE != 'D' AND IPINTERFACE.ISMANAGED != 'D' AND IFSERVICES.STATUS != 'D') ");
            if (rs.next()) {
                outageCount = rs.getInt("OUTAGECOUNT");
            }
            rs.close();
            stmt.close();
        }
        finally {
            Vault.releaseDbConnection((Connection)conn);
        }
        return outageCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getOutageCount(OutageType outageType, Filter[] filters) throws SQLException {
        if (outageType == null || filters == null) {
            throw new IllegalArgumentException("Cannot take null parameters.");
        }
        int outageCount = 0;
        Connection conn = Vault.getDbConnection();
        try {
            StringBuffer select = new StringBuffer("SELECT COUNT(OUTAGEID) AS OUTAGECOUNT FROM OUTAGES JOIN NODE USING(NODEID) JOIN IPINTERFACE ON OUTAGES.NODEID=IPINTERFACE.NODEID AND OUTAGES.IPADDR=IPINTERFACE.IPADDR JOIN IFSERVICES ON OUTAGES.NODEID=IFSERVICES.NODEID AND OUTAGES.IPADDR=IFSERVICES.IPADDR AND OUTAGES.SERVICEID=IFSERVICES.SERVICEID LEFT OUTER JOIN SERVICE ON OUTAGES.SERVICEID=SERVICE.SERVICEID LEFT OUTER JOIN NOTIFICATIONS ON SVCLOSTEVENTID=NOTIFICATIONS.NOTIFYID WHERE (NODE.NODETYPE != 'D' AND IPINTERFACE.ISMANAGED != 'D' AND IFSERVICES.STATUS != 'D') AND ");
            select.append(outageType.getClause());
            for (Filter filter : filters) {
                select.append(" AND ");
                select.append(filter.getParamSql());
            }
            PreparedStatement stmt = conn.prepareStatement(select.toString());
            int parameterIndex = 1;
            for (Filter filter : filters) {
                parameterIndex += filter.bindParam(stmt, parameterIndex);
            }
            ResultSet rs = stmt.executeQuery();
            if (rs.next()) {
                outageCount = rs.getInt("OUTAGECOUNT");
            }
            rs.close();
            stmt.close();
        }
        finally {
            Vault.releaseDbConnection((Connection)conn);
        }
        return outageCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Outage getOutage(int outageId) throws SQLException {
        Outage outage = null;
        Connection conn = Vault.getDbConnection();
        try {
            PreparedStatement stmt = conn.prepareStatement("SELECT OUTAGES.*, NODE.NODELABEL, IPINTERFACE.IPHOSTNAME, SERVICE.SERVICENAME, NOTIFICATIONS.NOTIFYID, NOTIFICATIONS.ANSWEREDBY FROM OUTAGES JOIN NODE USING(NODEID) JOIN IPINTERFACE ON OUTAGES.NODEID=IPINTERFACE.NODEID AND OUTAGES.IPADDR=IPINTERFACE.IPADDR LEFT OUTER JOIN SERVICE USING(SERVICEID) LEFT OUTER JOIN NOTIFICATIONS ON SVCLOSTEVENTID=NOTIFICATIONS.EVENTID WHERE OUTAGEID=?");
            stmt.setInt(1, outageId);
            ResultSet rs = stmt.executeQuery();
            Outage[] outages = OutageFactory.rs2Outages(rs);
            if (outages != null && outages.length > 0) {
                outage = outages[0];
            }
            rs.close();
            stmt.close();
        }
        finally {
            Vault.releaseDbConnection((Connection)conn);
        }
        return outage;
    }

    public static Outage[] getOutages() throws SQLException {
        return OutageFactory.getOutages(SortStyle.DEFAULT_SORT_STYLE, OutageType.CURRENT, new Filter[0], -1, -1);
    }

    public static Outage[] getOutages(SortStyle sortStyle) throws SQLException {
        return OutageFactory.getOutages(sortStyle, OutageType.CURRENT, new Filter[0], -1, -1);
    }

    public static Outage[] getOutages(SortStyle sortStyle, OutageType outType) throws SQLException {
        return OutageFactory.getOutages(sortStyle, outType, new Filter[0], -1, -1);
    }

    public static Outage[] getOutages(SortStyle sortStyle, OutageType outType, Filter[] filters) throws SQLException {
        return OutageFactory.getOutages(sortStyle, outType, filters, -1, -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Outage[] getOutages(SortStyle sortStyle, OutageType outType, Filter[] filters, int limit, int offset) throws SQLException {
        if (sortStyle == null || outType == null || filters == null) {
            throw new IllegalArgumentException("Cannot take null parameters.");
        }
        boolean useLimits = false;
        if (limit > 0 && offset > -1) {
            useLimits = true;
        }
        Outage[] outages = null;
        Connection conn = Vault.getDbConnection();
        try {
            StringBuffer select = new StringBuffer("SELECT OUTAGES.*, NODE.NODELABEL, IPINTERFACE.IPHOSTNAME, SERVICE.SERVICENAME, NOTIFICATIONS.NOTIFYID, NOTIFICATIONS.ANSWEREDBY FROM OUTAGES JOIN NODE USING(NODEID) JOIN IPINTERFACE ON OUTAGES.NODEID=IPINTERFACE.NODEID AND OUTAGES.IPADDR=IPINTERFACE.IPADDR JOIN IFSERVICES ON OUTAGES.NODEID=IFSERVICES.NODEID AND OUTAGES.IPADDR=IFSERVICES.IPADDR AND OUTAGES.SERVICEID=IFSERVICES.SERVICEID LEFT OUTER JOIN SERVICE ON OUTAGES.SERVICEID=SERVICE.SERVICEID LEFT OUTER JOIN NOTIFICATIONS ON SVCLOSTEVENTID=NOTIFICATIONS.EVENTID WHERE (NODE.NODETYPE != 'D' AND IPINTERFACE.ISMANAGED != 'D' AND IFSERVICES.STATUS != 'D') AND ");
            select.append(outType.getClause());
            for (Filter filter : filters) {
                select.append(" AND ");
                select.append(filter.getParamSql());
            }
            select.append(sortStyle.getOrderByClause());
            if (useLimits) {
                select.append(" LIMIT ");
                select.append(limit);
                select.append(" OFFSET ");
                select.append(offset);
            }
            log.debug(select.toString());
            PreparedStatement stmt = conn.prepareStatement(select.toString());
            int parameterIndex = 1;
            for (Filter filter : filters) {
                parameterIndex += filter.bindParam(stmt, parameterIndex);
            }
            ResultSet rs = stmt.executeQuery();
            outages = OutageFactory.rs2Outages(rs);
            rs.close();
            stmt.close();
        }
        finally {
            Vault.releaseDbConnection((Connection)conn);
        }
        return outages;
    }

    public static Outage[] getOutagesForNode(int nodeId, ServletContext servletContext) throws SQLException {
        return OutageFactory.getOutagesForNode(nodeId, SortStyle.DEFAULT_SORT_STYLE, OutageType.CURRENT, servletContext);
    }

    public static Outage[] getOutagesForNode(int nodeId, SortStyle sortStyle, OutageType outType, ServletContext servletContext) throws SQLException {
        if (sortStyle == null || outType == null) {
            throw new IllegalArgumentException("Cannot take null parameters.");
        }
        Filter[] filters = new Filter[]{new NodeFilter(nodeId, servletContext)};
        return OutageFactory.getOutages(sortStyle, outType, filters);
    }

    public static Outage[] getOutagesForInterface(int nodeId, String ipAddress, ServletContext servletContext) throws SQLException {
        return OutageFactory.getOutagesForInterface(nodeId, ipAddress, SortStyle.DEFAULT_SORT_STYLE, OutageType.CURRENT, servletContext);
    }

    public static Outage[] getOutagesForInterface(int nodeId, String ipAddress, SortStyle sortStyle, OutageType outType, ServletContext servletContext) throws SQLException {
        if (ipAddress == null || sortStyle == null || outType == null) {
            throw new IllegalArgumentException("Cannot take null parameters.");
        }
        Filter[] filters = new Filter[]{new NodeFilter(nodeId, servletContext), new InterfaceFilter(ipAddress)};
        return OutageFactory.getOutages(sortStyle, outType, filters);
    }

    public static Outage[] getOutagesForInterface(int nodeId, String ipAddress, boolean includeResolved, ServletContext servletContext) throws SQLException {
        if (ipAddress == null) {
            throw new IllegalArgumentException("Cannot take null parameters.");
        }
        OutageType outageType = includeResolved ? OutageType.BOTH : OutageType.CURRENT;
        Outage[] outages = OutageFactory.getOutagesForInterface(nodeId, ipAddress, SortStyle.DEFAULT_SORT_STYLE, outageType, servletContext);
        return outages;
    }

    public static Outage[] getOutagesForInterface(String ipAddress) throws SQLException {
        return OutageFactory.getOutagesForInterface(ipAddress, SortStyle.DEFAULT_SORT_STYLE, OutageType.CURRENT);
    }

    public static Outage[] getOutagesForInterface(String ipAddress, SortStyle sortStyle, OutageType outType) throws SQLException {
        if (ipAddress == null || sortStyle == null || outType == null) {
            throw new IllegalArgumentException("Cannot take null parameters.");
        }
        Filter[] filters = new Filter[]{new InterfaceFilter(ipAddress)};
        return OutageFactory.getOutages(sortStyle, outType, filters);
    }

    public static Outage[] getOutagesForInterface(String ipAddress, boolean includeResolved) throws SQLException {
        if (ipAddress == null) {
            throw new IllegalArgumentException("Cannot take null parameters.");
        }
        OutageType outageType = includeResolved ? OutageType.BOTH : OutageType.CURRENT;
        Outage[] outages = OutageFactory.getOutagesForInterface(ipAddress, SortStyle.DEFAULT_SORT_STYLE, outageType);
        return outages;
    }

    public static Outage[] getOutagesForService(int nodeId, String ipAddress, int serviceId, ServletContext servletContext) throws SQLException {
        return OutageFactory.getOutagesForService(nodeId, ipAddress, serviceId, SortStyle.DEFAULT_SORT_STYLE, OutageType.CURRENT, servletContext);
    }

    public static Outage[] getOutagesForService(int nodeId, String ipAddress, int serviceId, SortStyle sortStyle, OutageType outType, ServletContext servletContext) throws SQLException {
        if (ipAddress == null || sortStyle == null || outType == null) {
            throw new IllegalArgumentException("Cannot take null parameters.");
        }
        Filter[] filters = new Filter[]{new NodeFilter(nodeId, servletContext), new InterfaceFilter(ipAddress), new ServiceFilter(serviceId)};
        return OutageFactory.getOutages(sortStyle, outType, filters);
    }

    public static Outage[] getOutagesForService(int nodeId, String ipAddress, int serviceId, boolean includeResolved, ServletContext servletContext) throws SQLException {
        if (ipAddress == null) {
            throw new IllegalArgumentException("Cannot take null parameters.");
        }
        OutageType outageType = includeResolved ? OutageType.BOTH : OutageType.CURRENT;
        Outage[] outages = OutageFactory.getOutagesForService(nodeId, ipAddress, serviceId, SortStyle.DEFAULT_SORT_STYLE, outageType, servletContext);
        return outages;
    }

    public static Outage[] getOutagesForService(int serviceId) throws SQLException {
        return OutageFactory.getOutagesForService(serviceId, SortStyle.DEFAULT_SORT_STYLE, OutageType.CURRENT);
    }

    public static Outage[] getOutagesForService(int serviceId, SortStyle sortStyle, OutageType outType) throws SQLException {
        if (sortStyle == null || outType == null) {
            throw new IllegalArgumentException("Cannot take null parameters.");
        }
        Filter[] filters = new Filter[]{new ServiceFilter(serviceId)};
        return OutageFactory.getOutages(sortStyle, outType, filters);
    }

    public static Outage[] getOutagesForService(int serviceId, boolean includeResolved) throws SQLException {
        OutageType outageType = includeResolved ? OutageType.BOTH : OutageType.CURRENT;
        Outage[] outages = OutageFactory.getOutagesForService(serviceId, SortStyle.DEFAULT_SORT_STYLE, outageType);
        return outages;
    }

    protected static Outage[] rs2Outages(ResultSet rs) throws SQLException {
        Outage[] outages = null;
        ArrayList<Outage> list = new ArrayList<Outage>();
        while (rs.next()) {
            Outage outage = new Outage();
            Timestamp element = null;
            int intElement = -1;
            outage.outageId = rs.getInt("outageid");
            outage.nodeId = rs.getInt("nodeid");
            outage.ipAddress = rs.getString("ipaddr");
            outage.serviceId = rs.getInt("serviceid");
            element = rs.getTimestamp("iflostservice");
            outage.lostServiceTime = new Date(element.getTime());
            outage.hostname = rs.getString("iphostname");
            outage.nodeLabel = rs.getString("nodelabel");
            outage.serviceName = rs.getString("servicename");
            element = rs.getTimestamp("ifregainedservice");
            if (element != null) {
                outage.regainedServiceTime = new Date(element.getTime());
            }
            intElement = rs.getInt("svcLostEventID");
            if (!rs.wasNull()) {
                outage.lostServiceEventId = intElement;
            }
            intElement = rs.getInt("svcRegainedEventID");
            if (!rs.wasNull()) {
                outage.regainedServiceEventId = intElement;
            }
            intElement = rs.getInt("notifyid");
            if (!rs.wasNull()) {
                outage.lostServiceNotificationId = intElement;
            }
            outage.lostServiceNotificationAcknowledgedBy = rs.getString("answeredby");
            list.add(outage);
        }
        outages = list.toArray(new Outage[list.size()]);
        return outages;
    }
}

