/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.nodelabel;

import java.io.IOException;
import java.io.Serializable;
import java.sql.SQLException;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.opennms.core.utils.WebSecurityUtils;
import org.opennms.netmgt.dao.NodeDao;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.model.events.EventBuilder;
import org.opennms.netmgt.model.events.EventProxy;
import org.opennms.netmgt.model.events.EventProxyException;
import org.opennms.netmgt.utils.NodeLabel;
import org.opennms.web.api.Util;
import org.opennms.web.element.NetworkElementFactory;
import org.opennms.web.rest.MultivaluedMapImpl;
import org.opennms.web.rest.RequisitionRestService;
import org.opennms.web.servlet.MissingParameterException;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionTemplate;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class NodeLabelChangeServlet
extends HttpServlet {
    private static final long serialVersionUID = -7766362068448931124L;
    protected EventProxy proxy;

    public void init() throws ServletException {
        try {
            this.proxy = Util.createEventProxy();
        }
        catch (Throwable e) {
            throw new ServletException("JMS Exception", e);
        }
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String nodeIdString = request.getParameter("node");
        String labelType = request.getParameter("labeltype");
        String userLabel = request.getParameter("userlabel");
        if (nodeIdString == null) {
            throw new MissingParameterException("node", new String[]{"node", "labeltype", "userlabel"});
        }
        if (labelType == null) {
            throw new MissingParameterException("labeltype", new String[]{"node", "labeltype", "userlabel"});
        }
        if (userLabel == null) {
            throw new MissingParameterException("userlabel", new String[]{"node", "labeltype", "userlabel"});
        }
        try {
            final int nodeId = WebSecurityUtils.safeParseInt((String)nodeIdString);
            OnmsNode node = NetworkElementFactory.getInstance(this.getServletContext()).getNode(nodeId);
            NodeLabel oldLabel = new NodeLabel(node.getLabel(), node.getLabelSource());
            NodeLabel newLabel = null;
            if (labelType.equals("auto")) {
                newLabel = NodeLabel.computeLabel((int)nodeId);
            } else if (labelType.equals("user")) {
                newLabel = new NodeLabel(userLabel, 'U');
            } else {
                throw new ServletException("Unexpected labeltype value: " + labelType);
            }
            WebApplicationContext beanFactory = WebApplicationContextUtils.getWebApplicationContext((ServletContext)this.getServletContext());
            TransactionTemplate transactionTemplate = (TransactionTemplate)beanFactory.getBean(TransactionTemplate.class);
            final RequisitionRestService requisitionService = (RequisitionRestService)beanFactory.getBean(RequisitionRestService.class);
            final NodeDao nodeDao = (NodeDao)beanFactory.getBean(NodeDao.class);
            final String newNodeLabel = newLabel.getLabel();
            String foreignSource = (String)transactionTemplate.execute((TransactionCallback)new TransactionCallback<String>(){

                public String doInTransaction(TransactionStatus status) {
                    OnmsNode node = (OnmsNode)nodeDao.get((Serializable)Integer.valueOf(nodeId));
                    if (node.getForeignSource() != null && node.getForeignId() != null) {
                        MultivaluedMapImpl params = new MultivaluedMapImpl();
                        params.putSingle("node-label", newNodeLabel);
                        requisitionService.updateNode(node.getForeignSource(), node.getForeignId(), params);
                        return node.getForeignSource();
                    }
                    return null;
                }
            });
            this.sendLabelChangeEvent(nodeId, oldLabel, newLabel);
            if (foreignSource != null) {
                response.sendRedirect(Util.calculateUrlBase((HttpServletRequest)request, (String)("admin/nodelabelProvisioned.jsp?node=" + nodeIdString + "&foreignSource=" + foreignSource)));
            } else {
                NodeLabel.assignLabel((int)nodeId, (NodeLabel)newLabel);
                response.sendRedirect(Util.calculateUrlBase((HttpServletRequest)request, (String)("element/node.jsp?node=" + nodeIdString)));
            }
        }
        catch (SQLException e) {
            throw new ServletException("Database exception", (Throwable)e);
        }
        catch (Throwable e) {
            throw new ServletException("Exception sending node label change event", e);
        }
    }

    protected void sendLabelChangeEvent(int nodeId, NodeLabel oldNodeLabel, NodeLabel newNodeLabel) throws EventProxyException {
        EventBuilder bldr = new EventBuilder("uei.opennms.org/nodes/nodeLabelChanged", "NodeLabelChangeServlet");
        bldr.setNodeid((long)nodeId);
        bldr.setHost("host");
        if (oldNodeLabel != null) {
            bldr.addParam("oldNodeLabel", oldNodeLabel.getLabel());
            bldr.addParam("oldNodeLabelSource", oldNodeLabel.getSource());
        }
        if (newNodeLabel != null) {
            bldr.addParam("newNodeLabel", newNodeLabel.getLabel());
            bldr.addParam("newNodeLabelSource", newNodeLabel.getSource());
        }
        this.proxy.send(bldr.getEvent());
    }
}

