/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.map;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.web.map.MapNotFoundException;
import org.opennms.web.map.ResponseAssembler;
import org.opennms.web.map.view.Manager;
import org.opennms.web.map.view.VMap;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.Controller;

public class RefreshMapController
implements Controller {
    ThreadCategory log;
    private Manager manager;

    public Manager getManager() {
        return this.manager;
    }

    public void setManager(Manager manager) {
        this.manager = manager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ModelAndView handleRequest(HttpServletRequest request, HttpServletResponse response) throws IOException {
        ThreadCategory.setPrefix((String)"OpenNMS.Map");
        this.log = ThreadCategory.getInstance(this.getClass());
        String action = request.getParameter("action");
        this.log.debug("Received action=" + action);
        BufferedWriter bw = new BufferedWriter(new OutputStreamWriter((OutputStream)response.getOutputStream(), "UTF-8"));
        VMap map = null;
        try {
            map = this.manager.openMap();
            if (action.equals("Refresh")) {
                map = this.manager.refreshMap(map);
            }
            if (action.equals("Reload")) {
                map = this.manager.reloadMap(map);
            }
            if (map == null) {
                throw new MapNotFoundException();
            }
            bw.write(ResponseAssembler.getRefreshResponse(map));
        }
        catch (Throwable e) {
            this.log.error("Error while refreshing map. Action " + action, e);
            bw.write(ResponseAssembler.getMapErrorResponse(action));
        }
        finally {
            bw.close();
        }
        return null;
    }
}

