/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.graph;

import java.util.Calendar;
import java.util.GregorianCalendar;

public class RelativeTimePeriod {
    private static final RelativeTimePeriod[] s_defaultPeriods = new RelativeTimePeriod[]{new RelativeTimePeriod("lastday", "Last Day", 5, -1), new RelativeTimePeriod("lastweek", "Last Week", 5, -7), new RelativeTimePeriod("lastmonth", "Last Month", 5, -31), new RelativeTimePeriod("lastyear", "Last Year", 5, -366)};
    private String m_id = null;
    private String m_name = null;
    private int m_offsetField = 5;
    private int m_offsetAmount = -1;

    public RelativeTimePeriod() {
    }

    public RelativeTimePeriod(String id, String name, int offsetField, int offsetAmount) {
        this.m_id = id;
        this.m_name = name;
        this.m_offsetField = offsetField;
        this.m_offsetAmount = offsetAmount;
    }

    public String getId() {
        return this.m_id;
    }

    public void setId(String id) {
        this.m_id = id;
    }

    public String getName() {
        return this.m_name;
    }

    public void setName(String name) {
        this.m_name = name;
    }

    public int getOffsetField() {
        return this.m_offsetField;
    }

    public void setOffsetField(int offsetField) {
        this.m_offsetField = offsetField;
    }

    public int getOffsetAmount() {
        return this.m_offsetAmount;
    }

    public void setOffsetAmount(int offsetAmount) {
        this.m_offsetAmount = offsetAmount;
    }

    public static RelativeTimePeriod[] getDefaultPeriods() {
        return s_defaultPeriods;
    }

    public static RelativeTimePeriod getPeriodByIdOrDefault(String id) {
        return RelativeTimePeriod.getPeriodByIdOrDefault(s_defaultPeriods, id, s_defaultPeriods[0]);
    }

    public static RelativeTimePeriod getPeriodByIdOrDefault(RelativeTimePeriod[] periods, String id, RelativeTimePeriod defaultPeriod) {
        RelativeTimePeriod chosenPeriod = defaultPeriod;
        for (RelativeTimePeriod period : periods) {
            if (!period.getId().equals(id)) continue;
            chosenPeriod = period;
            break;
        }
        return chosenPeriod;
    }

    public long[] getStartAndEndTimes() {
        GregorianCalendar cal = new GregorianCalendar();
        long end = cal.getTime().getTime();
        ((Calendar)cal).add(this.getOffsetField(), this.getOffsetAmount());
        long start = cal.getTime().getTime();
        return new long[]{start, end};
    }
}

