/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.element;

import java.util.HashMap;
import java.util.Map;

public class StpInterface {
    int m_nodeId;
    int m_bridgeport;
    int m_ifindex;
    int m_stpportstate;
    int m_stpportpathcost;
    int m_stpportdesignatedcost;
    int m_stpvlan;
    String m_ipaddr;
    String m_stpdesignatedroot;
    String m_stpdesignatedbridge;
    String m_stpdesignatedport;
    String m_lastPollTime;
    char m_status;
    int m_stprootnodeid;
    int m_stpbridgenodeid;
    public static final String[] STP_PORT_STATUS = new String[]{null, "Disabled", "Blocking", "Listening", "Learning", "Forwarding", "Broken"};
    private static final Map<Character, String> statusMap = new HashMap<Character, String>();

    StpInterface() {
    }

    StpInterface(int nodeId, int bridgeport, int ifindex, int stpportstate, int stpportpathcost, int stpportdesignatedcost, int stpvlan, String stpdesignatedroot, String stpdesignatedbridge, String stpdesignatedport, String lastPollTime, char status, int stprootnodeid, int stpbridgenodeid) {
        this.m_nodeId = nodeId;
        this.m_bridgeport = bridgeport;
        this.m_ifindex = ifindex;
        this.m_stpportstate = stpportstate;
        this.m_stpportpathcost = stpportpathcost;
        this.m_stpportdesignatedcost = stpportdesignatedcost;
        this.m_stpvlan = stpvlan;
        this.m_stpdesignatedbridge = stpdesignatedbridge;
        this.m_stpdesignatedroot = stpdesignatedroot;
        this.m_stpdesignatedport = stpdesignatedport;
        this.m_lastPollTime = lastPollTime;
        this.m_status = status;
        this.m_stprootnodeid = stprootnodeid;
        this.m_stpbridgenodeid = stpbridgenodeid;
    }

    public String toString() {
        StringBuffer str = new StringBuffer("Node Id = " + this.m_nodeId + "\n");
        str.append("Bridge number of ports = " + this.m_bridgeport + "\n");
        str.append("At Last Poll Time = " + this.m_lastPollTime + "\n");
        str.append("Node At Status= " + this.m_status + "\n");
        return str.toString();
    }

    public int get_bridgeport() {
        return this.m_bridgeport;
    }

    public int get_ifindex() {
        return this.m_ifindex;
    }

    public String get_lastPollTime() {
        return this.m_lastPollTime;
    }

    public int get_nodeId() {
        return this.m_nodeId;
    }

    public char get_status() {
        return this.m_status;
    }

    public String get_stpdesignatedbridge() {
        return this.m_stpdesignatedbridge;
    }

    public String get_stpdesignatedport() {
        return this.m_stpdesignatedport;
    }

    public String get_stpdesignatedroot() {
        return this.m_stpdesignatedroot;
    }

    public int get_stpportdesignatedcost() {
        return this.m_stpportdesignatedcost;
    }

    public int get_stpportpathcost() {
        return this.m_stpportpathcost;
    }

    public int get_stpportstate() {
        return this.m_stpportstate;
    }

    public String getStpPortState() {
        try {
            return STP_PORT_STATUS[this.m_stpportstate];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return STP_PORT_STATUS[1];
        }
    }

    public int get_stpvlan() {
        return this.m_stpvlan;
    }

    public int get_stpbridgenodeid() {
        return this.m_stpbridgenodeid;
    }

    public int get_stprootnodeid() {
        return this.m_stprootnodeid;
    }

    public String get_ipaddr() {
        return this.m_ipaddr;
    }

    public void set_ipaddr(String m_ipaddr) {
        this.m_ipaddr = m_ipaddr;
    }

    public String getStatusString() {
        return statusMap.get(new Character(this.m_status));
    }

    public String getVlanColorIdentifier() {
        int red = 128;
        int green = 128;
        int blue = 128;
        int redoffset = 47;
        int greenoffset = 29;
        int blueoffset = 23;
        if (this.m_stpvlan == 0) {
            return "";
        }
        if (this.m_stpvlan == 1) {
            return "#FFFFFF";
        }
        red = (red + this.m_stpvlan * redoffset) % 255;
        green = (green + this.m_stpvlan * greenoffset) % 255;
        blue = (blue + this.m_stpvlan * blueoffset) % 255;
        if (red < 64) {
            red += 64;
        }
        if (green < 64) {
            green += 64;
        }
        if (blue < 64) {
            blue += 64;
        }
        return "#" + Integer.toHexString(red) + Integer.toHexString(green) + Integer.toHexString(blue);
    }

    static {
        statusMap.put(Character.valueOf('A'), "Active");
        statusMap.put(Character.valueOf('K'), "Unknown");
        statusMap.put(Character.valueOf('D'), "Deleted");
        statusMap.put(Character.valueOf('N'), "Not Active");
    }
}

