/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.controller.outage;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.opennms.netmgt.model.outage.OutageSummary;
import org.opennms.web.outage.WebOutageRepository;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.AbstractController;

public class OutageBoxController
extends AbstractController
implements InitializingBean {
    public static final int ROWS = 12;
    private WebOutageRepository m_webOutageRepository;
    private String m_successView;

    protected ModelAndView handleRequestInternal(HttpServletRequest request, HttpServletResponse response) throws Exception {
        int rows = Integer.getInteger("opennms.nodesWithOutages.count", 12);
        String parm = request.getParameter("outageCount");
        if (parm != null) {
            try {
                rows = Integer.valueOf(parm);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        OutageSummary[] summaries = this.m_webOutageRepository.getCurrentOutages(rows);
        int outagesRemaining = this.m_webOutageRepository.countCurrentOutages() - summaries.length;
        ModelAndView modelAndView = new ModelAndView(this.getSuccessView());
        modelAndView.addObject("summaries", (Object)summaries);
        modelAndView.addObject("moreCount", (Object)outagesRemaining);
        return modelAndView;
    }

    private String getSuccessView() {
        return this.m_successView;
    }

    public void setSuccessView(String successView) {
        this.m_successView = successView;
    }

    public void setWebOutageRepository(WebOutageRepository webOutageRepository) {
        this.m_webOutageRepository = webOutageRepository;
    }

    public void afterPropertiesSet() {
        Assert.notNull((Object)this.m_successView, (String)"property successView must be set");
        Assert.notNull((Object)this.m_webOutageRepository, (String)"webOutageRepository must be set");
    }
}

